function [correct, total] = testing_opt(Ps, s_states, update_plan, call_length, date_range, length_range,nr,s)
% TESTING_OPT   Test the training matrix from TRAINING_OPT, using the reality-mining dataset
%   [correct, total] = testing_opt(Ps, s_states, update_plan, call_length, date_range, length_range, nr, s)
%     return: number correct, and number tested
%     
%     Ps: P matrix from training_opt
%     s_states: unique list of transitions from training_opt
%     update_plan: 1 = always-update, 2 = LA only, 3 = Forming LA
%     call_length: assumed call length
%     date_range: date range tested
%     length_range: lengths of time tested 
%     nr: number of samples
%     s: reality-mining data structure

log_eps = log(1/1013); % set zero probabilities to this

% keep track of total segments considered and correctly classified
total = 0;
correct = 0;
trans_sizes = [];

for n = 1:size(s,2)

    if size(s(n).locs,1) == 0 % skip users with no location data
        continue;
    end;
    
    call_times = [s(n).comm_voice_date, s(n).comm_voice_date + call_length];
    
    % define starts either by sampling, or explicitly specifying
    starts = [];
    if length_range(1) >= datenum([0,0,30,0,0,0])
        starts = date_range(1); % test only for the month
    else
        starts = date_range(1) + rand(nr) * (date_range(2) - date_range(1));
    end;
    
    for st_n = 1:size(starts,1) % for each starting point
        st = starts(st_n); % get start time
        
        % get a segment from  and include points only within
        % date range of interest
        locids = s(n).locs( ...
            st < s(n).locs(:,1) & s(n).locs(:,1) < st + length_range(2) & ...
            date_range(1) <= s(n).locs(:,1) & s(n).locs(:,1) <= date_range(2),:);
        
        % ignore null locids (zero)
        locids(locids(:,2)==0,:) = []; 
        
        % need at least one locid
        if size(locids,1) < 2
            % total = total + 1;
            continue;
        end;
        
        if update_plan ~= 1
            if isempty(call_times) || update_plan == 2
                locids = floor(locids); % LACs only        
            else
                for t = 1:size(locids,1)
                    if ~sum(call_times(:,1) < locids(t,1) & locids(t,1) < call_times(:,2))
                        % next conditional if fullids after lac change
                        if (t > 1 && floor(locids(t,2)) == floor(locids(t-1,2)))
                            locids(t,2) = floor(locids(t,2));
                        end;
                    end;
                end;
            end;
        end;
        
        
        % convert to two columns for transitions
        transitions = [locids(1:end-1,2) locids(2:end,2)];
        
        % filter out same transitions
        transitions(transitions(:,1) == transitions(:,2),:) = [];
        
        % at least one unique transition
        if size(transitions,1) < 1
            total = total + 1;
            continue;
        end;
        
        % get unique rows
        [u, ~, ic] = unique(transitions, 'rows');        
        trans_sizes = size(u,1);
        
        % get counts of unique rows
        trans_counts = [u, histc(ic, 1:length(u))];
        
        % initialize variables to track maximum probability
        max_subject_prob = -Inf; 
        max_subject = -1;        
        
        for j = 1:size(s,2) % consider a test user
            
            trans_counts_prob = [trans_counts, repmat(log_eps,size(trans_counts,1),1)];
            
            for pr = 1:size(trans_counts_prob,1)
                st_i = trans_counts_prob(pr,1);
                st_j = trans_counts_prob(pr,2);
                
                prob = Ps{j}(s_states{j}==st_i,s_states{j}==st_j);
                if update_plan > 2 
                    prob1 = Ps{j}(s_states{j}==st_i,s_states{j}==floor(st_j));
                    if ~isempty(prob1) && (isempty(prob) || prob < prob1)
                        prob = prob1;
                    end;
                    
                end;
                if ~isempty(prob) && prob > 0
                    trans_counts_prob(pr,4) = log(prob);
                end;

            end;
            
            subject_prob = sum(trans_counts_prob(:,3) .* trans_counts_prob(:,4));
            if subject_prob > max_subject_prob % track maximum so far
                max_subject_prob = subject_prob;
                max_subject = j;
            end;
        end;

        if max_subject == n % test correctness
            correct = correct + 1;
        end;
        total = total + 1;
    end;
end;
