/*
 * Decompiled with CFR 0.152.
 */
package vis;

import java.util.ArrayList;
import java.util.List;
import util.io.IOUtil;
import vis.FeatureVectorStructure;

public class VisualFeatureParser {
    public static void main(String[] args) {
        String root = "D:\\mediaeval\\resources\\sift\\";
        ArrayList<String> siftFlickrFiles = new ArrayList<String>();
        siftFlickrFiles.add(String.valueOf(root) + "Amsterdam_FlickrSIFT.bow");
        siftFlickrFiles.add(String.valueOf(root) + "Barcelona_FlickrSIFT.bow");
        siftFlickrFiles.add(String.valueOf(root) + "London_FlickrSIFT.bow");
        siftFlickrFiles.add(String.valueOf(root) + "Paris_FlickrSIFT.bow");
        siftFlickrFiles.add(String.valueOf(root) + "Raphael_FlickrSIFT.bow");
        siftFlickrFiles.add(String.valueOf(root) + "Rome_FlickrSIFT.bow");
        String siftFlickrFile = String.valueOf(root) + "all_FlickrSIFT.bow";
        VisualFeatureParser parser = new VisualFeatureParser();
        FeatureVectorStructure feats = parser.readMultipleFeatureVectors(siftFlickrFiles);
        feats.writeToFile(siftFlickrFile);
        System.out.println(feats.getNumberOfFeatures());
        System.out.println(feats.getNumberOfVectors());
        int i = 0;
        while (i < feats.getFeatureVector(0).length) {
            System.out.print(String.valueOf(feats.getFeatureVector(0)[i]) + " ");
            ++i;
        }
    }

    public FeatureVectorStructure readMultipleFeatureVectors(List<String> siftFlickrFiles) {
        ArrayList<String> featureLines = new ArrayList<String>();
        for (String siftFlickrFile : siftFlickrFiles) {
            featureLines.addAll(IOUtil.readFileToStringList(siftFlickrFile));
        }
        return this.readFeatureVectors(featureLines);
    }

    public FeatureVectorStructure readFeatureVectors(String siftFlickrFile) {
        List<String> featureLines = IOUtil.readFileToStringList(siftFlickrFile);
        return this.readFeatureVectors(featureLines);
    }

    protected FeatureVectorStructure readFeatureVectors(List<String> featureLines) {
        String[] parts = featureLines.get(0).split(" ");
        int M = parts.length - 1;
        FeatureVectorStructure feats = new FeatureVectorStructure(featureLines.size(), M);
        int i = 0;
        while (i < featureLines.size()) {
            parts = featureLines.get(i).split(" ");
            double[] featureValues = new double[M];
            int x = 1;
            while (x < parts.length) {
                featureValues[x - 1] = Double.parseDouble(parts[x]);
                ++x;
            }
            feats.addFeatureVector(Long.parseLong(parts[0]), featureValues);
            ++i;
        }
        return feats;
    }

    public FeatureVectorStructure readFeatureVectors(String flickrIdList, String siftFile) {
        List<String> flickrIds = IOUtil.readFileToStringList(flickrIdList);
        List<String> featureLines = IOUtil.readFileToStringList(siftFile);
        if (flickrIds.size() != featureLines.size() - 1) {
            throw new IllegalArgumentException("Mismatch between flickr id and sift files: " + flickrIds.size() + " vs " + (featureLines.size() - 1));
        }
        String[] parts = featureLines.get(0).split(" ");
        int M = parts.length - 1;
        FeatureVectorStructure feats = new FeatureVectorStructure(flickrIds.size(), M);
        int i = 0;
        while (i < flickrIds.size()) {
            parts = featureLines.get(i).split(" ");
            double[] featureValues = new double[M];
            int x = 1;
            while (x < parts.length) {
                featureValues[x - 1] = Double.parseDouble(parts[x]);
                ++x;
            }
            feats.addFeatureVector(Long.parseLong(flickrIds.get(i)), featureValues);
            ++i;
        }
        return feats;
    }
}

