/*
 * Decompiled with CFR 0.152.
 */
package vis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import util.io.IOUtil;

public class FeatureVectorStructure {
    private double[] featureValues;
    private int numberOfFeatures;
    private int numberOfVectors;
    protected Map<Integer, Long> indexToFlickrIds = new HashMap<Integer, Long>();
    protected Map<Long, Integer> flickrIdsToIndex = new HashMap<Long, Integer>();
    protected int currentIdx = 0;

    public FeatureVectorStructure(int numberOfVectors, int numberOfFeatures) {
        this.featureValues = new double[numberOfVectors * numberOfFeatures];
        this.numberOfVectors = numberOfVectors;
        this.numberOfFeatures = numberOfFeatures;
    }

    public void addFeatureVector(long flickrId, double[] featureValues) {
        if (this.currentIdx < 0 || this.currentIdx >= this.numberOfVectors) {
            throw new IllegalArgumentException(String.valueOf(this.currentIdx) + " exceeded vector bounds " + featureValues[0] + " " + featureValues[1] + " " + featureValues[2]);
        }
        if (this.flickrIdsToIndex.containsKey(flickrId)) {
            return;
        }
        this.indexToFlickrIds.put(this.currentIdx, flickrId);
        this.flickrIdsToIndex.put(flickrId, this.currentIdx);
        System.arraycopy(featureValues, 0, this.featureValues, this.currentIdx * this.numberOfFeatures, this.numberOfFeatures);
        ++this.currentIdx;
    }

    public double[] getFeatureVector(long flickrId) {
        Integer idx = this.flickrIdsToIndex.get(flickrId);
        if (idx < 0) {
            throw new IllegalArgumentException("Flickr id: " + flickrId + " not available in feature database!");
        }
        return this.getFeatureVector(idx);
    }

    public double[] getFeatureVector(int i) {
        if (i < 0 || i >= this.numberOfVectors) {
            throw new IllegalArgumentException(String.valueOf(i) + " exceeded vector bounds " + this.featureValues[0] + " " + this.featureValues[1] + " " + this.featureValues[2]);
        }
        double[] values = new double[this.numberOfFeatures];
        System.arraycopy(this.featureValues, i * this.numberOfFeatures, values, 0, this.numberOfFeatures);
        return values;
    }

    public long getFlickrId(int i) {
        return this.indexToFlickrIds.get(i);
    }

    public int getNumberOfFeatures() {
        return this.numberOfFeatures;
    }

    public int getNumberOfVectors() {
        return this.numberOfVectors;
    }

    public void writeToFile(String file) {
        this.writeToFile(file, this.flickrIdsToIndex.keySet());
    }

    public void writeToFile(String file, Set<Long> selectedFlickrIds) {
        ArrayList<String> linesToWrite = new ArrayList<String>(this.currentIdx);
        int i = 0;
        while (i < this.currentIdx) {
            StringBuffer buf = new StringBuffer();
            Long flickrId = this.indexToFlickrIds.get(i);
            if (selectedFlickrIds.contains(flickrId)) {
                buf.append(flickrId);
                double[] feats = this.getFeatureVector(i);
                int x = 0;
                while (x < this.getNumberOfFeatures()) {
                    buf.append(" " + (int)feats[x]);
                    ++x;
                }
                linesToWrite.add(buf.toString());
            }
            ++i;
        }
        IOUtil.writeStringCollectionToFile(linesToWrite, file);
    }
}

