/*
 * Decompiled with CFR 0.152.
 */
package vis;

import dataset.create.PhotoCopy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import util.io.IOUtil;

public class ConceptDetectorParser {
    public static void main(String[] args) {
        String flickrListFile = "D:\\mediaeval\\resources\\concept_detectors\\Paris\\Paris_list.txt";
        String conceptAnnotationFile = "D:\\mediaeval\\resources\\concept_detectors\\Paris\\Paris.predict";
        ConceptDetectorParser parser = new ConceptDetectorParser();
        List<VisualConceptAnnotation> annotations = parser.readVisualConceptAnnotations(flickrListFile, conceptAnnotationFile);
        System.out.println(annotations.size());
        Collections.sort(annotations, Collections.reverseOrder());
        ArrayList<String> idsToCopy = new ArrayList<String>(100);
        int i = 0;
        while (i < 100) {
            System.out.println(annotations.get(i));
            idsToCopy.add(String.valueOf(annotations.get(i).getFlickrId()));
            ++i;
        }
        String soccerPhotoList = "D:\\mediaeval\\resources\\concept_detectors\\test\\ids.txt";
        IOUtil.writeStringCollectionToFile(idsToCopy, soccerPhotoList);
        String srcPhotoDir = "D:\\mediaeval\\dataset\\photos\\Paris\\";
        String dstPhotoDir = "D:\\mediaeval\\resources\\concept_detectors\\test\\";
        PhotoCopy.copyFlickrImagesToFlatFolder(soccerPhotoList, srcPhotoDir, dstPhotoDir, ".jpg");
    }

    public List<VisualConceptAnnotation> readVisualConceptAnnotations(String flickrListFile, String conceptAnnotationFile) {
        List<String> flickrIds = IOUtil.readFileToStringList(flickrListFile);
        List<String> annotationResults = IOUtil.readFileToStringList(conceptAnnotationFile);
        if (flickrIds.size() + 1 != annotationResults.size()) {
            throw new IllegalArgumentException("The id list and annotation result files are not consistent: " + flickrIds.size() + " vs " + annotationResults.size());
        }
        ArrayList<VisualConceptAnnotation> results = new ArrayList<VisualConceptAnnotation>(flickrIds.size());
        int i = 0;
        while (i < flickrIds.size()) {
            long flickrId = Long.parseLong(flickrIds.get(i).substring(0, flickrIds.get(i).length() - 4));
            String annotation = annotationResults.get(i + 1);
            String[] parts = annotation.split(" ");
            double probability = Double.parseDouble(parts[1]);
            results.add(new VisualConceptAnnotation(flickrId, probability));
            ++i;
        }
        return results;
    }

    public class VisualConceptAnnotation
    implements Comparable<VisualConceptAnnotation> {
        private long flickrId;
        private double probabilityOfPresence;

        public VisualConceptAnnotation(long flickrId, double probabilityOfPresence) {
            this.flickrId = flickrId;
            this.probabilityOfPresence = probabilityOfPresence;
        }

        public long getFlickrId() {
            return this.flickrId;
        }

        public double getProbabilityOfPresence() {
            return this.probabilityOfPresence;
        }

        @Override
        public int compareTo(VisualConceptAnnotation o) {
            if (this.getProbabilityOfPresence() < o.getProbabilityOfPresence()) {
                return -1;
            }
            if (this.getProbabilityOfPresence() > o.getProbabilityOfPresence()) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return String.valueOf(this.flickrId) + ", " + this.probabilityOfPresence;
        }
    }
}

