/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import clust.ImageSimilarity;
import edu.uci.ics.jung.graph.UndirectedSparseMultigraph;
import edu.uci.ics.jung.graph.util.Pair;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class JungGraphWriter {
    public static void writeGraph(String filename, UndirectedSparseMultigraph<Long, ImageSimilarity> graph) {
        try {
            BufferedWriter graphFileWriter = new BufferedWriter(new FileWriter(filename));
            graphFileWriter.write("nodes=" + graph.getVertexCount() + "\n");
            graphFileWriter.write("edges=" + graph.getEdgeCount() + "\n");
            graphFileWriter.write("\nNodes\n");
            for (Long tempNode : graph.getVertices()) {
                graphFileWriter.write(String.valueOf(tempNode.toString()) + "\n");
            }
            graphFileWriter.write("EndNodes\n");
            graphFileWriter.write("Nodes\n");
            for (ImageSimilarity tempEdge : graph.getEdges()) {
                Pair<Long> tempPairOfNodes = graph.getEndpoints(tempEdge);
                Long firstNode = tempPairOfNodes.getFirst();
                Long secondNode = tempPairOfNodes.getSecond();
                Float tempWeight = Float.valueOf(tempEdge.getWeight());
                ImageSimilarity.ImageSimilarityType tempSimilarityType = tempEdge.getType();
                graphFileWriter.write(String.valueOf(firstNode.toString()) + "\t" + secondNode.toString() + "\t" + tempWeight.toString() + "\t" + tempSimilarityType.toString() + "\n");
            }
            graphFileWriter.write("EndEdges\n");
            graphFileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

