/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import clust.ImageSimilarity;
import edu.uci.ics.jung.graph.UndirectedSparseMultigraph;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class JungGraphReader {
    public static UndirectedSparseMultigraph<Long, ImageSimilarity> readMultiGraph(String filename) {
        UndirectedSparseMultigraph<Long, ImageSimilarity> graph = new UndirectedSparseMultigraph<Long, ImageSimilarity>();
        try {
            BufferedReader graphFileReader = new BufferedReader(new FileReader(filename));
            String line = graphFileReader.readLine();
            line = graphFileReader.readLine();
            line = graphFileReader.readLine();
            line = graphFileReader.readLine();
            System.out.print("Begin reading the nodes...");
            while (!(line = graphFileReader.readLine()).equals("EndNodes")) {
                line = line.trim();
                graph.addVertex(Long.parseLong(line));
            }
            System.out.println("End");
            line = graphFileReader.readLine();
            System.out.print("Begin reading the edges...");
            while (!(line = graphFileReader.readLine()).equals("EndEdges")) {
                line = line.trim();
                StringTokenizer st = new StringTokenizer(line, "\t");
                Long firstNode = Long.parseLong(st.nextToken());
                Long secondNode = Long.parseLong(st.nextToken());
                String weight = st.nextToken();
                String type = st.nextToken();
                ImageSimilarity tempImageSimilarity = new ImageSimilarity(ImageSimilarity.ImageSimilarityType.valueOf(type), Float.parseFloat(weight));
                graph.addEdge(tempImageSimilarity, firstNode, secondNode);
            }
            System.out.println("End");
            graphFileReader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return graph;
    }
}

