/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class IOUtil {
    public static void main(String[] args) {
        String root = "D:\\shared\\Dublin-spatioTemporal\\";
        String inFile = String.valueOf(root) + "spatioTemporalPhotoInfo_Dublin.csv";
        List<String> lines = IOUtil.readFileToStringList(inFile);
        System.out.println(lines.size());
        HashSet<String> users = new HashSet<String>();
        for (String line : lines) {
            String[] parts = line.split("\t");
            users.add(parts[1]);
        }
        System.out.println(users.size());
    }

    public static void addEmptyFieldInTheBeginning(String inputFile, String outputFile) {
        List<String> lines = IOUtil.readFileToStringList(inputFile);
        ArrayList<String> outLines = new ArrayList<String>();
        for (String line : lines) {
            outLines.add(";" + line);
        }
        IOUtil.writeStringCollectionToFile(outLines, outputFile);
    }

    public static List<String> readFileToUniqueStringList(String textFile) {
        HashSet<String> stringSet;
        block5: {
            stringSet = new HashSet<String>();
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(textFile), "UTF8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    stringSet.add(line);
                }
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                if (reader == null) break block5;
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return new ArrayList<String>(stringSet);
    }

    public static List<String> readFileToStringList(String textFile) {
        ArrayList<String> stringList;
        block5: {
            stringList = new ArrayList<String>();
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(textFile), "UTF8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    stringList.add(line);
                }
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                if (reader == null) break block5;
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return stringList;
    }

    public static void writeStringCollectionToFile(Collection<String> stringCollection, String textFile) {
        block5: {
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(textFile), "UTF8"));
                for (String line : stringCollection) {
                    writer.append(line);
                    writer.newLine();
                }
                writer.close();
            }
            catch (IOException e) {
                if (writer == null) break block5;
                e.printStackTrace();
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static void copyFile(String inputFileName, String outputFileName) {
        File inputFile = new File(inputFileName);
        File outputFile = new File(outputFileName);
        IOUtil.copyFile(inputFile, outputFile);
    }

    public static void copyFile(File inputFile, File outputFile) {
        try {
            int c;
            FileInputStream in = new FileInputStream(inputFile);
            FileOutputStream out = new FileOutputStream(outputFile);
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            in.close();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getPhotoLocalPath(Long flickrId) {
        String memberStringValue = flickrId.toString();
        while (memberStringValue.length() < 12) {
            memberStringValue = "0" + memberStringValue;
        }
        String filepath = String.valueOf(memberStringValue.substring(0, 3)) + File.separator + memberStringValue.substring(3, 6) + File.separator + memberStringValue.substring(6, 9) + File.separator + flickrId.toString() + ".jpg";
        return filepath;
    }

    public static void createDirectory(String directory) {
        File dir = new File(directory);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("Could not create directory: " + directory);
        }
    }
}

