/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.shef.wit.simmetrics.similaritymetrics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import uk.ac.shef.wit.simmetrics.similaritymetrics.AbstractStringMetric;
import uk.ac.shef.wit.simmetrics.tokenisers.InterfaceTokeniser;
import uk.ac.shef.wit.simmetrics.tokenisers.TokeniserWhitespace;

public final class MatchingCoefficient
extends AbstractStringMetric
implements Serializable {
    private final float ESTIMATEDTIMINGCONST = 2.0E-4f;
    private final InterfaceTokeniser tokeniser;

    public MatchingCoefficient() {
        this.tokeniser = new TokeniserWhitespace();
    }

    public MatchingCoefficient(InterfaceTokeniser tokeniserToUse) {
        this.tokeniser = tokeniserToUse;
    }

    public String getShortDescriptionString() {
        return "MatchingCoefficient";
    }

    public String getLongDescriptionString() {
        return "Implements the Matching Coefficient algorithm providing a similarity measure between two strings";
    }

    public String getSimilarityExplained(String string1, String string2) {
        return null;
    }

    public float getSimilarityTimingEstimated(String string1, String string2) {
        float str1Tokens = this.tokeniser.tokenizeToArrayList(string1).size();
        float str2Tokens = this.tokeniser.tokenizeToArrayList(string2).size();
        return str2Tokens * str1Tokens * 2.0E-4f;
    }

    public float getSimilarity(String string1, String string2) {
        ArrayList<String> str1Tokens = this.tokeniser.tokenizeToArrayList(string1);
        ArrayList<String> str2Tokens = this.tokeniser.tokenizeToArrayList(string2);
        int totalPossible = Math.max(str1Tokens.size(), str2Tokens.size());
        return this.getUnNormalisedSimilarity(string1, string2) / (float)totalPossible;
    }

    public float getUnNormalisedSimilarity(String string1, String string2) {
        ArrayList<String> str1Tokens = this.tokeniser.tokenizeToArrayList(string1);
        ArrayList<String> str2Tokens = this.tokeniser.tokenizeToArrayList(string2);
        int totalFound = 0;
        Iterator<String> i$ = str1Tokens.iterator();
        while (i$.hasNext()) {
            String str1Token;
            String sToken = str1Token = i$.next();
            boolean found = false;
            for (String str2Token : str2Tokens) {
                String tToken = str2Token;
                if (!sToken.equals(tToken)) continue;
                found = true;
            }
            if (!found) continue;
            ++totalFound;
        }
        return totalFound;
    }
}

