/*
 * Decompiled with CFR 0.152.
 */
package tag;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Set;

public class TagFilterer {
    private static final int MIN_TAG_LENGTH = 2;
    private static final int MAX_TAG_LENGTH = 30;
    private static final int MIN_CHARACTERS = 2;
    private static final Set<String> uselessTagset = new HashSet<String>();
    private static final String[] uselessTags = new String[]{"geotagged", "photos", "fotos", "photo", "foto", "24-70 f2.8g", "70.0-200.0 mm", "3d7ps", "pd5", "4d8", "5d7", "d80"};
    private static final String[] CAMERA_BRANDS = new String[]{"nikon", "sony", "canon", "olympus", "panasonic"};

    public static void processTagPhotosFile(String inputFile, String outputFile) throws IOException {
        try {
            String line;
            BufferedReader inputReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), "UTF8"));
            BufferedWriter outputWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF8"));
            int counter = 0;
            int counterInvalidTags = 0;
            while ((line = inputReader.readLine()) != null) {
                System.out.print("Starting line " + ++counter + "...");
                long time = System.currentTimeMillis();
                String[] parts = line.split("\t");
                if (TagFilterer.acceptTag(parts[0])) {
                    outputWriter.write(String.valueOf(parts[0].trim()) + "\t");
                    int i = 1;
                    while (i < parts.length) {
                        outputWriter.write(String.valueOf(parts[i]) + "\t");
                        ++i;
                    }
                    outputWriter.write("\n");
                } else {
                    ++counterInvalidTags;
                }
                time = System.currentTimeMillis() - time;
                System.out.println("END... " + time + " milliseconds");
            }
            System.out.println(counterInvalidTags);
            inputReader.close();
            outputWriter.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void processPhotoTagsFile(String inputFile, String outputFile) throws IOException {
        try {
            String line;
            BufferedReader inputReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), "UTF8"));
            BufferedWriter outputWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF8"));
            int counter = 0;
            while ((line = inputReader.readLine()) != null) {
                System.out.print("Starting line " + ++counter + "...");
                long time = System.currentTimeMillis();
                String[] parts = line.split("\t");
                outputWriter.write(String.valueOf(parts[0]) + "\t");
                int i = 1;
                while (i < parts.length) {
                    if (TagFilterer.acceptTag(parts[i])) {
                        outputWriter.write(String.valueOf(parts[i].trim()) + "\t");
                    }
                    ++i;
                }
                outputWriter.write("\n");
                time = System.currentTimeMillis() - time;
                System.out.println("END... " + time + " milliseconds");
            }
            inputReader.close();
            outputWriter.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean acceptTag(Set<String> usernames, String tag) {
        if (TagFilterer.isUsername(usernames, tag)) {
            return false;
        }
        return TagFilterer.acceptTag(tag);
    }

    public static boolean acceptTag(String tag) {
        if (TagFilterer.isTagVeryShortOrVeryLong(tag)) {
            return false;
        }
        if (TagFilterer.containsTooFewLetters(tag)) {
            return false;
        }
        if (TagFilterer.isNumeric(tag)) {
            return false;
        }
        if (TagFilterer.isUseless(tag)) {
            return false;
        }
        if (TagFilterer.isCameraModel(tag)) {
            return false;
        }
        return !TagFilterer.isMachineTag(tag);
    }

    public static boolean isTagVeryShortOrVeryLong(String tag) {
        return tag.length() < 2 || tag.length() > 30;
    }

    public static boolean isMachineTag(String tag) {
        return tag.contains(":") && tag.contains("=");
    }

    public static boolean containsTooFewLetters(String tag) {
        int nrLetters = 0;
        int i = 0;
        while (i < tag.length()) {
            if (Character.isLetter(tag.charAt(i))) {
                ++nrLetters;
            }
            ++i;
        }
        return nrLetters < 2;
    }

    public static boolean containsWordsWithNumerics(String tag) {
        String[] parts = tag.split(" ");
        int i = 0;
        while (i < parts.length) {
            boolean hasDigits = false;
            boolean hasLetters = false;
            int x = 0;
            while (x < parts[i].length()) {
                if (Character.isDigit(parts[i].charAt(x))) {
                    hasDigits = true;
                } else if (Character.isLetter(parts[i].charAt(x))) {
                    hasLetters = true;
                }
                if (hasDigits && hasLetters) {
                    return true;
                }
                ++x;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsFullNumeric(String tag) {
        String[] parts = tag.split(" ");
        int i = 0;
        while (i < parts.length) {
            if (TagFilterer.isNumeric(parts[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isNumeric(String tag) {
        int x = 0;
        while (x < tag.length()) {
            if (!Character.isDigit(tag.charAt(x))) {
                return false;
            }
            ++x;
        }
        return true;
    }

    public static boolean isCameraModel(String tag) {
        int i = 0;
        while (i < CAMERA_BRANDS.length) {
            if (tag.contains(CAMERA_BRANDS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isUsername(Set<String> usernames, String tag) {
        return usernames.contains(tag.trim());
    }

    public static boolean isUseless(String tag) {
        if (uselessTagset.isEmpty()) {
            int i = 0;
            while (i < uselessTags.length) {
                uselessTagset.add(uselessTags[i]);
                ++i;
            }
        }
        return uselessTagset.contains(tag);
    }
}

