/*
 * Decompiled with CFR 0.152.
 */
package tag;

import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.shef.wit.simmetrics.similaritymetrics.AbstractStringMetric;
import uk.ac.shef.wit.simmetrics.similaritymetrics.Levenshtein;
import util.io.IOUtil;

public class SimilarTagFinder {
    private static final String SIMILAR_TAGS_FILE = "D:\\mediaeval\\resources\\similar_tag_models\\levenshtein.txt";
    private static final int MAX_ALLOWED_TAG_LENGTH_DIFFERENCE = 3;

    public static Map<String, String> generateSimilarTagMap(Map<String, Set<Long>> tagPhotosMap) {
        Map<String, String> similarTagMap = SimilarTagFinder.loadTagSimilarityMap();
        if (similarTagMap != null) {
            return similarTagMap;
        }
        similarTagMap = new HashMap<String, String>();
        ArrayList<List<String>> similarTagLists = new ArrayList<List<String>>();
        ArrayList<String> tagList = new ArrayList<String>(tagPhotosMap.keySet());
        HashSet<String> usedTags = new HashSet<String>();
        System.out.println(String.valueOf(tagList.size()) + " tags");
        int i = 0;
        while (i < tagList.size()) {
            if (!usedTags.contains(tagList.get(i))) {
                List<String> similars = SimilarTagFinder.findSimilar((String)tagList.get(i), tagList);
                int maxFreqTagId = -1;
                int maxFreq = 0;
                int x = 0;
                while (x < similars.size()) {
                    int tagFreq = tagPhotosMap.get(similars.get(x)).size();
                    if (tagFreq > maxFreq) {
                        maxFreq = tagFreq;
                        maxFreqTagId = x;
                    }
                    ++x;
                }
                ArrayList<String> similarTagsList = new ArrayList<String>(similars.size());
                similarTagsList.add(similars.get(maxFreqTagId));
                int x2 = 0;
                while (x2 < similars.size()) {
                    if (x2 != maxFreqTagId) {
                        similarTagMap.put(similars.get(x2), similars.get(maxFreqTagId));
                        usedTags.add(similars.get(x2));
                        similarTagsList.add(similars.get(x2));
                    }
                    ++x2;
                }
                similarTagLists.add(similarTagsList);
            }
            ++i;
        }
        HashSet<String> toRemove = new HashSet<String>(similarTagMap.values());
        for (String tag : toRemove) {
            similarTagMap.remove(tag);
        }
        SimilarTagFinder.writeTagSimilaritiesToFile(similarTagLists);
        return similarTagMap;
    }

    public static Map<String, String> loadTagSimilarityMap() {
        String tagMapFile = SIMILAR_TAGS_FILE;
        if (!new File(tagMapFile).exists()) {
            return null;
        }
        System.out.println("Loading tag similarities from file...");
        HashMap<String, String> tagMap = new HashMap<String, String>();
        List<String> lines = IOUtil.readFileToStringList(tagMapFile);
        for (String line : lines) {
            String[] tags = line.split("\t");
            if (tags.length <= 1) continue;
            int i = 1;
            while (i < tags.length) {
                tagMap.put(tags[i], tags[0]);
                ++i;
            }
        }
        return tagMap;
    }

    public static void writeTagSimilaritiesToFile(List<List<String>> similarTagLists) {
        System.out.println("Writing tag similarities to file...");
        ArrayList<String> similarTagEntries = new ArrayList<String>(similarTagLists.size());
        for (List<String> similarTags : similarTagLists) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < similarTags.size()) {
                if (i > 0) {
                    buf.append("\t");
                }
                buf.append(similarTags.get(i));
                ++i;
            }
            similarTagEntries.add(buf.toString());
        }
        IOUtil.writeStringCollectionToFile(similarTagEntries, SIMILAR_TAGS_FILE);
    }

    public static List<String> findSimilar(String inputTag, List<String> candidateTags) {
        Levenshtein metric = new Levenshtein();
        ArrayList<SimilarTag> rankableSimilarTags = new ArrayList<SimilarTag>();
        int i = 0;
        while (i < candidateTags.size()) {
            float result;
            if (Math.abs(inputTag.length() - candidateTags.get(i).length()) <= 3 && (double)(result = ((AbstractStringMetric)metric).getSimilarity(inputTag, candidateTags.get(i))) >= 0.8) {
                rankableSimilarTags.add(new SimilarTag(candidateTags.get(i), result));
            }
            ++i;
        }
        Collections.sort(rankableSimilarTags, Collections.reverseOrder());
        if (rankableSimilarTags.size() > 0) {
            ArrayList<String> similars = new ArrayList<String>(rankableSimilarTags.size());
            for (SimilarTag stag : rankableSimilarTags) {
                similars.add(stag.getTag());
            }
            return similars;
        }
        return new ArrayList<String>();
    }

    public static boolean acceptFlickrTag(String tag) {
        if (tag.length() < 2 || tag.length() > 50) {
            return false;
        }
        return !tag.contains(":") || !tag.contains("=");
    }

    public static class SimilarTag
    implements Comparable<SimilarTag> {
        private static final DecimalFormat DF = new DecimalFormat("#.##");
        private String tag;
        private float similarity;

        public SimilarTag(String tag, float similarity) {
            this.tag = tag;
            this.similarity = similarity;
        }

        @Override
        public int compareTo(SimilarTag arg0) {
            float dif = this.getSimilarity() - arg0.getSimilarity();
            if ((double)dif < 0.0) {
                return -1;
            }
            if ((double)dif > 0.0) {
                return 1;
            }
            return 0;
        }

        public String getTag() {
            return this.tag;
        }

        public float getSimilarity() {
            return this.similarity;
        }

        public void setSimilarity(float similarity) {
            this.similarity = similarity;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SimilarTag) {
                return this.tag.equals(((SimilarTag)obj).getTag());
            }
            return false;
        }

        public int hashCode() {
            return this.tag.hashCode();
        }

        public String toString() {
            return String.valueOf(this.tag) + " (" + DF.format(this.similarity) + ")";
        }
    }
}

