/*
 * Decompiled with CFR 0.152.
 */
package tag;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;

public class FreqTag
implements Comparable<FreqTag> {
    private String tag;
    private int frequency;

    public FreqTag(String tag, int frequency) {
        this.tag = tag;
        this.frequency = frequency;
    }

    public static FreqTag fromTextEntry(String textEntry) {
        int index = textEntry.lastIndexOf(":");
        if (index < 0) {
            return null;
        }
        int freq = Integer.parseInt(textEntry.substring(index + 1, textEntry.length() - 1));
        return new FreqTag(textEntry.substring(1, index), freq);
    }

    public String toTextEntry() {
        return this.toString();
    }

    public String getTag() {
        return this.tag;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void increaseFrequency() {
        ++this.frequency;
    }

    public void setFrequency(int freq) {
        this.frequency = freq;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FreqTag) {
            return this.tag.equals(((FreqTag)obj).getTag());
        }
        return false;
    }

    public int hashCode() {
        return this.tag.hashCode();
    }

    public String toString() {
        return "[" + this.tag + ":" + this.frequency + "]";
    }

    @Override
    public int compareTo(FreqTag o) {
        return this.getFrequency() - o.getFrequency();
    }

    public static Iterator<FreqTag> getFreqTagIterator(String freqTagFile) {
        return new Iterator<FreqTag>(freqTagFile){
            private BufferedReader reader;
            {
                try {
                    this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF8"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.closeReader();
                }
            }

            @Override
            public boolean hasNext() {
                try {
                    boolean hasNext = this.reader.ready();
                    if (!hasNext) {
                        this.closeReader();
                    }
                    return hasNext;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.closeReader();
                    return false;
                }
            }

            @Override
            public FreqTag next() {
                String line;
                try {
                    line = this.reader.readLine();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.closeReader();
                    return null;
                }
                if (line == null) {
                    this.closeReader();
                    return null;
                }
                return FreqTag.fromTextEntry(line);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("This iterator does not support the remove() operation!");
            }

            private void closeReader() {
                if (this.reader != null) {
                    try {
                        this.reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
    }
}

