/*
 * Decompiled with CFR 0.152.
 */
package tag;

import java.util.ArrayList;
import java.util.List;
import model.FlickrImageMetadata;
import tag.TagFilterer;

public class FlickrPhotoTagExtractor {
    protected static final String TOKEN_SEPARATOR = "[\\.,:!\\?\\-\\(\\)#_ ;]";

    public static List<String> getTags(FlickrImageMetadata photo) {
        ArrayList<String> tags = new ArrayList<String>(photo.getTags().length);
        int i = 0;
        while (i < photo.getTags().length) {
            String candidateTag = photo.getTags()[i].toLowerCase();
            if (TagFilterer.acceptTag(candidateTag)) {
                tags.add(candidateTag);
            }
            ++i;
        }
        return tags;
    }

    public static List<String> getTagsTitle(FlickrImageMetadata photo) {
        List<String> tags = FlickrPhotoTagExtractor.getTags(photo);
        tags.addAll(FlickrPhotoTagExtractor.getTagsFromText(photo.getTitle()));
        return tags;
    }

    public static List<String> getTagsTitleDescription(FlickrImageMetadata photo) {
        List<String> tags = FlickrPhotoTagExtractor.getTagsTitle(photo);
        tags.addAll(FlickrPhotoTagExtractor.getTagsFromText(photo.getDescription()));
        return tags;
    }

    protected static List<String> getTagsFromText(String text) {
        if (text == null) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> tags = new ArrayList<String>();
        String[] tokens = text.toLowerCase().trim().split(TOKEN_SEPARATOR);
        int i = 0;
        while (i < tokens.length) {
            if (TagFilterer.acceptTag(tokens[i])) {
                tags.add(tokens[i]);
            }
            ++i;
        }
        return tags;
    }

    public static String normalizeText(String text) {
        String[] tokens = text.toLowerCase().trim().split(TOKEN_SEPARATOR);
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < tokens.length) {
            if (i > 0) {
                buf.append(" ");
            }
            buf.append(tokens[i]);
            ++i;
        }
        return buf.toString();
    }
}

