/*
 * Decompiled with CFR 0.152.
 */
package tag;

import dataset.create.PhotoCopy;
import dataset.create.PhotoGeoSeparator;
import geo.PlaceModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import model.FlickrImageMetadata;
import tag.FlickrPhotoTagExtractor;
import tag.FreqTag;
import util.io.IOUtil;

public class CityTagModelCreator {
    protected static final int MODEL_SIZE = 200;
    protected static final int MIN_TAG_FREQUENCY = 10;

    public static void main(String[] args) {
        ArrayList<PhotoGeoSeparator.PlaceDatasetSpecification> placeDatasetSpecs = new ArrayList<PhotoGeoSeparator.PlaceDatasetSpecification>(5);
        String mediaevalDatasetRoot = "D:/mediaeval/dataset/";
        String photoListRoot = String.valueOf(mediaevalDatasetRoot) + "city_photo_lists/";
        String photoRoot = String.valueOf(mediaevalDatasetRoot) + "photos/";
        String metadataRoot = String.valueOf(mediaevalDatasetRoot) + "metadata/";
        ArrayList<PhotoCopy.MediaevalCity> cities = new ArrayList<PhotoCopy.MediaevalCity>();
        cities.add(PhotoCopy.MediaevalCity.Amsterdam);
        cities.add(PhotoCopy.MediaevalCity.Barcelona);
        cities.add(PhotoCopy.MediaevalCity.London);
        cities.add(PhotoCopy.MediaevalCity.Paris);
        cities.add(PhotoCopy.MediaevalCity.Rome);
        for (PhotoCopy.MediaevalCity city : cities) {
            placeDatasetSpecs.add(PhotoGeoSeparator.generatePlaceDatasetSpecification(city, photoRoot, metadataRoot, photoListRoot));
        }
        CityTagModelCreator modelCreator = new CityTagModelCreator();
        List<PlaceModel.PlaceTagModel> cityModels = modelCreator.createTagModels(placeDatasetSpecs);
        int i = 0;
        while (i < cityModels.size()) {
            cityModels.get(i).toCityModelFile(String.valueOf(mediaevalDatasetRoot) + "tag_models/" + cities.get(i) + ".txt");
            ++i;
        }
    }

    public List<PlaceModel.PlaceTagModel> createTagModels(List<PhotoGeoSeparator.PlaceDatasetSpecification> placeSpecs) {
        HashMap<PhotoCopy.MediaevalCity, Set<FreqTag>> tagMap = new HashMap<PhotoCopy.MediaevalCity, Set<FreqTag>>();
        for (PhotoGeoSeparator.PlaceDatasetSpecification placeSpec : placeSpecs) {
            tagMap.put(placeSpec.getCity(), this.getFreqTagList(placeSpec));
        }
        HashSet<Object> commonTags = new HashSet<Object>();
        int i = 0;
        while (i < placeSpecs.size() - 1) {
            Set tagSet1 = (Set)tagMap.get((Object)placeSpecs.get(i).getCity());
            int j = i + 1;
            while (j < placeSpecs.size()) {
                Set tagSet2 = (Set)tagMap.get((Object)placeSpecs.get(j).getCity());
                for (Object ftag : tagSet2) {
                    if (!tagSet1.contains(ftag)) continue;
                    commonTags.add(ftag);
                }
                ++j;
            }
            ++i;
        }
        ArrayList<PlaceModel.PlaceTagModel> cityModels = new ArrayList<PlaceModel.PlaceTagModel>();
        int i2 = 0;
        while (i2 < placeSpecs.size()) {
            ArrayList<FreqTag> cityFreqTags = new ArrayList<FreqTag>();
            for (FreqTag ftag : (Set)tagMap.get((Object)placeSpecs.get(i2).getCity())) {
                if (commonTags.contains(ftag)) continue;
                cityFreqTags.add(ftag);
            }
            Collections.sort(cityFreqTags, Collections.reverseOrder());
            ArrayList<String> cityTags = new ArrayList<String>(200);
            int x = 0;
            while (x < 200) {
                cityTags.add(((FreqTag)cityFreqTags.get(x)).getTag());
                ++x;
            }
            PlaceModel.PlaceTagModel model = new PlaceModel.PlaceTagModel(cityTags);
            cityModels.add(model);
            ++i2;
        }
        return cityModels;
    }

    protected Set<FreqTag> getFreqTagList(PhotoGeoSeparator.PlaceDatasetSpecification placeSpec) {
        System.out.println("Creating tag list for place: " + (Object)((Object)placeSpec.getCity()));
        HashMap<String, Integer> tagFrequencyMap = new HashMap<String, Integer>();
        List<String> photoIds = IOUtil.readFileToStringList(placeSpec.getPhotoIdList());
        for (String photoId : photoIds) {
            String metadataFile = PhotoCopy.getImageFilePath(placeSpec.getMetadataDir(), photoId, ".txt");
            FlickrImageMetadata imageMetadata = FlickrImageMetadata.fromTextFile(metadataFile);
            List<String> tags = FlickrPhotoTagExtractor.getTagsTitle(imageMetadata);
            for (String tag : tags) {
                Integer freq = (Integer)tagFrequencyMap.get(tag);
                if (freq == null) {
                    tagFrequencyMap.put(tag, 1);
                    continue;
                }
                tagFrequencyMap.put(tag, freq + 1);
            }
        }
        ArrayList<FreqTag> tagFrequencies = new ArrayList<FreqTag>();
        for (Map.Entry tagFreqEntry : tagFrequencyMap.entrySet()) {
            if ((Integer)tagFreqEntry.getValue() <= 10) continue;
            tagFrequencies.add(new FreqTag((String)tagFreqEntry.getKey(), (Integer)tagFreqEntry.getValue()));
        }
        return new HashSet<FreqTag>(tagFrequencies);
    }
}

