/*
 * Decompiled with CFR 0.152.
 */
package model;

import geo.Geo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import model.FlickrDateTimeString;
import util.io.IOUtil;

public class FlickrImageMetadata {
    private Long id;
    private String url;
    private String thumbUrl;
    private String userID;
    private String username;
    private List<String> tags;
    private List<String> machineTags;
    private Geo geo;
    private long timeTaken;
    private long timeUploaded;
    private FlickrDateTimeString timeString;
    private String title;
    private String description;
    private String licence;

    public FlickrImageMetadata(Long id, String url, List<String> tags) {
        this.id = id;
        this.url = url;
        this.tags = tags;
    }

    public FlickrImageMetadata(Long id, String url) {
        this.id = id;
        this.url = url;
    }

    public FlickrImageMetadata(Long id) {
        this.id = id;
    }

    public void addTag(String tag) {
        if (!this.tags.contains(tag)) {
            this.tags.add(tag);
        }
    }

    public Geo getGeo() {
        return this.geo;
    }

    public void setGeo(Geo geo) {
        this.geo = geo;
    }

    public long getTimeTaken() {
        return this.timeTaken;
    }

    public void setTimeTaken(long timeTaken) {
        this.timeTaken = timeTaken;
    }

    public long getTimeUploaded() {
        return this.timeUploaded;
    }

    public void setTimeUploaded(long timeUploaded) {
        this.timeUploaded = timeUploaded;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public List<String> getMachineTags() {
        return this.machineTags;
    }

    public void setMachineTags(List<String> machineTags) {
        this.machineTags = machineTags;
    }

    public Long getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getThumbUrl() {
        return this.thumbUrl;
    }

    public void setThumbUrl(String thumbUrl) {
        this.thumbUrl = thumbUrl;
    }

    public List<String> getTagsList() {
        return this.tags;
    }

    public String[] getTags() {
        String[] outputTags = new String[this.tags.size()];
        int i = 0;
        while (i < this.tags.size()) {
            outputTags[i] = this.tags.get(i);
            ++i;
        }
        return outputTags;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public String getUsername() {
        return this.username;
    }

    public FlickrDateTimeString getTimeString() {
        return this.timeString;
    }

    public void setTimeString(String timeString) {
        this.timeString = new FlickrDateTimeString(timeString);
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getLicence() {
        return this.licence;
    }

    public void setLicence(String licence) {
        this.licence = licence;
    }

    public static FlickrImageMetadata fromTextFile(String filename) {
        String[] geoData;
        if (!new File(filename).exists()) {
            return null;
        }
        List<String> content = IOUtil.readFileToStringList(filename);
        int numberOfLines = content.size();
        if (numberOfLines < 1) {
            return null;
        }
        if (content.get(0) == null) {
            return null;
        }
        Long id = Long.parseLong(content.get(0).trim());
        FlickrImageMetadata image = new FlickrImageMetadata(id);
        if (!"".equals(content.get(1))) {
            image.setTitle(content.get(1));
        }
        String[] parts = content.get(2).split("\t");
        image.setUserID(parts[0].trim());
        image.setUsername(parts[1].trim());
        image.setTags(Arrays.asList(content.get(3).split("\t")));
        image.setMachineTags(Arrays.asList(content.get(4).split("\t")));
        if (!("".equals(content.get(5)) || "null".equals((geoData = content.get(5).split("\t"))[0]) || "null".equals(geoData[1]) || "null".equals(geoData[2]) || Float.parseFloat(geoData[0]) == Float.MIN_VALUE || Float.parseFloat(geoData[1]) == Float.MIN_VALUE || Float.parseFloat(geoData[2]) == Float.MIN_VALUE)) {
            image.setGeo(new Geo(Double.parseDouble(geoData[0]), Double.parseDouble(geoData[1]), Double.parseDouble(geoData[2])));
        }
        if (!"".equals(content.get(6))) {
            String[] timeData = content.get(6).split("\t");
            try {
                image.setTimeString(timeData[0]);
            }
            catch (Exception e) {
                System.out.println("Problem parsing time for photo: " + id + " in file: " + filename);
            }
            image.setTimeTaken(Long.parseLong(timeData[1]));
            image.setTimeUploaded(Long.parseLong(timeData[2]));
        }
        image.setUrl(content.get(7).trim());
        image.setThumbUrl(content.get(8).trim());
        if (!"null".equals(content.get(9))) {
            StringBuffer description = new StringBuffer();
            int i = 9;
            while (i < numberOfLines - 1) {
                description.append(String.valueOf(content.get(i)) + "\n");
                ++i;
            }
            image.setDescription(description.toString());
        }
        image.setLicence(content.get(numberOfLines - 1).trim());
        return image;
    }

    private static String normalizeTimeString(String timeString) {
        String[] parts = timeString.split(" ");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Illegal date-time string: " + timeString);
        }
        StringBuffer buf = new StringBuffer();
        String[] dateParts = parts[0].split("-");
        if (dateParts.length != 3) {
            throw new IllegalArgumentException("Illegal date string: " + parts[0] + " in time-date string: " + timeString);
        }
        if (dateParts[1].length() == 1) {
            buf.append("0" + dateParts[1] + "-");
        } else if (dateParts[1].length() == 2) {
            buf.append(String.valueOf(dateParts[1]) + "-");
        } else {
            throw new IllegalArgumentException("Illegal month format: " + parts[0]);
        }
        if (dateParts[2].length() == 1) {
            buf.append("0" + dateParts[2] + "-");
        } else if (dateParts[2].length() == 2) {
            buf.append(String.valueOf(dateParts[2]) + "-");
        } else {
            throw new IllegalArgumentException("Illegal day format: " + parts[0]);
        }
        if (dateParts[0].length() != 4) {
            throw new IllegalArgumentException("Illegal year format: " + parts[0]);
        }
        buf.append(String.valueOf(dateParts[0]) + "," + " ");
        String[] timeParts = parts[1].split(":");
        if (timeParts.length != 2) {
            throw new IllegalArgumentException("Illegal time string: " + parts[1] + " in time-date string: " + timeString);
        }
        if (timeParts[0].length() == 1) {
            buf.append("0" + timeParts[0] + ":");
        } else if (timeParts[0].length() == 2) {
            buf.append(String.valueOf(timeParts[0]) + ":");
        } else {
            throw new IllegalArgumentException("Illegal hour format: " + parts[1]);
        }
        if (timeParts[1].length() == 1) {
            buf.append("0" + timeParts[1] + ":");
        } else if (timeParts[1].length() == 2) {
            buf.append(String.valueOf(timeParts[1]) + ":");
        } else {
            throw new IllegalArgumentException("Illegal minute format: " + parts[1]);
        }
        buf.append("00.00");
        return buf.toString();
    }

    public static FlickrImageMetadata fromTextFileVIRAL(String filename) {
        try {
            BufferedReader imageInfoFilePointer = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF8"));
            String line = imageInfoFilePointer.readLine().trim();
            int separator = line.indexOf(":");
            String url = line.substring(separator + 1).trim();
            line = imageInfoFilePointer.readLine().trim();
            separator = line.indexOf(":");
            Long id = Long.parseLong(line.substring(separator + 1).trim());
            line = imageInfoFilePointer.readLine().trim();
            separator = line.indexOf(":");
            String stringOfTags = line.substring(separator + 1).trim();
            ArrayList<String> tags = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(stringOfTags, ";");
            while (st.hasMoreTokens()) {
                tags.add(st.nextToken());
            }
            return new FlickrImageMetadata(id, url, tags);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getImageFilePath(String rootDir, Long tempMember) {
        String memberStringValue = tempMember.toString();
        while (memberStringValue.length() < 12) {
            memberStringValue = "0" + memberStringValue;
        }
        String filepath = String.valueOf(rootDir) + memberStringValue.substring(0, 3) + "\\" + memberStringValue.substring(3, 6) + "\\" + memberStringValue.substring(6, 9) + "\\" + tempMember.toString() + ".txt";
        return filepath;
    }

    public static String getImageMetadataFilePath(String rootDir, Long tempMember) {
        String memberStringValue = tempMember.toString();
        while (memberStringValue.length() < 12) {
            memberStringValue = "0" + memberStringValue;
        }
        String filepath = String.valueOf(rootDir) + memberStringValue.substring(0, 3) + File.separator + memberStringValue.substring(3, 6) + File.separator + memberStringValue.substring(6, 9) + File.separator + tempMember.toString() + ".txt";
        return filepath;
    }

    public static String getImageFilePathJPG(String rootDir, Long tempMember) {
        String memberStringValue = tempMember.toString();
        while (memberStringValue.length() < 12) {
            memberStringValue = "0" + memberStringValue;
        }
        String filepath = String.valueOf(rootDir) + memberStringValue.substring(0, 3) + File.separator + memberStringValue.substring(3, 6) + File.separator + memberStringValue.substring(6, 9) + File.separator + tempMember.toString() + ".jpg";
        return filepath;
    }

    public static String getImageFilePathTXT(String rootDir, String photoId) {
        String tempPhotoId = photoId;
        while (tempPhotoId.length() < 12) {
            tempPhotoId = "0" + tempPhotoId;
        }
        String filepath = String.valueOf(rootDir) + File.separator + tempPhotoId.substring(0, 3) + File.separator + tempPhotoId.substring(3, 6) + File.separator + tempPhotoId.substring(6, 9) + File.separator + photoId + ".txt";
        return filepath;
    }

    public static String getImageFilePathDir(String rootDir, Long tempMember) {
        String memberStringValue = tempMember.toString();
        while (memberStringValue.length() < 12) {
            memberStringValue = "0" + memberStringValue;
        }
        String filepath = String.valueOf(rootDir) + memberStringValue.substring(0, 3) + "\\" + memberStringValue.substring(3, 6) + "\\" + memberStringValue.substring(6, 9) + "\\";
        return filepath;
    }

    public static String getImageFilePathWithoutRoot(Long tempMember) {
        String memberStringValue = tempMember.toString();
        while (memberStringValue.length() < 12) {
            memberStringValue = "0" + memberStringValue;
        }
        String filepath = String.valueOf(memberStringValue.substring(0, 3)) + File.separator + memberStringValue.substring(3, 6) + File.separator + memberStringValue.substring(6, 9) + File.separator + tempMember.toString() + ".jpg";
        return filepath;
    }

    public static String getThumbFilePathWithoutRoot(Long tempMember) {
        String memberStringValue = tempMember.toString();
        while (memberStringValue.length() < 12) {
            memberStringValue = "0" + memberStringValue;
        }
        String filepath = String.valueOf(memberStringValue.substring(0, 3)) + File.separator + memberStringValue.substring(3, 6) + File.separator + memberStringValue.substring(6, 9) + File.separator + tempMember.toString() + ".png";
        return filepath;
    }

    public String toCompactString() {
        if (this.geo == null) {
            return String.valueOf(Long.toString(this.id)) + ";" + "null" + ";" + "null" + ";" + "null" + ";" + Long.toString(this.timeTaken) + "\t";
        }
        return String.valueOf(Long.toString(this.id)) + ";" + this.geo.getLatitude() + ";" + this.geo.getLongitude() + ";" + this.geo.getAccuracy() + ";" + Long.toString(this.timeTaken) + "\t";
    }

    public static FlickrImageMetadata fromCompactString(String imageStringRepresentation) {
        String[] parts = imageStringRepresentation.split(";");
        if (parts.length != 5) {
            throw new IllegalArgumentException("Not a valid Flickr Image compact string: " + imageStringRepresentation);
        }
        long id = Long.parseLong(parts[0]);
        FlickrImageMetadata image = new FlickrImageMetadata(id);
        if (!("null".equals(parts[1]) || "null".equals(parts[2]) || "null".equals(parts[3]))) {
            double lat = Double.parseDouble(parts[1]);
            double lon = Double.parseDouble(parts[2]);
            double accuracy = Double.parseDouble(parts[3]);
            image.setGeo(new Geo(lon, lat, accuracy));
        }
        long timeTaken = Long.parseLong(parts[4]);
        image.setTimeTaken(timeTaken);
        return image;
    }
}

