/*
 * Decompiled with CFR 0.152.
 */
package model;

import geo.Geo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import model.FlickrDateTimeString;
import model.FlickrImageMetadata;

public class FlickrEvent {
    protected static final String MIN_DATE_STRING_INIT = "2100-12-30 23:59:50.0";
    protected static final String MAX_DATE_STRING_INIT = "1900-01-01 00:00:00.0";
    protected Set<Long> flickrIds = new HashSet<Long>();
    protected Geo location;
    protected FlickrDateTimeString start;
    protected FlickrDateTimeString end;
    protected List<String> tags = new ArrayList<String>();

    public void addPhoto(long flickrId) {
        this.flickrIds.add(flickrId);
    }

    public void addPhotos(List<Long> photos) {
        this.flickrIds.addAll(photos);
    }

    public List<Long> getPhotos() {
        return new ArrayList<Long>(this.flickrIds);
    }

    public Geo getLocation() {
        return this.location;
    }

    public FlickrDateTimeString getStart() {
        return this.start;
    }

    public void setStart(FlickrDateTimeString date) {
        this.start = date;
    }

    public FlickrDateTimeString getEnd() {
        return this.end;
    }

    public void setEnd(FlickrDateTimeString date) {
        this.end = date;
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public void addTags(List<String> tags) {
        this.tags.addAll(tags);
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void computeLocation(Map<Long, FlickrImageMetadata> metadataMap) {
        int countGeo = 0;
        double sumLat = 0.0;
        double sumLon = 0.0;
        for (long flickrId : this.flickrIds) {
            FlickrImageMetadata metadata = metadataMap.get(flickrId);
            if (metadata == null || metadata.getGeo() == null) continue;
            sumLat += metadata.getGeo().getLatitude();
            sumLon += metadata.getGeo().getLongitude();
            ++countGeo;
        }
        if (countGeo > 0) {
            this.location = new Geo(sumLon / (double)countGeo, sumLat / (double)countGeo);
        }
    }

    public void computeStartEnd(Map<Long, FlickrImageMetadata> metadataMap) {
        FlickrDateTimeString minDate = new FlickrDateTimeString(MIN_DATE_STRING_INIT);
        FlickrDateTimeString maxDate = new FlickrDateTimeString(MAX_DATE_STRING_INIT);
        for (long flickrId : this.flickrIds) {
            FlickrImageMetadata metadata = metadataMap.get(flickrId);
            if (metadata == null) continue;
            if (metadata.getTimeString().isBefore(minDate)) {
                minDate = metadata.getTimeString();
            }
            if (!maxDate.isBefore(metadata.getTimeString())) continue;
            maxDate = metadata.getTimeString();
        }
        this.start = minDate;
        this.end = maxDate;
    }
}

