/*
 * Decompiled with CFR 0.152.
 */
package model;

public class FlickrDateTimeString
implements Comparable<FlickrDateTimeString> {
    protected int year = 0;
    protected int month = 0;
    protected int day = 0;
    protected int hours = 0;
    protected int minutes = 0;
    protected int seconds = 0;

    public static void main(String[] args) {
        String testString = "2009-05-29 12:59:01.000";
        FlickrDateTimeString timeString = new FlickrDateTimeString(testString);
        System.out.println(timeString);
    }

    public FlickrDateTimeString(String dateTimeString) {
        String[] parts = dateTimeString.split(" ");
        String[] dateParts = parts[0].split("-");
        this.year = Integer.parseInt(dateParts[0]);
        this.month = Integer.parseInt(dateParts[1]);
        this.day = Integer.parseInt(dateParts[2]);
        String[] timeParts = parts[1].split(":");
        this.hours = Integer.parseInt(timeParts[0]);
        this.minutes = Integer.parseInt(timeParts[1]);
        if (timeParts.length == 3) {
            this.seconds = Integer.parseInt(timeParts[2].split("\\.")[0]);
        }
    }

    public boolean isBefore(FlickrDateTimeString otherDateTime) {
        if (this.getYear() < otherDateTime.getYear()) {
            return true;
        }
        if (this.getYear() > otherDateTime.getYear()) {
            return false;
        }
        if (this.getMonth() < otherDateTime.getMonth()) {
            return true;
        }
        if (this.getMonth() > otherDateTime.getMonth()) {
            return false;
        }
        if (this.getDay() < otherDateTime.getDay()) {
            return true;
        }
        if (this.getDay() > otherDateTime.getDay()) {
            return false;
        }
        if (this.getHours() < otherDateTime.getHours()) {
            return true;
        }
        if (this.getHours() > otherDateTime.getHours()) {
            return false;
        }
        if (this.getMinutes() < otherDateTime.getMinutes()) {
            return true;
        }
        if (this.getMinutes() > otherDateTime.getMinutes()) {
            return false;
        }
        return this.getSeconds() < otherDateTime.getSeconds();
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public String toString() {
        return String.valueOf(this.year) + "-" + this.month + "-" + this.day + " " + this.hours + ":" + this.minutes + ":" + this.seconds;
    }

    @Override
    public int compareTo(FlickrDateTimeString otherDateTime) {
        if (this.isBefore(otherDateTime)) {
            return -1;
        }
        if (otherDateTime.isBefore(this)) {
            return 1;
        }
        return 0;
    }
}

