/*
 * Decompiled with CFR 0.152.
 */
package geo;

import certh.Config;
import dataset.create.PhotoCopy;
import geo.CityClassifier;
import geo.Geo;
import geo.GeodesicDistanceCalculator;
import geo.PlaceModel;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import model.FlickrImageMetadata;
import tag.FlickrPhotoTagExtractor;

public class VenueClassifier {
    protected Map<MediaevalVenue, PlaceModel> venueMap = VenueClassifier.loadMediaEvalVenueModels();
    protected CityClassifier cityClassifier;
    private static final int MIN_MATCHING_TAG_THRESHOLD = 1;
    private static final int MIN_ONLY_MATCHING_TAG_THRESHOLD = 2;
    private static final int MIN_DISTANCE = 500;
    private static final String VENUE_TAG_MODELS_ROOT = String.valueOf(Config.MEVAL_RESOURCE_DIR) + "venue_tag_models" + File.separator;

    public VenueClassifier(CityClassifier cityClassifier) {
        this.cityClassifier = cityClassifier;
    }

    public MediaevalVenue detectVenue(FlickrImageMetadata photo) {
        if (photo.getGeo() != null) {
            this.selectClosestPlace(photo, this.venueMap);
        }
        return this.selectBestTagMatch(photo, this.venueMap);
    }

    public MediaevalVenue selectBestTagMatch(FlickrImageMetadata photoMetadata, Map<MediaevalVenue, PlaceModel> venueMap) {
        int maxMatchingTags = 0;
        MediaevalVenue matchingVenue = null;
        MediaevalVenue maxMatchingVenue = null;
        PhotoCopy.MediaevalCity city = this.cityClassifier.detectCity(photoMetadata);
        for (Map.Entry<MediaevalVenue, PlaceModel> venueEntry : venueMap.entrySet()) {
            int numberOfMatchingTags = 0;
            HashSet<String> photoTags = new HashSet<String>(FlickrPhotoTagExtractor.getTagsTitle(photoMetadata));
            String[] modelTags = venueEntry.getValue().getTagModel().getTags();
            if (venueEntry.getValue().getCity().equals((Object)city) || photoTags.contains(modelTags[0])) {
                matchingVenue = venueEntry.getKey();
            }
            int x = 1;
            while (x < modelTags.length) {
                if (photoTags.contains(modelTags[x])) {
                    ++numberOfMatchingTags;
                }
                ++x;
            }
            if (numberOfMatchingTags <= maxMatchingTags) continue;
            maxMatchingTags = numberOfMatchingTags;
            maxMatchingVenue = venueEntry.getKey();
        }
        if (maxMatchingTags >= 1 && matchingVenue != null) {
            return matchingVenue;
        }
        if (maxMatchingTags > 2) {
            return maxMatchingVenue;
        }
        return null;
    }

    public MediaevalVenue selectClosestPlace(FlickrImageMetadata photoMetadata, Map<MediaevalVenue, PlaceModel> venueMap) {
        double minDistance = Double.MAX_VALUE;
        MediaevalVenue closestVenue = null;
        for (Map.Entry<MediaevalVenue, PlaceModel> venueEntry : venueMap.entrySet()) {
            double distance = GeodesicDistanceCalculator.distVincenty(photoMetadata.getGeo(), venueEntry.getValue().getGeoModel().getCenter());
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            closestVenue = venueEntry.getKey();
        }
        if (minDistance > 500.0) {
            return null;
        }
        return closestVenue;
    }

    public static Map<MediaevalVenue, PlaceModel> loadMediaEvalVenueModels() {
        HashMap<MediaevalVenue, PlaceModel> venueMap = new HashMap<MediaevalVenue, PlaceModel>();
        String paradiso = "paradiso";
        venueMap.put(MediaevalVenue.PARADISO, new PlaceModel(paradiso, PhotoCopy.MediaevalCity.Amsterdam, new PlaceModel.PlaceGeoModel(new Geo(4.883889, 52.362222)), PlaceModel.PlaceTagModel.fromFile(String.valueOf(VENUE_TAG_MODELS_ROOT) + paradiso + ".txt")));
        String parcdelforum = "parcdelforum";
        venueMap.put(MediaevalVenue.PARC_DEL_FORUM, new PlaceModel(parcdelforum, PhotoCopy.MediaevalCity.Barcelona, new PlaceModel.PlaceGeoModel(new Geo(2.22074, 41.411417)), PlaceModel.PlaceTagModel.fromFile(String.valueOf(VENUE_TAG_MODELS_ROOT) + parcdelforum + ".txt")));
        return venueMap;
    }

    public static enum MediaevalVenue {
        PARADISO,
        PARC_DEL_FORUM;

    }
}

