/*
 * Decompiled with CFR 0.152.
 */
package geo;

import dataset.create.PhotoCopy;
import geo.Geo;
import java.util.Arrays;
import java.util.List;
import util.io.IOUtil;

public class PlaceModel {
    protected String name;
    protected PhotoCopy.MediaevalCity city;
    protected PlaceGeoModel geoModel;
    protected PlaceTagModel tagModel;

    public PlaceModel(String name, PhotoCopy.MediaevalCity city, PlaceGeoModel geoModel, PlaceTagModel tagModel) {
        this(city, geoModel, tagModel);
        this.name = name;
    }

    public PlaceModel(PhotoCopy.MediaevalCity city, PlaceGeoModel geoModel, PlaceTagModel tagModel) {
        this.city = city;
        this.geoModel = geoModel;
        this.tagModel = tagModel;
    }

    public String getName() {
        if (this.name == null) {
            return this.city.name();
        }
        return this.name;
    }

    public PhotoCopy.MediaevalCity getCity() {
        return this.city;
    }

    public PlaceGeoModel getGeoModel() {
        return this.geoModel;
    }

    public PlaceTagModel getTagModel() {
        return this.tagModel;
    }

    public static class PlaceGeoModel {
        protected Geo center;

        public PlaceGeoModel(Geo center) {
            this.center = center;
        }

        public Geo getCenter() {
            return this.center;
        }
    }

    public static class PlaceTagModel {
        protected String[] cityTags;

        public PlaceTagModel(List<String> cityTags) {
            this.cityTags = new String[cityTags.size()];
            int i = 0;
            while (i < cityTags.size()) {
                this.cityTags[i] = cityTags.get(i);
                ++i;
            }
        }

        public String[] getTags() {
            return this.cityTags;
        }

        public static PlaceTagModel fromFile(String cityModelFile) {
            List<String> tags = IOUtil.readFileToStringList(cityModelFile);
            return new PlaceTagModel(tags);
        }

        public void toCityModelFile(String cityModelFile) {
            IOUtil.writeStringCollectionToFile(Arrays.asList(this.cityTags), cityModelFile);
        }
    }
}

