/*
 * Decompiled with CFR 0.152.
 */
package geo;

import geo.Geo;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;

public class GeodesicDistanceCalculator {
    private static Map<Integer, Double> degreeToKilometersMap;

    public static Double distVincenty(Geo geo1, Geo geo2) {
        double lambdaP;
        double sinLambda;
        double cos2SigmaM;
        double cosLambda;
        double cosSigma;
        double sinSigma;
        double sigma;
        double sinAlpha;
        double cosSqAlpha;
        double C;
        double lat1 = geo1.getLatitude();
        double lat2 = geo2.getLatitude();
        double lon1 = geo1.getLongitude();
        double lon2 = geo2.getLongitude();
        double a = 6378137.0;
        double b = 6356752.3142;
        double f = 0.0033528106647474805;
        double L = GeodesicDistanceCalculator.toRad(lon2 - lon1);
        double U1 = Math.atan((1.0 - f) * Math.tan(GeodesicDistanceCalculator.toRad(lat1)));
        double U2 = Math.atan((1.0 - f) * Math.tan(GeodesicDistanceCalculator.toRad(lat2)));
        double sinU1 = Math.sin(U1);
        double cosU1 = Math.cos(U1);
        double sinU2 = Math.sin(U2);
        double cosU2 = Math.cos(U2);
        double lambda = L;
        double iterLimit = 100.0;
        do {
            if ((sinSigma = Math.sqrt(cosU2 * (sinLambda = Math.sin(lambda)) * (cosU2 * sinLambda) + (cosU1 * sinU2 - sinU1 * cosU2 * (cosLambda = Math.cos(lambda))) * (cosU1 * sinU2 - sinU1 * cosU2 * cosLambda))) != 0.0) continue;
            return 0.0;
        } while (Math.abs((lambda = L + (1.0 - (C = f / 16.0 * cosSqAlpha * (4.0 + f * (4.0 - 3.0 * cosSqAlpha)))) * f * sinAlpha * ((sigma = Math.atan2(sinSigma, cosSigma = sinU1 * sinU2 + cosU1 * cosU2 * cosLambda)) + C * sinSigma * ((cos2SigmaM = (cosSqAlpha = 1.0 - (sinAlpha = cosU1 * cosU2 * sinLambda / sinSigma) * sinAlpha) == 0.0 ? 0.0 : cosSigma - 2.0 * sinU1 * sinU2 / cosSqAlpha) + C * cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM)))) - (lambdaP = lambda)) > 1.0E-12 && (iterLimit -= 1.0) > 0.0);
        if (iterLimit == 0.0) {
            return null;
        }
        double uSq = cosSqAlpha * (a * a - b * b) / (b * b);
        double A = 1.0 + uSq / 16384.0 * (4096.0 + uSq * (-768.0 + uSq * (320.0 - 175.0 * uSq)));
        double B = uSq / 1024.0 * (256.0 + uSq * (-128.0 + uSq * (74.0 - 47.0 * uSq)));
        double deltaSigma = B * sinSigma * (cos2SigmaM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM) - B / 6.0 * cos2SigmaM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SigmaM * cos2SigmaM)));
        Double s = b * A * (sigma - deltaSigma);
        return s;
    }

    public static double toRad(double val) {
        return val * Math.PI / 180.0;
    }

    public static Point2D.Double get(double initialLongtitude, double initialLatitude, double newCartesianPointX, double newCartesianPointY) {
        if (degreeToKilometersMap == null) {
            GeodesicDistanceCalculator.initializeDegreeToKilometersMap();
        }
        double kilometersPerDegreeForSpecificLatitude = GeodesicDistanceCalculator.getKilometersPerDegreeForLatitude(initialLatitude);
        double geopointsLongtitude = newCartesianPointX / kilometersPerDegreeForSpecificLatitude + initialLongtitude;
        double geopointsLatitude = newCartesianPointY / kilometersPerDegreeForSpecificLatitude + initialLatitude;
        return new Point2D.Double(geopointsLongtitude, geopointsLatitude);
    }

    private static void initializeDegreeToKilometersMap() {
        degreeToKilometersMap = new HashMap<Integer, Double>();
        degreeToKilometersMap.put(0, 110.57);
        degreeToKilometersMap.put(10, 110.61);
        degreeToKilometersMap.put(20, 110.7);
        degreeToKilometersMap.put(30, 110.85);
        degreeToKilometersMap.put(40, 111.04);
        degreeToKilometersMap.put(50, 111.23);
        degreeToKilometersMap.put(60, 111.41);
        degreeToKilometersMap.put(70, 111.56);
        degreeToKilometersMap.put(80, 111.66);
        degreeToKilometersMap.put(90, 111.69);
    }

    private static double getKilometersPerDegreeForLatitude(double latitude) {
        return degreeToKilometersMap.get((int)Math.ceil(latitude) / 10 * 10);
    }
}

