/*
 * Decompiled with CFR 0.152.
 */
package geo;

import certh.Config;
import dataset.create.PhotoCopy;
import geo.GeodesicDistanceCalculator;
import geo.Place;
import geo.PlaceModel;
import java.util.HashSet;
import model.FlickrImageMetadata;
import tag.FlickrPhotoTagExtractor;

public class CityClassifier {
    protected PlaceModel[] cityModels;

    public CityClassifier() {
        this.cityModels = CityClassifier.loadMediaEvalCityModels();
    }

    public CityClassifier(PlaceModel[] cityModels) {
        this.cityModels = cityModels;
    }

    public PhotoCopy.MediaevalCity detectCity(FlickrImageMetadata photo) {
        if (photo.getGeo() != null) {
            return this.selectClosestPlace(photo, this.cityModels);
        }
        return this.selectBestTagMatch(photo, this.cityModels);
    }

    public PhotoCopy.MediaevalCity selectBestTagMatch(FlickrImageMetadata photoMetadata, PlaceModel[] cityModels) {
        int maxMatchingTags = 0;
        PhotoCopy.MediaevalCity matchingCity = null;
        int i = 0;
        while (i < cityModels.length) {
            int numberOfMatchingTags = 0;
            HashSet<String> photoTags = new HashSet<String>(FlickrPhotoTagExtractor.getTagsTitle(photoMetadata));
            String[] modelTags = cityModels[i].getTagModel().getTags();
            int x = 0;
            while (x < modelTags.length) {
                if (photoTags.contains(modelTags[x])) {
                    ++numberOfMatchingTags;
                }
                ++x;
            }
            if (numberOfMatchingTags > maxMatchingTags) {
                maxMatchingTags = numberOfMatchingTags;
                matchingCity = cityModels[i].getCity();
            }
            ++i;
        }
        return matchingCity;
    }

    public PhotoCopy.MediaevalCity selectClosestPlace(FlickrImageMetadata photoMetadata, PlaceModel[] cityModels) {
        double minDistance = Double.MAX_VALUE;
        PhotoCopy.MediaevalCity closestCity = null;
        int i = 0;
        while (i < cityModels.length) {
            double distance = GeodesicDistanceCalculator.distVincenty(photoMetadata.getGeo(), cityModels[i].getGeoModel().getCenter());
            if (distance < minDistance) {
                minDistance = distance;
                closestCity = cityModels[i].getCity();
            }
            ++i;
        }
        return closestCity;
    }

    public static PlaceModel[] loadMediaEvalCityModels() {
        String tagModelRoot = String.valueOf(Config.MEVAL_RESOURCE_DIR) + "city_tag_models/";
        PlaceModel[] cityModels = new PlaceModel[]{CityClassifier.generateCityModel(PhotoCopy.MediaevalCity.Amsterdam, tagModelRoot), CityClassifier.generateCityModel(PhotoCopy.MediaevalCity.Barcelona, tagModelRoot), CityClassifier.generateCityModel(PhotoCopy.MediaevalCity.London, tagModelRoot), CityClassifier.generateCityModel(PhotoCopy.MediaevalCity.Paris, tagModelRoot), CityClassifier.generateCityModel(PhotoCopy.MediaevalCity.Rome, tagModelRoot)};
        return cityModels;
    }

    public static PlaceModel generateCityModel(PhotoCopy.MediaevalCity city, String tagModelRoot) {
        return new PlaceModel(city, new PlaceModel.PlaceGeoModel(Place.getMediaevalPlace(city).getPosition()), PlaceModel.PlaceTagModel.fromFile(String.valueOf(tagModelRoot) + (Object)((Object)city) + ".txt"));
    }
}

