/*
 * Decompiled with CFR 0.152.
 */
package eval;

import certh.Config;
import dataset.create.PhotoCopy;
import eval.Evaluator;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import util.io.IOUtil;

public class ResultExaminer {
    private static final String FALSE_POSITIVES = "fp/";
    private static final String FALSE_NEGATIVES = "fn/";

    public static void main(String[] args) {
        String groundTruthFile = String.valueOf(Config.MEVAL_EVAL_DIR) + "SED11_submissions_evaluation" + File.separator + "sed_task1_groundtruth_BCN_ROM_v2.txt";
        String resultFile = String.valueOf(Config.MEVAL_EVAL_DIR) + "SED11_submissions_evaluation" + File.separator + "sub_certh" + File.separator + "SED_C1_CERTH-ITI2011_2.csv";
        String photoDir = Config.MEVAL_PHOTO_ROOT;
        String metadataDir = Config.MEVAL_METADATA_ROOT;
        String outputDir = String.valueOf(Config.MEVAL_EVAL_DIR) + "examine" + File.separator + "challenge1_run2" + File.separator;
        ResultExaminer.examineResults(groundTruthFile, resultFile, photoDir, metadataDir, outputDir);
    }

    public static void examineResults(String groundTruthFile, String resultFile, String photoDir, String metadataDir, String outputDir) {
        IOUtil.createDirectory(outputDir);
        if (!outputDir.endsWith(File.separator)) {
            outputDir = String.valueOf(outputDir) + File.separator;
        }
        String fpDir = String.valueOf(outputDir) + FALSE_POSITIVES;
        IOUtil.createDirectory(fpDir);
        String fnDir = String.valueOf(outputDir) + FALSE_NEGATIVES;
        IOUtil.createDirectory(fnDir);
        List<String> groundTruthLines = IOUtil.readFileToStringList(groundTruthFile);
        HashSet<Long> correctIds = new HashSet<Long>();
        for (String line : groundTruthLines) {
            long[] ids = Evaluator.getPhotoIds(line);
            int i = 0;
            while (i < ids.length) {
                correctIds.add(ids[i]);
                ++i;
            }
        }
        List<String> resultLines = IOUtil.readFileToStringList(resultFile);
        HashSet<Long> resultIds = new HashSet<Long>();
        HashSet<String> falsePositives = new HashSet<String>();
        for (String line : resultLines) {
            long[] ids = Evaluator.getPhotoIds(line);
            int i = 0;
            while (i < ids.length) {
                resultIds.add(ids[i]);
                if (!correctIds.contains(ids[i])) {
                    falsePositives.add(String.valueOf(ids[i]));
                }
                ++i;
            }
        }
        HashSet<String> falseNegatives = new HashSet<String>();
        for (Long id : correctIds) {
            if (resultIds.contains(id)) continue;
            falseNegatives.add(String.valueOf(id));
        }
        PhotoCopy.copyFlickrImagesToFlatFolder(new ArrayList<String>(falsePositives), photoDir, fpDir, ".jpg");
        PhotoCopy.copyFlickrImagesToFlatFolder(new ArrayList<String>(falsePositives), metadataDir, fpDir, ".txt");
        PhotoCopy.copyFlickrImagesToFlatFolder(new ArrayList<String>(falseNegatives), photoDir, fnDir, ".jpg");
        PhotoCopy.copyFlickrImagesToFlatFolder(new ArrayList<String>(falseNegatives), metadataDir, fnDir, ".txt");
    }
}

