/*
 * Decompiled with CFR 0.152.
 */
package eval;

import java.text.DecimalFormat;
import java.util.Set;

public class PerformanceMetric {
    private int numberOfObjects = 0;
    private int[][] confusionN = new int[1][1];
    private int[] groundTruthClusterSizes = new int[1];
    private int[] testClusterSizes = new int[1];
    private int Nreal = 1;
    private int Nfound = 1;

    public PerformanceMetric(int numberOfObjects, int[] groundTruthClusterSizes, int[] testClusterSizes) {
        this.numberOfObjects = numberOfObjects;
        this.groundTruthClusterSizes = groundTruthClusterSizes;
        this.testClusterSizes = testClusterSizes;
        this.Nreal = groundTruthClusterSizes.length;
        this.Nfound = testClusterSizes.length;
        this.confusionN = new int[this.Nreal][this.Nfound];
    }

    public void setConfusionMatrixElement(int i, int j, int Nij) {
        if (i < 0 || i >= this.Nreal) {
            throw new IllegalArgumentException("Real community index negative or larger than number of communities!");
        }
        if (j < 0 || j >= this.Nfound) {
            throw new IllegalArgumentException("Found community index negative or larger than number of communities!");
        }
        this.confusionN[i][j] = Nij;
    }

    public void printConfusionMatrix() {
        int i = 0;
        while (i < this.Nreal) {
            int j = 0;
            while (j < this.Nfound) {
                System.out.print(String.valueOf(this.confusionN[i][j]) + "\t");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public IRMetric computeIRMetric(Set<Long> correctIds, Set<Long> foundIds) {
        int matches = 0;
        for (Long id : foundIds) {
            if (!correctIds.contains(id)) continue;
            ++matches;
        }
        double precision = (double)matches / (double)foundIds.size();
        double recall = (double)matches / (double)correctIds.size();
        IRMetric metric = new IRMetric(precision, recall);
        return metric;
    }

    public IRMetric computeIRMetric() {
        int totalNumberOfCorrectInstances = 0;
        int i = 0;
        while (i < this.groundTruthClusterSizes.length) {
            totalNumberOfCorrectInstances += this.groundTruthClusterSizes[i];
            ++i;
        }
        int totalNumberOfFoundInstances = 0;
        int i2 = 0;
        while (i2 < this.testClusterSizes.length) {
            totalNumberOfFoundInstances += this.testClusterSizes[i2];
            ++i2;
        }
        int allCorrect = 0;
        int i3 = 0;
        while (i3 < this.Nreal) {
            int j = 0;
            while (j < this.Nfound) {
                allCorrect += this.confusionN[i3][j];
                ++j;
            }
            ++i3;
        }
        double precision = (double)allCorrect / (double)totalNumberOfFoundInstances;
        double recall = (double)allCorrect / (double)totalNumberOfCorrectInstances;
        IRMetric metric = new IRMetric(precision, recall);
        return metric;
    }

    public double calculateNMI() {
        int nia;
        double ln2 = Math.log(2.0);
        if (this.numberOfObjects < 1 || this.Nreal < 1 || this.Nfound < 1) {
            throw new IllegalStateException("The object PerformanceMetric has not been properly initialized!");
        }
        double numerator = 0.0;
        int i = 0;
        while (i < this.Nreal) {
            int j = 0;
            while (j < this.Nfound) {
                int nij = this.confusionN[i][j];
                if (nij != 0) {
                    nia = this.groundTruthClusterSizes[i];
                    int nib = this.testClusterSizes[j];
                    numerator += (double)nij * Math.log((double)(nij * this.numberOfObjects) / (double)(nia * nib)) / ln2;
                }
                ++j;
            }
            ++i;
        }
        double den1 = 0.0;
        int i2 = 0;
        while (i2 < this.Nreal) {
            nia = this.groundTruthClusterSizes[i2];
            den1 += (double)nia * Math.log((double)nia / (double)this.numberOfObjects) / ln2;
            ++i2;
        }
        double den2 = 0.0;
        int j = 0;
        while (j < this.Nfound) {
            int nib = this.testClusterSizes[j];
            den2 += (double)nib * Math.log((double)nib / (double)this.numberOfObjects) / ln2;
            ++j;
        }
        return -2.0 * numerator / (den1 + den2);
    }

    public static class EvaluationMeasures {
        protected double NMI;
        protected IRMetric IrMetric;
        private static final DecimalFormat DF = new DecimalFormat("#.##");
        private static final DecimalFormat DF4 = new DecimalFormat("#.####");

        public EvaluationMeasures(double nMI, IRMetric irMetric) {
            this.NMI = nMI;
            this.IrMetric = irMetric;
        }

        public double getNMI() {
            return this.NMI;
        }

        public IRMetric getIrMetric() {
            return this.IrMetric;
        }

        public String toString() {
            return "NMI = " + DF4.format(this.getNMI()) + "\t" + "P = " + DF.format(100.0 * this.getIrMetric().precision) + "\t" + "R = " + DF.format(100.0 * this.getIrMetric().recall) + "\t" + "F = " + DF.format(100.0 * this.getIrMetric().getFMeasure());
        }
    }

    public class IRMetric {
        public double precision;
        public double recall;

        public IRMetric(double precision, double recall) {
            this.precision = precision;
            this.recall = recall;
        }

        public double getFMeasure() {
            if (this.precision > 0.0 || this.recall > 0.0) {
                return 2.0 * this.precision * this.recall / (this.precision + this.recall);
            }
            return Double.NaN;
        }
    }
}

