/*
 * Decompiled with CFR 0.152.
 */
package eval;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import util.io.IOUtil;

public class GroundTruthDiff {
    public static void main(String[] args) {
        String mediaevalGroundTruthFile = "D:\\mediaeval\\eval\\Barcelona_sed_task1_groundtruth.txt";
        String crEveGroundTruthFile = "D:\\shared\\annotationResults\\groundTruthBarcelonaNEW.txt";
        GroundTruthDiff diff = new GroundTruthDiff();
        List<EventAnnotation> mediaEvalEvents = diff.readEventsFromMediaEvalGroundTruthFile(mediaevalGroundTruthFile);
        List<EventAnnotation> crEveEvents = diff.readEventsFromCrEveFile(crEveGroundTruthFile);
        int i = 0;
        while (i < crEveEvents.size()) {
            EventAnnotation matchingEvent = crEveEvents.get(i).selectMatchingEvent(mediaEvalEvents);
            if (matchingEvent != null) {
                HashSet<Long> newPhotos = new HashSet<Long>();
                Set<Long> matchingEventPhotos = matchingEvent.getPhotos();
                for (long photoId : crEveEvents.get(i).getPhotos()) {
                    if (matchingEventPhotos.contains(photoId)) continue;
                    newPhotos.add(photoId);
                }
                System.out.println(String.valueOf(matchingEventPhotos.size()) + "\t->\t" + crEveEvents.get(i).getPhotos().size() + ",\t" + newPhotos.size() + "(" + (double)(100 * newPhotos.size()) / (double)matchingEventPhotos.size() + "%)");
            } else {
                System.out.println("0\t->\t" + crEveEvents.get(i).getPhotos().size() + ",\t" + crEveEvents.get(i).getPhotos().size() + "(100%)");
            }
            ++i;
        }
    }

    public List<EventAnnotation> readEventsFromMediaEvalGroundTruthFile(String file) {
        List<String> lines = IOUtil.readFileToStringList(file);
        ArrayList<EventAnnotation> events = new ArrayList<EventAnnotation>(lines.size());
        int currentId = 1;
        for (String line : lines) {
            String[] parts = line.split(",");
            HashSet<Long> photoIds = new HashSet<Long>();
            int i = 0;
            while (i < parts.length) {
                photoIds.add(Long.parseLong(parts[i]));
                ++i;
            }
            events.add(new EventAnnotation(currentId, photoIds));
        }
        return events;
    }

    public List<EventAnnotation> readEventsFromCrEveFile(String file) {
        List<String> lines = IOUtil.readFileToStringList(file);
        ArrayList<EventAnnotation> events = new ArrayList<EventAnnotation>(lines.size());
        int eventId = 0;
        EventAnnotation event = null;
        for (String line : lines) {
            String[] parts = line.split("\t");
            long photoId = Long.parseLong(parts[0]);
            int currentEventId = Integer.parseInt(parts[1]);
            if (currentEventId != eventId) {
                event = new EventAnnotation(currentEventId);
                events.add(event);
                eventId = currentEventId;
            }
            event.addPhotoId(photoId);
        }
        return events;
    }

    public class EventAnnotation {
        protected int id;
        protected Set<Long> photoIds;

        public EventAnnotation(int id) {
            this.id = id;
            this.photoIds = new HashSet<Long>();
        }

        public EventAnnotation(int id, Set<Long> photos) {
            this.id = id;
            this.photoIds = photos;
        }

        public Set<Long> getPhotos() {
            return this.photoIds;
        }

        public void addPhotoId(long photoId) {
            this.photoIds.add(photoId);
        }

        public int findCommon(EventAnnotation otherEvent) {
            int common = 0;
            for (long photoId : otherEvent.getPhotos()) {
                if (!this.photoIds.contains(photoId)) continue;
                ++common;
            }
            return common;
        }

        public EventAnnotation selectMatchingEvent(List<EventAnnotation> events) {
            EventAnnotation matchingEvent = null;
            int maxCommon = 0;
            for (EventAnnotation event : events) {
                int currentCommon = this.findCommon(event);
                if (currentCommon <= maxCommon) continue;
                maxCommon = currentCommon;
                matchingEvent = event;
            }
            return matchingEvent;
        }
    }
}

