/*
 * Decompiled with CFR 0.152.
 */
package eval;

import certh.Config;
import eval.EvaluationEntry;
import eval.PerformanceMetric;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import util.io.IOUtil;

public class Evaluator {
    private static final String CHALLENGE1_MAGIC_TOKEN1 = "_C1_";
    private static final String CHALLENGE1_MAGIC_TOKEN2 = "_1_";
    private static final String CHALLENGE2_MAGIC_TOKEN1 = "_C2_";
    private static final String CHALLENGE2_MAGIC_TOKEN2 = "_2_";

    public static void main(String[] args) {
        if (args.length == 5) {
            Evaluator.runComparativeEvaluation(args[0], args[1], args[2], args[3], args[4]);
        } else if (args.length == 3) {
            Evaluator.runComparativeEvaluation(args[0], args[1], args[2]);
        } else {
            System.out.println("java -jar evaluate.jar submissionFolder, gt1, gt2, gt3, outputFile");
            System.out.println("OR");
            System.out.println("java -jar evaluate.jar submissionFile, gt, outputFile");
        }
    }

    public static void runComparativeEvaluation(String sumbission, String gt, String outputFile) {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF8"));
            File csvFile = new File(sumbission);
            ArrayList<EvaluationEntry> measures = new ArrayList<EvaluationEntry>();
            measures.add(new EvaluationEntry(csvFile.getName(), Evaluator.evaluate(gt, csvFile.getAbsolutePath())));
            for (EvaluationEntry entry : measures) {
                try {
                    writer.write(entry.toString());
                    writer.newLine();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            writer.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void runComparativeEvaluation(String root, String gt1, String gt2, String gt3, String outputFile) {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF8"));
            File f = new File(root);
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File submissionsDirectory = fileArray[n2];
                writer.write(submissionsDirectory.getName());
                writer.newLine();
                List<EvaluationEntry> results = Evaluator.printMediaevalResults(gt1, gt2, gt3, submissionsDirectory.toString());
                for (EvaluationEntry entry : results) {
                    try {
                        writer.write(entry.toString());
                        writer.newLine();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
            writer.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void runComparativeEvaluation() {
        String root = "/home/manosetro/Desktop/SED RESULTS/";
        String challenge1GroundTruthFile = String.valueOf(root) + "technical_events.txt";
        String challenge2GroundTruthFile = String.valueOf(root) + "soccer_events.txt";
        String challenge3GroundTruthFile = String.valueOf(root) + "indignados_events.txt";
        String outputFile = String.valueOf(root) + "results.txt";
        String[] participants = new String[]{"AUTH_ISSEL", "DISI", "MISIMS", "QMUL", "ITI"};
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF8"));
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        String[] stringArray = participants;
        int n = participants.length;
        int n2 = 0;
        while (n2 < n) {
            String participant = stringArray[n2];
            String submissionsDirectory = String.valueOf(root) + participant;
            System.out.println("===========================" + participant + "===========================");
            List<EvaluationEntry> results = Evaluator.printMediaevalResults(challenge1GroundTruthFile, challenge2GroundTruthFile, challenge3GroundTruthFile, submissionsDirectory);
            for (EvaluationEntry entry : results) {
                try {
                    writer.write(entry.toString());
                    writer.newLine();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        try {
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void listIncorrectIds() {
        String root = String.valueOf(Config.MEVAL_EVAL_DIR) + "SED11_submissions_evaluation" + File.separator;
        String challenge1GroundTruthFile = String.valueOf(root) + "sed_task1_groundtruth_BCN_ROM.txt";
        String challenge2GroundTruthFile = String.valueOf(root) + "sed_task2_groundtruth_PAR_PDF.txt";
        String submissionsDirectory = String.valueOf(root) + "all" + File.separator;
        String outputFileChallenge1 = String.valueOf(root) + "incorrectPhotos_challenge1.txt";
        String outputFileChallenge2 = String.valueOf(root) + "incorrectPhotos_challenge2.txt";
        Evaluator.listIncorrectPhotoIds(challenge1GroundTruthFile, challenge2GroundTruthFile, submissionsDirectory, outputFileChallenge1, outputFileChallenge2);
    }

    public static List<EvaluationEntry> printMediaevalResults(String challenge1groundTruthFile, String challenge2groundTruthFile, String challenge3groundTruthFile, String submissionsDirectory) {
        File directory = new File(submissionsDirectory);
        File[] csvFiles = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getAbsolutePath().endsWith(".csv");
            }
        });
        ArrayList<EvaluationEntry> measures = new ArrayList<EvaluationEntry>();
        int i = 0;
        while (i < csvFiles.length) {
            String evalFilename = csvFiles[i].getName();
            if (evalFilename.contains(CHALLENGE1_MAGIC_TOKEN1) || evalFilename.contains(CHALLENGE1_MAGIC_TOKEN2)) {
                measures.add(new EvaluationEntry(evalFilename, Evaluator.evaluate(challenge1groundTruthFile, csvFiles[i].getAbsolutePath())));
            } else if (evalFilename.contains(CHALLENGE2_MAGIC_TOKEN1) || evalFilename.contains(CHALLENGE2_MAGIC_TOKEN2)) {
                measures.add(new EvaluationEntry(evalFilename, Evaluator.evaluate(challenge2groundTruthFile, csvFiles[i].getAbsolutePath())));
            } else {
                measures.add(new EvaluationEntry(evalFilename, Evaluator.evaluate(challenge3groundTruthFile, csvFiles[i].getAbsolutePath())));
            }
            ++i;
        }
        Collections.sort(measures);
        return measures;
    }

    public static PerformanceMetric.EvaluationMeasures evaluate(String groundTruthFile, String testFile) {
        List<String> groundTruthLines = IOUtil.readFileToStringList(groundTruthFile);
        List<String> testLines = IOUtil.readFileToStringList(testFile);
        HashSet<Long> uniquePhotoIds = new HashSet<Long>();
        HashSet<Long> correctPhotoIds = new HashSet<Long>();
        int[] groundTruthClusterSizes = new int[groundTruthLines.size()];
        int i = 0;
        while (i < groundTruthLines.size()) {
            String line = groundTruthLines.get(i);
            long[] ids = Evaluator.getPhotoIds(line);
            groundTruthClusterSizes[i] = ids.length;
            int x = 0;
            while (x < ids.length) {
                uniquePhotoIds.add(ids[x]);
                correctPhotoIds.add(ids[x]);
                ++x;
            }
            ++i;
        }
        HashSet<Long> foundPhotoIds = new HashSet<Long>();
        int[] testClusterSizes = new int[testLines.size()];
        int i2 = 0;
        while (i2 < testLines.size()) {
            String line = testLines.get(i2);
            long[] ids = Evaluator.getPhotoIds(line);
            testClusterSizes[i2] = ids.length;
            int x = 0;
            while (x < ids.length) {
                uniquePhotoIds.add(ids[x]);
                foundPhotoIds.add(ids[x]);
                ++x;
            }
            ++i2;
        }
        PerformanceMetric perf = new PerformanceMetric(uniquePhotoIds.size(), groundTruthClusterSizes, testClusterSizes);
        int i3 = 0;
        while (i3 < groundTruthLines.size()) {
            long[] groundTruthIds = Evaluator.getPhotoIds(groundTruthLines.get(i3));
            HashSet<Long> groundTruthSet = new HashSet<Long>();
            int x = 0;
            while (x < groundTruthIds.length) {
                groundTruthSet.add(groundTruthIds[x]);
                ++x;
            }
            int j = 0;
            while (j < testLines.size()) {
                int Nij = 0;
                long[] testIds = Evaluator.getPhotoIds(testLines.get(j));
                int y = 0;
                while (y < testIds.length) {
                    if (groundTruthSet.contains(testIds[y])) {
                        ++Nij;
                    }
                    ++y;
                }
                perf.setConfusionMatrixElement(i3, j, Nij);
                ++j;
            }
            ++i3;
        }
        double nmi = perf.calculateNMI();
        PerformanceMetric.IRMetric ir = perf.computeIRMetric(correctPhotoIds, foundPhotoIds);
        PerformanceMetric.EvaluationMeasures measures = new PerformanceMetric.EvaluationMeasures(nmi, ir);
        return measures;
    }

    public static void listIncorrectPhotoIds(String challenge1groundTruthFile, String challenge2groundTruthFile, String submissionsDirectory, String outputFileChallenge1, String outputFileChallenge2) {
        File directory = new File(submissionsDirectory);
        File[] csvFiles = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getAbsolutePath().endsWith(".csv");
            }
        });
        HashSet<String> incorrectIdsChallenge1 = new HashSet<String>();
        HashSet<String> incorrectIdsChallenge2 = new HashSet<String>();
        int i = 0;
        while (i < csvFiles.length) {
            String evalFilename = csvFiles[i].getName();
            String groundTruthFilename = challenge2groundTruthFile;
            boolean isChallenge1 = false;
            if (evalFilename.contains(CHALLENGE1_MAGIC_TOKEN1) || evalFilename.contains(CHALLENGE1_MAGIC_TOKEN2)) {
                groundTruthFilename = challenge1groundTruthFile;
                isChallenge1 = true;
            }
            List<String> groundTruthLines = IOUtil.readFileToStringList(groundTruthFilename);
            HashSet<Long> correctPhotoIds = new HashSet<Long>();
            int x = 0;
            while (x < groundTruthLines.size()) {
                long[] ids = Evaluator.getPhotoIds(groundTruthLines.get(x));
                int y = 0;
                while (y < ids.length) {
                    correctPhotoIds.add(ids[y]);
                    ++y;
                }
                ++x;
            }
            List<String> testLines = IOUtil.readFileToStringList(csvFiles[i].getAbsolutePath());
            HashSet<Long> foundPhotoIds = new HashSet<Long>();
            int x2 = 0;
            while (x2 < testLines.size()) {
                long[] ids = Evaluator.getPhotoIds(testLines.get(x2));
                int y = 0;
                while (y < ids.length) {
                    foundPhotoIds.add(ids[y]);
                    ++y;
                }
                ++x2;
            }
            for (Long foundId : foundPhotoIds) {
                if (correctPhotoIds.contains(foundId)) continue;
                if (isChallenge1) {
                    incorrectIdsChallenge1.add(String.valueOf(foundId));
                    continue;
                }
                incorrectIdsChallenge2.add(String.valueOf(foundId));
            }
            ++i;
        }
        IOUtil.writeStringCollectionToFile(incorrectIdsChallenge1, outputFileChallenge1);
        IOUtil.writeStringCollectionToFile(incorrectIdsChallenge2, outputFileChallenge2);
    }

    public static long[] getPhotoIds(String line) {
        String[] parts = line.split(",");
        long[] ids = new long[parts.length];
        int i = 0;
        while (i < parts.length) {
            if (parts[i].trim().length() >= 1) {
                ids[i] = Long.parseLong(parts[i].trim());
            }
            ++i;
        }
        return ids;
    }

    public static enum Challenge {
        C1,
        C2,
        C3;

    }
}

