/*
 * Decompiled with CFR 0.152.
 */
package eval;

import eval.Evaluator;
import eval.PerformanceMetric;
import java.text.DecimalFormat;

public class EvaluationEntry
implements Comparable<EvaluationEntry> {
    protected String participant;
    protected Evaluator.Challenge challenge;
    protected int run;
    protected PerformanceMetric.EvaluationMeasures performance;
    protected static final String CHALLENGE_PREFIX = "C";
    protected static final String RUN_PREFIX = "N";
    private static final DecimalFormat DF = new DecimalFormat("#.##");
    private static final DecimalFormat DF4 = new DecimalFormat("#.####");

    public EvaluationEntry(String submissionFilename, PerformanceMetric.EvaluationMeasures performance) {
        if (!submissionFilename.endsWith(".csv")) {
            throw new IllegalArgumentException("String: " + submissionFilename + " is not a proper CSV filename.");
        }
        String[] parts = submissionFilename.substring(0, submissionFilename.length() - 4).split("_");
        if (parts.length != 4) {
            throw new IllegalArgumentException("String: " + submissionFilename + " is not a proper mediaeval submission filename.");
        }
        this.challenge = parts[1].startsWith(CHALLENGE_PREFIX) ? Evaluator.Challenge.valueOf(parts[1]) : Evaluator.Challenge.valueOf(CHALLENGE_PREFIX + parts[1]);
        this.participant = parts[2];
        this.run = parts[3].startsWith(RUN_PREFIX) ? Integer.valueOf(parts[3].substring(1)).intValue() : Integer.valueOf(parts[3]).intValue();
        this.performance = performance;
    }

    public String getParticipant() {
        return this.participant;
    }

    public Evaluator.Challenge getChallenge() {
        return this.challenge;
    }

    public int getRun() {
        return this.run;
    }

    public PerformanceMetric.EvaluationMeasures getPerformance() {
        return this.performance;
    }

    @Override
    public int compareTo(EvaluationEntry o) {
        if (!this.getChallenge().equals((Object)o.getChallenge())) {
            return this.getChallenge().compareTo(o.getChallenge());
        }
        if (!this.getParticipant().equals(o.getParticipant())) {
            return this.getParticipant().compareTo(o.getParticipant());
        }
        return this.getRun() - o.getRun();
    }

    public String toString() {
        String separator = "\t\t";
        if (this.getParticipant().length() > 10) {
            separator = "\t";
        }
        return String.valueOf(this.getParticipant()) + " " + "(" + (Object)((Object)this.getChallenge()) + "," + this.getRun() + ")" + separator + "\t" + DF4.format(Math.abs(this.getPerformance().getNMI())) + "\t" + DF.format(100.0 * this.getPerformance().getIrMetric().precision) + "\t" + DF.format(100.0 * this.getPerformance().getIrMetric().recall) + "\t" + DF.format(100.0 * this.getPerformance().getIrMetric().getFMeasure());
    }
}

