/*
 * Decompiled with CFR 0.152.
 */
package eval;

import java.util.ArrayList;
import java.util.List;
import vis.FeatureVectorStructure;

public class CosineSimilarity {
    public static List<Double[]> randomVectors(long numberOfVectors, int numberOfFeatures) {
        ArrayList<Double[]> vectors = new ArrayList<Double[]>();
        int i = 0;
        while ((long)i < numberOfVectors) {
            Double[] tempVector = new Double[numberOfFeatures];
            int j = 0;
            while (j < numberOfFeatures) {
                tempVector[j] = Math.random();
                ++j;
            }
            vectors.add(tempVector);
            ++i;
        }
        return vectors;
    }

    public static List<Double> calculateMagnitude(FeatureVectorStructure vectors) {
        ArrayList<Double> vectorsMagnitude = new ArrayList<Double>();
        int i = 0;
        while (i < vectors.getNumberOfVectors()) {
            double[] tempVector = vectors.getFeatureVector(i);
            double sum = 0.0;
            int j = 0;
            while (j < tempVector.length) {
                sum += Math.pow(tempVector[j], 2.0);
                ++j;
            }
            vectorsMagnitude.add(Math.sqrt(sum));
            ++i;
        }
        return vectorsMagnitude;
    }

    public static double cosineDistance(double[] vector1, double[] vector2, double magnitude1, double magnitude2) {
        double denominator = magnitude1 * magnitude2;
        if (denominator < 1.0E-10) {
            return 0.0;
        }
        double numerator = 0.0;
        int i = 0;
        while (i < vector1.length) {
            numerator += vector1[i] * vector2[i];
            ++i;
        }
        return numerator / denominator;
    }
}

