/*
 * Decompiled with CFR 0.152.
 */
package dataset.create;

import dataset.create.PhotoCopy;
import geo.CityClassifier;
import geo.GeodesicDistanceCalculator;
import geo.Place;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import model.FlickrImageMetadata;
import util.io.IOUtil;

public class PhotoGeoSeparator {
    public static PlaceDatasetSpecification[] placeDatasetSpecs = new PlaceDatasetSpecification[6];
    protected static Place[] mediaevalCities;

    static {
        String mediaevalDatasetRoot = "D:/mediaeval/dataset/";
        String photoListRoot = String.valueOf(mediaevalDatasetRoot) + "city_photo_lists/";
        String photoRoot = String.valueOf(mediaevalDatasetRoot) + "photos/";
        String metadataRoot = String.valueOf(mediaevalDatasetRoot) + "metadata/";
        PhotoGeoSeparator.placeDatasetSpecs[0] = PhotoGeoSeparator.generatePlaceDatasetSpecification(PhotoCopy.MediaevalCity.Amsterdam, photoRoot, metadataRoot, photoListRoot);
        PhotoGeoSeparator.placeDatasetSpecs[1] = PhotoGeoSeparator.generatePlaceDatasetSpecification(PhotoCopy.MediaevalCity.Barcelona, photoRoot, metadataRoot, photoListRoot);
        PhotoGeoSeparator.placeDatasetSpecs[2] = PhotoGeoSeparator.generatePlaceDatasetSpecification(PhotoCopy.MediaevalCity.London, photoRoot, metadataRoot, photoListRoot);
        PhotoGeoSeparator.placeDatasetSpecs[3] = PhotoGeoSeparator.generatePlaceDatasetSpecification(PhotoCopy.MediaevalCity.Paris, photoRoot, metadataRoot, photoListRoot);
        PhotoGeoSeparator.placeDatasetSpecs[4] = PhotoGeoSeparator.generatePlaceDatasetSpecification(PhotoCopy.MediaevalCity.Raphael, photoRoot, metadataRoot, photoListRoot);
        PhotoGeoSeparator.placeDatasetSpecs[5] = PhotoGeoSeparator.generatePlaceDatasetSpecification(PhotoCopy.MediaevalCity.Rome, photoRoot, metadataRoot, photoListRoot);
        mediaevalCities = Place.getMediaevalCities();
    }

    public static void main(String[] args) {
        PhotoGeoSeparator.separateDataset(placeDatasetSpecs[4]);
    }

    public static void separateDataset(PlaceDatasetSpecification placeSpec) {
        int count = 0;
        List<String> photoIds = IOUtil.readFileToStringList(placeSpec.getPhotoIdList());
        CityClassifier classifier = new CityClassifier(CityClassifier.loadMediaEvalCityModels());
        HashMap<PhotoCopy.MediaevalCity, Integer> classificationMap = new HashMap<PhotoCopy.MediaevalCity, Integer>();
        for (String string : photoIds) {
            Integer nr;
            ++count;
            String metadataFile = PhotoCopy.getImageFilePath(placeSpec.getMetadataDir(), string, ".txt");
            FlickrImageMetadata imageMetadata = FlickrImageMetadata.fromTextFile(metadataFile);
            if (imageMetadata == null) {
                System.out.println(String.valueOf(count) + ". Metadata does not exist!");
                continue;
            }
            PhotoCopy.MediaevalCity city = classifier.detectCity(imageMetadata);
            System.out.println(String.valueOf(count) + ". " + (Object)((Object)city) + "\t" + imageMetadata.getTitle());
            if (city == null) {
                city = PhotoCopy.MediaevalCity.Raphael;
            }
            if ((nr = (Integer)classificationMap.get((Object)city)) == null) {
                classificationMap.put(city, 1);
                continue;
            }
            classificationMap.put(city, nr + 1);
        }
        for (Map.Entry entry : classificationMap.entrySet()) {
            System.out.println(entry.getKey() + ": " + entry.getValue());
        }
    }

    public static Place selectClosestPlace(FlickrImageMetadata photoMetadata, Place[] places) {
        double minDistance = Double.MAX_VALUE;
        Place closestPlace = null;
        int i = 0;
        while (i < places.length) {
            double distance = GeodesicDistanceCalculator.distVincenty(photoMetadata.getGeo(), places[i].getPosition());
            if (distance < minDistance) {
                minDistance = distance;
                closestPlace = places[i];
            }
            ++i;
        }
        return closestPlace;
    }

    public static PlaceDatasetSpecification generatePlaceDatasetSpecification(PhotoCopy.MediaevalCity city, String photoRoot, String metadataRoot, String photoListRoot) {
        return new PlaceDatasetSpecification(city, String.valueOf(photoRoot) + (Object)((Object)city) + File.separator, String.valueOf(metadataRoot) + (Object)((Object)city) + File.separator, String.valueOf(photoListRoot) + (Object)((Object)city) + "_photos.txt");
    }

    public static class PlaceDatasetSpecification {
        protected PhotoCopy.MediaevalCity city;
        protected String photoDir;
        protected String metadataDir;
        protected String photoIdList;

        public PlaceDatasetSpecification(PhotoCopy.MediaevalCity city, String photoDir, String metadataDir, String photoIdList) {
            this.city = city;
            this.photoDir = photoDir;
            this.metadataDir = metadataDir;
            this.photoIdList = photoIdList;
        }

        public PhotoCopy.MediaevalCity getCity() {
            return this.city;
        }

        public String getPhotoDir() {
            return this.photoDir;
        }

        public String getMetadataDir() {
            return this.metadataDir;
        }

        public String getPhotoIdList() {
            return this.photoIdList;
        }
    }
}

