/*
 * Decompiled with CFR 0.152.
 */
package dataset.create;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import model.FlickrImageMetadata;
import util.io.IOUtil;

public class PhotoCopy {
    public static void main(String[] args) {
        String root = "D:\\shared\\IEEE_MM_project\\SIFT extraction\\";
        String missingPhotosList = String.valueOf(root) + "missing_pics.txt";
        String srcFolder = String.valueOf(root) + "Barcelona_207K\\";
        String dstFolder = String.valueOf(root) + "missing_pics\\";
        PhotoCopy.copyFlickrImagesToFlatFolder(missingPhotosList, srcFolder, dstFolder, ".jpg");
    }

    public static void copyMissingMediaEvalPhotosToFolder(String missingPhotosList, String mediaevalPhotoDir, String mediaevalListDir, String ouputDir) {
        HashMap<Long, MediaevalCity> photoToCityMap = new HashMap<Long, MediaevalCity>();
        File[] listFiles = new File(mediaevalListDir).listFiles();
        int i = 0;
        while (i < listFiles.length) {
            List<String> ids = IOUtil.readFileToStringList(listFiles[i].getAbsolutePath());
            String filename = listFiles[i].getName();
            MediaevalCity city = MediaevalCity.valueOf(filename.substring(0, filename.length() - 11));
            for (String id : ids) {
                long flickrId = Long.parseLong(id);
                photoToCityMap.put(flickrId, city);
            }
            ++i;
        }
        List<String> flickrIds = IOUtil.readFileToStringList(missingPhotosList);
        for (String id : flickrIds) {
            long flickrId = Long.parseLong(id);
            MediaevalCity city = (MediaevalCity)((Object)photoToCityMap.get(flickrId));
            String sourceImagePath = PhotoCopy.getImageFilePath(String.valueOf(mediaevalPhotoDir) + city.toString() + File.separator, id, ".jpg");
            File imageFile = new File(sourceImagePath);
            if (imageFile.exists()) {
                String outputPath = String.valueOf(ouputDir) + flickrId + ".jpg";
                if (!new File(new File(outputPath).getParent()).exists()) {
                    new File(new File(outputPath).getParent()).mkdirs();
                }
                if (new File(outputPath).exists()) continue;
                IOUtil.copyFile(sourceImagePath, outputPath);
                continue;
            }
            System.out.println("Could not find image with id: " + id + "(" + (Object)((Object)city) + ")");
        }
    }

    public static void copyFlickrImagesToFlatFolder(List<String> flickrIds, String srcPhotoDir, String dstPhotoDir, String fileExtension) {
        PhotoCopy.copyFlickrPhotos(flickrIds, srcPhotoDir, dstPhotoDir, fileExtension, true);
    }

    public static void copyFlickrImagesToFlatFolder(String flickrIdList, String srcPhotoDir, String dstPhotoDir, String fileExtension) {
        PhotoCopy.copyFlickrPhotos(flickrIdList, srcPhotoDir, dstPhotoDir, fileExtension, true);
    }

    public static void copyFlickrImagesToStructuredFolder(String flickrIdList, String srcPhotoDir, String dstPhotoDir, String fileExtension) {
        PhotoCopy.copyFlickrPhotos(flickrIdList, srcPhotoDir, dstPhotoDir, fileExtension, false);
    }

    protected static void copyFlickrPhotos(String flickrIdList, String srcPhotoDir, String dstPhotoDir, String fileExtension, boolean flatStructure) {
        List<String> flickrIds = IOUtil.readFileToStringList(flickrIdList);
        PhotoCopy.copyFlickrPhotos(flickrIds, srcPhotoDir, dstPhotoDir, fileExtension, flatStructure);
    }

    protected static void copyFlickrPhotos(List<String> flickrIds, String srcPhotoDir, String dstPhotoDir, String fileExtension, boolean flatStructure) {
        File outputFolderFile = new File(dstPhotoDir);
        if (!outputFolderFile.exists()) {
            outputFolderFile.mkdirs();
        }
        System.out.println("I have " + flickrIds.size() + " " + fileExtension + " files");
        int counter = 0;
        for (String flickrId : flickrIds) {
            ++counter;
            String sourceImagePath = PhotoCopy.getImageFilePath(srcPhotoDir, flickrId, fileExtension);
            File imageFile = new File(sourceImagePath);
            if (imageFile.exists()) {
                String outputPath = PhotoCopy.getImageFilePath(dstPhotoDir, flickrId, fileExtension);
                if (flatStructure) {
                    outputPath = String.valueOf(dstPhotoDir) + flickrId + fileExtension;
                }
                if (!new File(new File(outputPath).getParent()).exists()) {
                    new File(new File(outputPath).getParent()).mkdirs();
                }
                if (new File(outputPath).exists()) continue;
                IOUtil.copyFile(sourceImagePath, outputPath);
                if (counter % 100 != 0) continue;
                System.out.println("image " + counter + " / " + flickrIds.size());
                continue;
            }
            System.out.println("image " + counter + " / " + flickrIds.size() + " does not exist: " + flickrId + "(" + imageFile.getAbsolutePath() + ")");
        }
        System.out.println("Done!");
    }

    public static String getImageFilePath(String rootDir, String photoId, String extension) {
        return String.valueOf(PhotoCopy.getImageFilePathNoExtension(rootDir, photoId)) + extension;
    }

    public static String getImageFilePathNoExtension(String rootDir, String photoId) {
        String tempPhotoId = photoId;
        while (tempPhotoId.length() < 12) {
            tempPhotoId = "0" + tempPhotoId;
        }
        String filepath = String.valueOf(rootDir) + File.separator + tempPhotoId.substring(0, 3) + File.separator + tempPhotoId.substring(3, 6) + File.separator + tempPhotoId.substring(6, 9) + File.separator + photoId;
        return filepath;
    }

    public static void findPhotosWithImageInFolder(String initialList, String outputList, String imagePath) {
        List<String> initialIds = IOUtil.readFileToStringList(initialList);
        ArrayList<String> outputIds = new ArrayList<String>();
        for (String id : initialIds) {
            String filepath = PhotoCopy.getImageFilePath(imagePath, id.trim(), ".jpg");
            File image = new File(filepath);
            if (!image.exists()) continue;
            outputIds.add(id);
        }
        IOUtil.writeStringCollectionToFile(outputIds, outputList);
    }

    public static void findPhotosWithGeoInfo(String initialList, String outputList, String metadataPath) {
        List<String> initialIds = IOUtil.readFileToStringList(initialList);
        ArrayList<String> outputIds = new ArrayList<String>();
        for (String id : initialIds) {
            String filepath = FlickrImageMetadata.getImageMetadataFilePath(metadataPath, Long.parseLong(id.trim()));
            FlickrImageMetadata image = FlickrImageMetadata.fromTextFile(filepath);
            if (image.getGeo() == null) continue;
            outputIds.add(id);
        }
        IOUtil.writeStringCollectionToFile(outputIds, outputList);
    }

    public static enum MediaevalCity {
        Amsterdam,
        Barcelona,
        London,
        Paris,
        Rome,
        Raphael;

    }
}

