/*
 * Decompiled with CFR 0.152.
 */
package dataset.create;

import certh.CommonFunctions;
import certh.Config;
import dataset.create.FlickrMetadataParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import model.FlickrImageMetadata;
import org.xml.sax.SAXException;
import util.io.IOUtil;

public class Info {
    public static void main(String[] args) {
        List<String> ids = IOUtil.readFileToStringList(String.valueOf(Config.CITY_PHOTO_LISTS_ROOT) + "Raphael_photos.txt");
        HashSet<Long> raphaelIds = new HashSet<Long>(ids.size());
        for (String id : ids) {
            raphaelIds.add(Long.parseLong(id));
        }
        Info.printDateVerificationSummary(Config.MEVAL_DISTRIBUTED_XML_METADATA_FILE, raphaelIds);
    }

    public static void printDateVerificationSummary(String xmlMetadataFilename, Set<Long> flickrsIdsToCheck) {
        List<FlickrImageMetadata> metadataList = Info.readMetadataList(xmlMetadataFilename);
        int countInvalid = 0;
        int checked = 0;
        for (FlickrImageMetadata metadata : metadataList) {
            if (!flickrsIdsToCheck.contains(metadata.getId())) continue;
            ++checked;
            if (CommonFunctions.verifyFlickrPhotoDate(metadata.getId(), metadata.getTimeString())) continue;
            ++countInvalid;
        }
        System.out.println("Out of time interval:" + countInvalid + "/" + checked);
    }

    public static void printLastfmSummary(String xmlMetadataFilename) {
        List<FlickrImageMetadata> metadataList = Info.readMetadataList(xmlMetadataFilename);
        int countLastfm = 0;
        block0: for (FlickrImageMetadata metadata : metadataList) {
            int i = 0;
            while (i < metadata.getTags().length) {
                if (metadata.getTags()[i].startsWith("lastfm:")) {
                    ++countLastfm;
                    continue block0;
                }
                ++i;
            }
        }
        System.out.println("Last.fm: " + countLastfm + "/" + metadataList.size());
    }

    public static void printGeoSummary(String xmlMetadataFilename) {
        List<FlickrImageMetadata> metadataList = Info.readMetadataList(xmlMetadataFilename);
        int countExplicitGeo = 0;
        int countImplicitGeo = 0;
        int countTotalGeo = 0;
        for (FlickrImageMetadata metadata : metadataList) {
            boolean hasGeoTag = false;
            int i = 0;
            while (i < metadata.getTags().length) {
                if (metadata.getTags()[i].startsWith("geo:")) {
                    hasGeoTag = true;
                    break;
                }
                ++i;
            }
            if (hasGeoTag) {
                ++countImplicitGeo;
                ++countTotalGeo;
            }
            if (metadata.getGeo() == null) continue;
            ++countExplicitGeo;
            if (hasGeoTag) continue;
            ++countTotalGeo;
        }
        System.out.println("Explicit geo: " + countExplicitGeo + "/" + metadataList.size());
        System.out.println("Implicit geo: " + countImplicitGeo + "/" + metadataList.size());
        System.out.println("Total geo: " + countTotalGeo + "/" + metadataList.size());
    }

    protected static List<FlickrImageMetadata> readMetadataList(String xmlMetadataFilename) {
        FlickrMetadataParser parser = new FlickrMetadataParser();
        ArrayList<FlickrImageMetadata> metadataList = new ArrayList(0);
        try {
            metadataList = parser.getFlickrMetadataList(xmlMetadataFilename);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return metadataList;
    }
}

