/*
 * Decompiled with CFR 0.152.
 */
package dataset.create;

import certh.Config;
import dataset.create.FlickrEventParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import model.FlickrDateTimeString;
import org.xml.sax.SAXException;
import util.io.IOUtil;

public class GroundTruthFileCreator {
    public static void main(String[] args) {
        String inputFile1 = String.valueOf(Config.MEVAL_EVAL_DIR) + "2011-06-23-FlickrPhotosParadisoMay2009.csv";
        String inputFile2 = String.valueOf(Config.MEVAL_EVAL_DIR) + "2011-06-23-FlickrPhotosParcDelForumMay2009.csv";
        String outputFile1 = String.valueOf(Config.MEVAL_EVAL_DIR) + "temp1.txt";
        String outputFile2 = String.valueOf(Config.MEVAL_EVAL_DIR) + "temp2.txt";
        String mergedFile = String.valueOf(Config.MEVAL_EVAL_DIR) + "groundtruth_sed_c2.txt";
        String allPhotosListFile = String.valueOf(Config.MEVAL_DATASET_DIR) + "all_photos_list.txt";
        GroundTruthFileCreator.convertRaphaelFileToCsv(inputFile1, allPhotosListFile, outputFile1);
        GroundTruthFileCreator.convertRaphaelFileToCsv(inputFile2, allPhotosListFile, outputFile2);
        GroundTruthFileCreator.mergeCsvFiles(outputFile1, outputFile2, mergedFile);
    }

    public static void convertCrEveToCsv(String inputGroundTruthFile, String outputFile) {
        List<String> lines = IOUtil.readFileToStringList(inputGroundTruthFile);
        HashMap<Integer, HashSet<Long>> eventToFlickrIdMap = new HashMap<Integer, HashSet<Long>>();
        for (String line : lines) {
            String[] parts = line.split("\t");
            long flickrId = Long.parseLong(parts[0]);
            int eventId = Integer.parseInt(parts[1]);
            HashSet<Long> photos = (HashSet<Long>)eventToFlickrIdMap.get(eventId);
            if (photos == null) {
                photos = new HashSet<Long>();
                eventToFlickrIdMap.put(eventId, photos);
            }
            photos.add(flickrId);
        }
        ArrayList<List<Long>> events = new ArrayList<List<Long>>();
        for (Collection event : eventToFlickrIdMap.values()) {
            events.add(new ArrayList(event));
        }
        GroundTruthFileCreator.createResultFile(events, outputFile);
    }

    public static void convertXmlToCsv(String inputGroundTruthFile, String outputFile) {
        FlickrEventParser parser = new FlickrEventParser();
        List<List<Long>> eventList = null;
        try {
            eventList = parser.getNumberOfEvents(inputGroundTruthFile);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (eventList == null) {
            return;
        }
        GroundTruthFileCreator.createResultFile(eventList, outputFile);
    }

    public static void createResultFile(List<List<Long>> events, String filename) {
        ArrayList<String> outputLines = new ArrayList<String>(events.size());
        for (Collection collection : events) {
            StringBuffer buf = new StringBuffer();
            boolean first = true;
            for (Long photoId : collection) {
                if (first) {
                    first = false;
                } else {
                    buf.append(",");
                }
                buf.append(photoId);
            }
            outputLines.add(buf.toString());
        }
        IOUtil.writeStringCollectionToFile(outputLines, filename);
    }

    public static void convertRaphaelFileToCsv(String raphaelFile, String allPhotosListFile, String outputFile) {
        List<String> flickrIdLines = IOUtil.readFileToStringList(allPhotosListFile);
        HashSet<Long> flickrIds = new HashSet<Long>();
        for (String flickrId : flickrIdLines) {
            flickrIds.add(Long.parseLong(flickrId));
        }
        List<List<Long>> events = GroundTruthFileCreator.readRaphaelEvents(raphaelFile, flickrIds);
        GroundTruthFileCreator.createResultFile(events, outputFile);
    }

    public static List<List<Long>> readRaphaelEvents(String file, Set<Long> availablePhotos) {
        HashMap<Long, HashSet<Long>> eventPhotosMap = new HashMap<Long, HashSet<Long>>();
        List<String> lines = IOUtil.readFileToStringList(file);
        String place = "";
        for (String line : lines) {
            String[] parts = line.split(";");
            place = parts[4];
            long flickrId = Long.parseLong(parts[5]);
            FlickrDateTimeString date = new FlickrDateTimeString(parts[2]);
            HashSet<Long> eventPhotos = (HashSet<Long>)eventPhotosMap.get(new Long(date.getDay()));
            if (eventPhotos == null) {
                eventPhotos = new HashSet<Long>();
                eventPhotosMap.put(new Long(date.getDay()), eventPhotos);
            }
            eventPhotos.add(flickrId);
        }
        int originalAssociations = 0;
        int filteredAssociations = 0;
        ArrayList<List<Long>> events = new ArrayList<List<Long>>(eventPhotosMap.keySet().size());
        for (Map.Entry eventEntry : eventPhotosMap.entrySet()) {
            ArrayList<Long> eventPhotos = new ArrayList<Long>();
            originalAssociations += ((Set)eventEntry.getValue()).size();
            for (Long photo : (Set)eventEntry.getValue()) {
                if (!availablePhotos.contains(photo)) continue;
                eventPhotos.add(photo);
            }
            if (eventPhotos.size() <= 0) continue;
            System.out.println("Event @ " + eventEntry.getKey() + " May (" + place + "):" + eventPhotos.size());
            events.add(eventPhotos);
            filteredAssociations += eventPhotos.size();
        }
        System.out.println("#events (orig):" + eventPhotosMap.keySet().size());
        System.out.println("#events (filt):" + events.size());
        System.out.println("#event-photo associations (orig): " + originalAssociations);
        System.out.println("#event-photo associations (filt): " + filteredAssociations);
        return events;
    }

    public static void mergeCsvFiles(String file1, String file2, String mergedFile) {
        List<String> lines = IOUtil.readFileToStringList(file1);
        lines.addAll(IOUtil.readFileToStringList(file2));
        IOUtil.writeStringCollectionToFile(lines, mergedFile);
    }
}

