/*
 * Decompiled with CFR 0.152.
 */
package dataset.create;

import certh.Config;
import dataset.create.PhotoCopy;
import eval.Evaluator;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import util.io.IOUtil;

public class GroundTruthExaminer {
    public static void main(String[] args) {
        String groundTruthFile = String.valueOf(Config.MEVAL_EVAL_DIR) + "SED11_submissions_evaluation" + File.separator + "sed_task1_groundtruth_BCN_ROM.txt";
        String photoIdList = Config.ALL_MEVAL_FLICKR_IDS_FILE;
        String newGroundTruth = String.valueOf(Config.MEVAL_EVAL_DIR) + "SED11_submissions_evaluation" + File.separator + "sed_task1_groundtruth_BCN_ROM_v2.txt";
        GroundTruthExaminer.checkGroundTruth(groundTruthFile, photoIdList, newGroundTruth);
    }

    public static void checkGroundTruth(String groundTruthFile, String photoIdList, String newGroundTruth) {
        List<String> lines = IOUtil.readFileToStringList(groundTruthFile);
        HashSet<String> photoIds = new HashSet<String>(IOUtil.readFileToStringList(photoIdList));
        ArrayList<String> outputLines = new ArrayList<String>();
        int notIncluded = 0;
        int total = 0;
        for (String line : lines) {
            long[] ids = Evaluator.getPhotoIds(line);
            total += ids.length;
            StringBuffer buf = new StringBuffer();
            boolean first = true;
            int i = 0;
            while (i < ids.length) {
                if (!photoIds.contains(String.valueOf(ids[i]))) {
                    ++notIncluded;
                } else {
                    if (!first) {
                        buf.append(",");
                    } else {
                        first = false;
                    }
                    buf.append(String.valueOf(ids[i]));
                }
                ++i;
            }
            outputLines.add(buf.toString());
        }
        System.out.println(String.valueOf(notIncluded) + "/" + total + " photos are not included in ground truth.");
        IOUtil.writeStringCollectionToFile(outputLines, newGroundTruth);
    }

    public static void copyGroundTruthPhotosToFolders(String groundTruthFile, String outputDirectory) {
        int count = 0;
        List<String> lines = IOUtil.readFileToStringList(groundTruthFile);
        for (String line : lines) {
            String eventDirectory = String.valueOf(outputDirectory) + ++count + File.separator;
            new File(eventDirectory).mkdirs();
            String[] parts = line.split(",");
            ArrayList<String> flickrIds = new ArrayList<String>();
            int i = 0;
            while (i < parts.length) {
                flickrIds.add(parts[i]);
                ++i;
            }
            PhotoCopy.copyFlickrImagesToFlatFolder(flickrIds, Config.MEVAL_METADATA_ROOT, eventDirectory, ".txt");
        }
    }
}

