/*
 * Decompiled with CFR 0.152.
 */
package dataset.create;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Timestamp;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import model.FlickrImageMetadata;
import util.io.IOUtil;

public class FlickrMetadataXmlifier {
    private static String city = "London";
    private static String root = "/media/RAID/mediaeval/";
    private static String metadataRoot = String.valueOf(root) + city + File.separator + "flickr_metadata" + File.separator;
    private static String xmlResultsFile = String.valueOf(root) + "flickrMetadata_all" + ".xml";
    private static Pattern p = Pattern.compile(".*:.*=");
    protected BufferedWriter writer;
    protected int numberOfMetadata = 0;
    protected int numberOfGeoMetadata = 0;

    public static void main(String[] args) {
        String[] cities = new String[]{"Dataset"};
        FlickrMetadataXmlifier xmlCreator = new FlickrMetadataXmlifier();
        xmlCreator.startXml(xmlResultsFile);
        int i = 0;
        while (i < cities.length) {
            xmlCreator.addCityMetadata(root, cities[i], 0.2);
            ++i;
        }
        xmlCreator.closeXml();
    }

    public void startXml(String xmlFile) {
        try {
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(xmlFile), "UTF8"));
            this.writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            this.writer.write("<photos>\n");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void closeXml() {
        try {
            this.writer.write("</photos>");
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Number of metadata: " + this.numberOfMetadata);
        System.out.println("Number of geo: " + this.numberOfGeoMetadata);
    }

    public void addCityMetadata(String rootDirectory, String city, double percentageGeo) {
        String metadataRoot = String.valueOf(rootDirectory) + city + File.separator + "flickr_metadata" + File.separator;
        String idList = String.valueOf(rootDirectory) + city + File.separator + "clean_" + city + "_ID_LIST_GEO.txt";
        List<String> ids = IOUtil.readFileToStringList(idList);
        int i = 0;
        while (i < ids.size()) {
            String path = FlickrImageMetadata.getImageMetadataFilePath(metadataRoot, Long.parseLong(ids.get(i)));
            FlickrImageMetadata photo = FlickrImageMetadata.fromTextFile(path);
            if (photo != null) {
                if (photo.getLicence().equals("0")) {
                    System.out.println(String.valueOf(city) + " Licence: " + photo.getLicence());
                }
                double p = Math.random();
                if ("All".equals(city)) {
                    p = 0.0;
                }
                try {
                    if (p < percentageGeo) {
                        this.writer.write(FlickrMetadataXmlifier.flickrPhotoMetadataToXmlElement(photo, true));
                        ++this.numberOfGeoMetadata;
                    } else {
                        this.writer.write(FlickrMetadataXmlifier.flickrPhotoMetadataToXmlElement(photo, false));
                    }
                    ++this.numberOfMetadata;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (i % 1000 == 0) {
                    System.out.println(String.valueOf(i) + " out of " + ids.size() + " photos have been processed");
                }
            }
            ++i;
        }
    }

    public static void createFlickrMetadataXml(List<String> ids, String xmlFile) {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(xmlFile), "UTF8"));
            writer.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            writer.write("<photos>\n");
            int i = 0;
            while (i < ids.size()) {
                String path = FlickrImageMetadata.getImageMetadataFilePath(metadataRoot, Long.parseLong(ids.get(i)));
                FlickrImageMetadata photo = FlickrImageMetadata.fromTextFile(path);
                writer.write(FlickrMetadataXmlifier.flickrPhotoMetadataToXmlElement(photo, true));
                if (i % 1000 == 0) {
                    System.out.println(String.valueOf(i) + " out of " + ids.size() + " photos have been processed");
                }
                ++i;
            }
            writer.write("</photos>");
            writer.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String flickrPhotoMetadataToXmlElement(FlickrImageMetadata photo, boolean includeLocation) {
        StringBuffer xmlStringElement = new StringBuffer();
        Timestamp timeCaptured = new Timestamp(photo.getTimeTaken());
        Timestamp timeUploaded = new Timestamp(photo.getTimeUploaded());
        String dateC = timeCaptured.toString();
        String dateU = timeUploaded.toString();
        String description = "";
        if (photo.getDescription() != null) {
            description = photo.getDescription();
        }
        xmlStringElement.append("<photo id=\"" + photo.getId() + "\" photo_url=\"" + photo.getUrl() + "\" username=\"" + FlickrMetadataXmlifier.getValidXmlString(photo.getUsername()) + "\" dateTaken=\"" + dateC + "\" dateUploaded=\"" + dateU + "\">" + "\n");
        xmlStringElement.append("<title>" + FlickrMetadataXmlifier.getValidXmlString(photo.getTitle()) + "</title>" + "\n");
        xmlStringElement.append("<description>\n" + FlickrMetadataXmlifier.getValidXmlString(description) + "\n" + "</description>" + "\n");
        xmlStringElement.append("<tags>\n");
        for (String tag : photo.getTagsList()) {
            if (FlickrMetadataXmlifier.isMachineTag(tag)) continue;
            xmlStringElement.append("<tag>" + FlickrMetadataXmlifier.getValidXmlString(tag) + "</tag>" + "\n");
        }
        xmlStringElement.append("</tags>\n");
        if (includeLocation && photo.getGeo() != null) {
            xmlStringElement.append("<location latitude=\"" + photo.getGeo().getLatitude() + "\" longitude=\"" + photo.getGeo().getLongitude() + "\"></location>" + "\n");
        }
        xmlStringElement.append("</photo>\n");
        return xmlStringElement.toString();
    }

    private static boolean isMachineTag(String tag) {
        Matcher m = p.matcher(tag);
        return m.find();
    }

    private static String getValidXmlString(String chunk) {
        if (chunk == null || chunk.length() < 1) {
            return chunk;
        }
        return chunk.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;");
    }
}

