/*
 * Decompiled with CFR 0.152.
 */
package dataset.create;

import dataset.create.PhotoCopy;
import geo.Geo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import model.FlickrDateTimeString;
import model.FlickrImageMetadata;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import util.io.BaseXmlParser;
import util.io.IOUtil;

public class FlickrMetadataParser
extends BaseXmlParser {
    private static final String FLICKR_PHOTO_PAGE_PREFIX = "http://www.flickr.com/photos/";
    private static final String MACHINE_LATITUTE_TAG = "geo:lat=";
    private static final String MACHINE_LONGITUTE_TAG = "geo:lon=";
    private static final String DATE_TAKEN = "dateTaken";
    private static final String DATE_UPLOADED = "dateUploaded";
    private static final String USERNAME = "username";
    private static final String PHOTO_URL = "photo_url";
    private static final String PHOTO = "photo";
    private static final String TAGS = "tags";
    private static final String DESCRIPTION = "description";
    private static final String TITLE = "title";
    private static final String LOCATION = "location";
    private static final String LATITUDE = "latitude";
    private static final String LONGITUDE = "longitude";
    private static final String ID = "id";

    public static void main(String[] args) {
        String metadataFile = "/media/RAID/mediaeval/flickrMetadata_all.xml";
        FlickrMetadataParser parser = new FlickrMetadataParser();
        List<Object> metadataList = new ArrayList(0);
        try {
            metadataList = parser.getFlickrMetadataList(metadataFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        System.out.println(String.valueOf(metadataList.size()) + " image metadata read.");
        int geo = 0;
        HashSet<String> users = new HashSet<String>();
        HashMap<Integer, Integer> years = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < (1000000000 > metadataList.size() ? metadataList.size() : 10)) {
            List<String> mach_tags;
            FlickrImageMetadata mtl = (FlickrImageMetadata)metadataList.get(i);
            if (mtl.getGeo() == null) {
                ++geo;
            }
            if ((mach_tags = mtl.getMachineTags()) != null) {
                System.out.println(mach_tags.size());
            }
            String userId = mtl.getUsername();
            users.add(userId);
            FlickrDateTimeString time = mtl.getTimeString();
            int year = time.getYear();
            Integer c = null;
            c = (Integer)years.get(year);
            if (c != null) {
                years.put(year, c + 1);
            } else {
                years.put(year, 1);
            }
            ++i;
        }
        System.out.println(metadataList.size() - geo);
        System.out.println(metadataList.size());
        System.out.println((double)geo / (double)metadataList.size());
        System.out.println(String.valueOf(users.size()) + " users");
        for (Integer year : years.keySet()) {
            System.out.println(year + " " + years.get(year) + " photos");
        }
    }

    public static void createFlickrIdUrlFile(String metadataRoot, String idListFile, String outputFile) {
        List<String> ids = IOUtil.readFileToStringList(idListFile);
        ArrayList<String> outputLines = new ArrayList<String>();
        int i = 0;
        while (i < ids.size()) {
            FlickrImageMetadata metadata = FlickrImageMetadata.fromTextFile(PhotoCopy.getImageFilePath(metadataRoot, ids.get(i), ".txt"));
            outputLines.add(String.valueOf(ids.get(i)) + "\t" + FLICKR_PHOTO_PAGE_PREFIX + metadata.getUserID() + "/" + ids.get(i));
            ++i;
        }
        IOUtil.writeStringCollectionToFile(outputLines, outputFile);
    }

    public Map<Long, FlickrImageMetadata> getFlickrMetadataMap(String xmlFilename) throws IOException, ParserConfigurationException, SAXException {
        HashMap<Long, FlickrImageMetadata> map = new HashMap<Long, FlickrImageMetadata>();
        List<FlickrImageMetadata> metadataList = this.getFlickrMetadataList(xmlFilename);
        for (FlickrImageMetadata metadata : metadataList) {
            map.put(metadata.getId(), metadata);
        }
        return map;
    }

    public List<FlickrImageMetadata> getFlickrMetadataList(String xmlFilename) throws IOException, ParserConfigurationException, SAXException {
        Document doc = this.parseXml(xmlFilename);
        NodeList photoNodes = doc.getElementsByTagName(PHOTO);
        ArrayList<FlickrImageMetadata> metadataList = new ArrayList<FlickrImageMetadata>(photoNodes.getLength());
        int i = 0;
        while (i < photoNodes.getLength()) {
            Long photoId = Long.parseLong(photoNodes.item(i).getAttributes().getNamedItem(ID).getNodeValue());
            String url = photoNodes.item(i).getAttributes().getNamedItem(PHOTO_URL).getNodeValue();
            FlickrImageMetadata metadata = new FlickrImageMetadata(photoId, url);
            String username = photoNodes.item(i).getAttributes().getNamedItem(USERNAME).getNodeValue();
            metadata.setUsername(username);
            String dateTaken = photoNodes.item(i).getAttributes().getNamedItem(DATE_TAKEN).getNodeValue();
            metadata.setTimeString(dateTaken);
            NodeList childNodes = photoNodes.item(i).getChildNodes();
            int x = 0;
            while (x < childNodes.getLength()) {
                String nodeName = childNodes.item(x).getNodeName();
                if (TITLE.equals(nodeName)) {
                    metadata.setTitle(this.getTitle(childNodes.item(x)));
                } else if (DESCRIPTION.equals(nodeName)) {
                    metadata.setDescription(this.getDescription(childNodes.item(x)));
                } else if (TAGS.equals(nodeName)) {
                    metadata.setTags(this.getTags(childNodes.item(x)));
                    double latitude = 0.0;
                    double longitude = 0.0;
                    int geoMachineTags = 0;
                    int y = 0;
                    while (y < metadata.getTags().length) {
                        if (metadata.getTags()[y].startsWith(MACHINE_LATITUTE_TAG)) {
                            latitude = Double.parseDouble(metadata.getTags()[y].substring(MACHINE_LATITUTE_TAG.length()));
                            ++geoMachineTags;
                        }
                        if (metadata.getTags()[y].startsWith(MACHINE_LONGITUTE_TAG)) {
                            longitude = Double.parseDouble(metadata.getTags()[y].substring(MACHINE_LONGITUTE_TAG.length()));
                            ++geoMachineTags;
                        }
                        ++y;
                    }
                    if (geoMachineTags == 2) {
                        metadata.setGeo(new Geo(longitude, latitude));
                    }
                } else if (LOCATION.equals(nodeName)) {
                    metadata.setGeo(this.getGeo(childNodes.item(x)));
                }
                ++x;
            }
            metadataList.add(metadata);
            ++i;
        }
        return metadataList;
    }

    protected String getTitle(Node titleNode) {
        return titleNode.getTextContent();
    }

    protected String getDescription(Node descriptionNode) {
        return descriptionNode.getTextContent();
    }

    protected Geo getGeo(Node locationNode) {
        double latitude = Double.parseDouble(locationNode.getAttributes().getNamedItem(LATITUDE).getNodeValue());
        double longitude = Double.parseDouble(locationNode.getAttributes().getNamedItem(LONGITUDE).getNodeValue());
        return new Geo(longitude, latitude);
    }

    protected List<String> getTags(Node tagNode) {
        NodeList tagNodes = tagNode.getChildNodes();
        ArrayList<String> tags = new ArrayList<String>(tagNodes.getLength());
        int i = 0;
        while (i < tagNodes.getLength()) {
            tags.add(tagNodes.item(i).getTextContent());
            ++i;
        }
        return tags;
    }
}

