/*
 * Decompiled with CFR 0.152.
 */
package dataset.create;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import util.io.BaseXmlParser;
import util.io.IOUtil;

public class FlickrEventParser
extends BaseXmlParser {
    private static final String EVENT = "event";
    private static final String PHOTOS = "photos";
    private static final String PHOTO = "photo";
    private static final String ID = "id";

    public static void main(String[] args) {
        FlickrEventParser parser = new FlickrEventParser();
        String filename = "D:/mediaeval/distribution/flickrMetadata_v5.xml";
        String listFile = "D:/mediaeval/distribution/all_photos_list.txt";
        try {
            List<Long> flickrIds = parser.getPhotoIds(filename);
            System.out.println("Found " + flickrIds.size() + " photos");
            ArrayList<String> ids = new ArrayList<String>(flickrIds.size());
            for (Long flickrId : flickrIds) {
                ids.add(String.valueOf(flickrId));
            }
            IOUtil.writeStringCollectionToFile(ids, listFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Long> getPhotoIds(String xmlFilename) throws IOException, ParserConfigurationException, SAXException {
        ArrayList<Long> photoIds = new ArrayList<Long>();
        Document doc = this.parseXml(xmlFilename);
        NodeList photoNodes = doc.getElementsByTagName(PHOTO);
        int i = 0;
        while (i < photoNodes.getLength()) {
            String photoId = photoNodes.item(i).getAttributes().getNamedItem(ID).getNodeValue();
            photoIds.add(Long.parseLong(photoId));
            ++i;
        }
        return photoIds;
    }

    public List<List<Long>> getNumberOfEvents(String xmlFilename) throws IOException, ParserConfigurationException, SAXException {
        ArrayList<List<Long>> eventList = new ArrayList<List<Long>>();
        Document doc = this.parseXml(xmlFilename);
        NodeList nList = doc.getElementsByTagName(EVENT);
        int i = 0;
        while (i < nList.getLength()) {
            ArrayList<Long> eventPhotos = new ArrayList<Long>();
            Node currentEventNode = nList.item(i);
            NodeList eventChildrenNodes = currentEventNode.getChildNodes();
            int x = 0;
            while (x < eventChildrenNodes.getLength()) {
                if (PHOTOS.equals(eventChildrenNodes.item(x).getNodeName())) {
                    NodeList photoNodes = eventChildrenNodes.item(x).getChildNodes();
                    int z = 0;
                    while (z < photoNodes.getLength()) {
                        if (PHOTO.equals(photoNodes.item(z).getNodeName())) {
                            String photoId = photoNodes.item(z).getAttributes().getNamedItem(ID).getNodeValue();
                            eventPhotos.add(Long.parseLong(photoId));
                        }
                        ++z;
                    }
                }
                ++x;
            }
            eventList.add(eventPhotos);
            ++i;
        }
        return eventList;
    }
}

