/*
 * Decompiled with CFR 0.152.
 */
package clust;

import certh.Config;
import clust.ImageSimilarity;
import edu.uci.ics.jung.graph.UndirectedSparseMultigraph;
import eval.CosineSimilarity;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import util.io.JungGraphReader;
import util.io.JungGraphWriter;
import vis.FeatureVectorStructure;
import vis.RankedImage;
import vis.VisualFeatureParser;

public class VisualSimilarityGraphCreator {
    private static final int AVERAGE_GRAPH_DEGREE = 15;
    private static final int MAXIMUM_NUMBER_OF_SIMILAR_PER_IMAGE = 200;
    private static final DecimalFormat DF = new DecimalFormat("#.#####");
    private static final String VISUAL_GRAPH_FILENAME = String.valueOf(Config.MEVAL_RESOURCE_DIR) + "sift\\visual_graph.txt";
    private static final String VISUAL_SIMILARITY_FILENAME = String.valueOf(Config.MEVAL_RESOURCE_DIR) + "sift\\visual_similarities.txt";

    public static void main(String[] args) {
        String siftFlickrFile = String.valueOf(Config.MEVAL_RESOURCE_DIR) + "sift\\all_FlickrSIFT.bow";
        VisualFeatureParser parser = new VisualFeatureParser();
        FeatureVectorStructure feats = parser.readFeatureVectors(siftFlickrFile);
        UndirectedSparseMultigraph<Long, ImageSimilarity> graph = VisualSimilarityGraphCreator.createVisualSimilaritiyGraph(feats);
        System.out.println("V: " + graph.getVertexCount() + ",  E:" + graph.getEdgeCount());
    }

    public static UndirectedSparseMultigraph<Long, ImageSimilarity> createVisualSimilaritiyGraph(FeatureVectorStructure features) {
        UndirectedSparseMultigraph<Long, ImageSimilarity> graph;
        block11: {
            if (new File(VISUAL_GRAPH_FILENAME).exists()) {
                return JungGraphReader.readMultiGraph(VISUAL_GRAPH_FILENAME);
            }
            System.out.println("Attempting create visual similarity graph...");
            graph = new UndirectedSparseMultigraph<Long, ImageSimilarity>();
            VisualSimilarityGraphCreator.computePairwiseSimilarities(features);
            double similarityPercentile = 0.075;
            double similarityThreshold = VisualSimilarityGraphCreator.computeSimilarityThreshold(similarityPercentile);
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(VISUAL_SIMILARITY_FILENAME), "UTF8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    String[] parts = line.split("\t");
                    Long currentPhoto = Long.parseLong(parts[0]);
                    ArrayList<Long> similarPhotos = new ArrayList<Long>();
                    ArrayList<Double> similarities = new ArrayList<Double>();
                    int i = 2;
                    while (i < parts.length) {
                        double sim = Double.parseDouble(parts[i]);
                        if (sim < similarityThreshold) break;
                        similarPhotos.add(Long.parseLong(parts[i - 1]));
                        similarities.add(sim);
                        i += 2;
                    }
                    if (similarities.size() <= 0) continue;
                    if (!graph.containsVertex(currentPhoto)) {
                        graph.addVertex(currentPhoto);
                    }
                    i = 0;
                    while (i < similarPhotos.size()) {
                        ImageSimilarity similarity;
                        if (!graph.containsVertex((Long)similarPhotos.get(i))) {
                            graph.addVertex((Long)similarPhotos.get(i));
                        }
                        if ((similarity = graph.findEdge(currentPhoto, (Long)similarPhotos.get(i))) == null) {
                            graph.addEdge(new ImageSimilarity(ImageSimilarity.ImageSimilarityType.VISUAL, new Float((Double)similarities.get(i)).floatValue()), currentPhoto, (Long)similarPhotos.get(i));
                        }
                        ++i;
                    }
                }
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                if (reader == null) break block11;
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        JungGraphWriter.writeGraph(VISUAL_GRAPH_FILENAME, graph);
        return graph;
    }

    protected static void computePairwiseSimilarities(FeatureVectorStructure featureVectors) {
        int numberOfSelectedImagesCosineSim = 200;
        try {
            BufferedWriter outputFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(VISUAL_SIMILARITY_FILENAME), "UTF8"));
            ArrayList<RankedImage> rankedImages = new ArrayList<RankedImage>();
            List<Double> magnitudes = CosineSimilarity.calculateMagnitude(featureVectors);
            long time = System.currentTimeMillis();
            int i = 0;
            while (i < featureVectors.getNumberOfVectors()) {
                if (i % 101 == 0) {
                    time = System.currentTimeMillis();
                    System.out.print("Calculating similar photos for photo " + (i + 1) + "...");
                }
                double[] tempVector1 = featureVectors.getFeatureVector(i);
                outputFileWriter.write(String.valueOf(featureVectors.getFlickrId(i)) + "\t");
                rankedImages.clear();
                int j = 0;
                while (j < featureVectors.getNumberOfVectors()) {
                    if (i != j) {
                        double[] tempVector2 = featureVectors.getFeatureVector(j);
                        double cosineDist = CosineSimilarity.cosineDistance(tempVector1, tempVector2, magnitudes.get(i), magnitudes.get(j));
                        rankedImages.add(new RankedImage(j, cosineDist));
                    }
                    ++j;
                }
                Collections.sort(rankedImages, Collections.reverseOrder());
                int k = 0;
                while (k < numberOfSelectedImagesCosineSim) {
                    String DFdouble = DF.format(((RankedImage)rankedImages.get(k)).getDistance()).replace(",", ".");
                    outputFileWriter.write(String.valueOf(featureVectors.getFlickrId(((RankedImage)rankedImages.get(k)).getId())) + "\t" + DFdouble + "\t");
                    ++k;
                }
                outputFileWriter.newLine();
                if (i % 100 == 0) {
                    System.out.println("END..." + (System.currentTimeMillis() - time) + " milliseconds");
                }
                ++i;
            }
            outputFileWriter.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static double computeSimilarityThreshold(double percentile) {
        ArrayList<Double> similarities;
        block6: {
            similarities = new ArrayList<Double>();
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(VISUAL_SIMILARITY_FILENAME), "UTF8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    String[] parts = line.split("\t");
                    int i = 2;
                    while (i < parts.length) {
                        similarities.add(Double.parseDouble(parts[i]));
                        i += 2;
                    }
                }
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                if (reader == null) break block6;
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        Collections.sort(similarities, Collections.reverseOrder());
        int idx = (int)(percentile * (double)similarities.size());
        return (Double)similarities.get(idx);
    }
}

