/*
 * Decompiled with CFR 0.152.
 */
package clust;

import clust.ImageSimilarity;
import dataset.create.FlickrMetadataParser;
import edu.uci.ics.jung.graph.UndirectedSparseMultigraph;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import model.FlickrImageMetadata;
import org.xml.sax.SAXException;
import tag.FlickrPhotoTagExtractor;
import tag.SimilarTagFinder;
import util.io.JungGraphReader;
import util.io.JungGraphWriter;

public class TextSimilarityGraphCreator {
    protected static String MEDIAEVAL_ROOT = "D:\\mediaeval\\";
    protected static String METADATA_FILE = String.valueOf(MEDIAEVAL_ROOT) + "flickrMetadata_v5.xml";
    private static final String TAG_GRAPH_FILENAME = "D:\\mediaeval\\resources\\similar_tag_models\\tag_graph.txt";
    private static double TAG_COOCURRENCE_FILTER = 5.0;
    private static int MAX_TAG_FREQUENCY = 300;

    public static void main(String[] args) {
        FlickrMetadataParser parser = new FlickrMetadataParser();
        Map<Long, FlickrImageMetadata> metadataMap = null;
        try {
            metadataMap = parser.getFlickrMetadataMap(METADATA_FILE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        UndirectedSparseMultigraph<Long, ImageSimilarity> graph = TextSimilarityGraphCreator.createTagSimilaritiyGraph(metadataMap);
        System.out.println(String.valueOf(graph.getVertexCount()) + " " + graph.getEdgeCount());
    }

    public static UndirectedSparseMultigraph<Long, ImageSimilarity> createTagSimilaritiyGraph(Map<Long, FlickrImageMetadata> metadataMap) {
        if (new File(TAG_GRAPH_FILENAME).exists()) {
            return JungGraphReader.readMultiGraph(TAG_GRAPH_FILENAME);
        }
        System.out.println("Attempting create tag similarity graph...");
        UndirectedSparseMultigraph<Long, ImageSimilarity> graph = new UndirectedSparseMultigraph<Long, ImageSimilarity>();
        List<List<Long>> imageCooccurrenceLists = TextSimilarityGraphCreator.getTagImageCooccurrenceLists(metadataMap);
        int x = 0;
        while (x < imageCooccurrenceLists.size()) {
            if (imageCooccurrenceLists.get(x).size() != 1) {
                List<Long> imageList = imageCooccurrenceLists.get(x);
                int i = 0;
                while (i < imageList.size()) {
                    if (!graph.containsVertex(imageList.get(i))) {
                        graph.addVertex(imageList.get(i));
                    }
                    ++i;
                }
                i = 0;
                while (i < imageList.size() - 1) {
                    Long flickrIdSourceVertex = imageList.get(i);
                    int j = i + 1;
                    while (j < imageList.size()) {
                        Long flickrIdDestinationVertex = imageList.get(j);
                        ImageSimilarity tempImageSimilarity = null;
                        tempImageSimilarity = graph.findEdge(flickrIdSourceVertex, flickrIdDestinationVertex);
                        if (tempImageSimilarity == null) {
                            tempImageSimilarity = new ImageSimilarity(ImageSimilarity.ImageSimilarityType.TAG, 1.0f);
                            graph.addEdge(tempImageSimilarity, flickrIdSourceVertex, flickrIdDestinationVertex);
                        } else {
                            float weight = tempImageSimilarity.getWeight();
                            tempImageSimilarity.setWeight(weight + 1.0f);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            ++x;
        }
        ArrayList<ImageSimilarity> edgesToRemove = new ArrayList<ImageSimilarity>();
        for (ImageSimilarity tempEdge : graph.getEdges()) {
            if (!((double)tempEdge.getWeight() <= TAG_COOCURRENCE_FILTER)) continue;
            edgesToRemove.add(tempEdge);
        }
        for (ImageSimilarity edgeToRemove : edgesToRemove) {
            graph.removeEdge(edgeToRemove);
        }
        ArrayList<Long> verticesToRemove = new ArrayList<Long>();
        for (Long vertex : graph.getVertices()) {
            if (graph.degree(vertex) != 0) continue;
            verticesToRemove.add(vertex);
        }
        for (Long vertexToRemove : verticesToRemove) {
            graph.removeVertex(vertexToRemove);
        }
        JungGraphWriter.writeGraph(TAG_GRAPH_FILENAME, graph);
        return graph;
    }

    protected static List<List<Long>> getTagImageCooccurrenceLists(Map<Long, FlickrImageMetadata> metadataMap) {
        System.out.println("Attempting to generate tag-photos map...");
        Map<String, Set<Long>> tagPhotosMap = TextSimilarityGraphCreator.generateTagPhotosMap(metadataMap);
        System.out.println("Attempting to generate similar tag map...");
        Map<String, String> similarTagsMap = SimilarTagFinder.generateSimilarTagMap(tagPhotosMap);
        System.out.println("Creating photo cooccurrence lists...");
        HashSet<String> tagsToRemove = new HashSet<String>();
        for (Map.Entry<String, String> entry : similarTagsMap.entrySet()) {
            Set<Long> srcPhotos = tagPhotosMap.get(entry.getKey());
            Set<Long> dstPhotos = tagPhotosMap.get(entry.getValue());
            if (srcPhotos == null || dstPhotos == null) continue;
            dstPhotos.addAll(srcPhotos);
            tagsToRemove.add(entry.getKey());
        }
        for (Map.Entry<String, Object> entry : tagPhotosMap.entrySet()) {
            if (((Set)entry.getValue()).size() <= MAX_TAG_FREQUENCY) continue;
            tagsToRemove.add(entry.getKey());
        }
        for (String string : tagsToRemove) {
            tagPhotosMap.remove(string);
        }
        ArrayList<List<Long>> arrayList = new ArrayList<List<Long>>(tagPhotosMap.size());
        for (Set<Long> imageList : tagPhotosMap.values()) {
            arrayList.add(new ArrayList<Long>(imageList));
        }
        return arrayList;
    }

    protected static Map<String, Set<Long>> generateTagPhotosMap(Map<Long, FlickrImageMetadata> metadata) {
        HashMap<String, Set<Long>> tagPhotosMap = new HashMap<String, Set<Long>>();
        for (Map.Entry<Long, FlickrImageMetadata> flickrEntry : metadata.entrySet()) {
            List<String> tags = FlickrPhotoTagExtractor.getTagsTitle(flickrEntry.getValue());
            for (String tag : tags) {
                HashSet<Long> photoSet = (HashSet<Long>)tagPhotosMap.get(tag);
                if (photoSet == null) {
                    photoSet = new HashSet<Long>();
                    tagPhotosMap.put(tag, photoSet);
                }
                photoSet.add(flickrEntry.getKey());
            }
        }
        return tagPhotosMap;
    }
}

