/*
 * Decompiled with CFR 0.152.
 */
package clust;

import edu.uci.ics.jung.algorithms.scoring.EdgeScorer;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class StructuralSimilarityScorer<V, E>
implements EdgeScorer<E, Double> {
    private Graph<V, E> g = null;
    private Map<E, Double> scoreMap = new HashMap<E, Double>();

    public StructuralSimilarityScorer(Graph<V, E> g) {
        this.g = g;
    }

    public void evaluate() {
        if (this.g == null) {
            System.err.println("ERROR: Graph is null!");
            return;
        }
        Collection edges = this.g.getEdges();
        for (Object e : edges) {
            this.getEdgeScore(e);
        }
    }

    @Override
    public Double getEdgeScore(E e) {
        Double score = this.scoreMap.get(e);
        if (score != null) {
            return score;
        }
        Pair<V> ends = this.g.getEndpoints(e);
        HashSet<V> vmap = new HashSet<V>(this.g.getNeighbors(ends.getFirst()));
        vmap.add(ends.getFirst());
        Collection<V> v1Neighbors = this.g.getNeighbors(ends.getSecond());
        int countCommon = 0;
        if (vmap.contains(ends.getSecond())) {
            ++countCommon;
        }
        for (V neighbor : v1Neighbors) {
            if (!vmap.contains(neighbor)) continue;
            ++countCommon;
        }
        Double structureSimilarity = (double)countCommon / Math.sqrt(vmap.size() * (v1Neighbors.size() + 1));
        this.scoreMap.put(e, structureSimilarity);
        return structureSimilarity;
    }
}

