/*
 * Decompiled with CFR 0.152.
 */
package clust;

import clust.Community;
import edu.uci.ics.jung.graph.Graph;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class ScanCommunityStructure<V, E> {
    private Map<V, Integer> cMap = new HashMap<V, Integer>();
    private Map<Integer, Community<V, E>> communities = new HashMap<Integer, Community<V, E>>();
    private List<V> hubs = new ArrayList<V>();
    private Map<V, Integer> availableHubs = new HashMap<V, Integer>();
    private List<V> outliers = new ArrayList<V>();
    private Set<V> availableOutliers = new HashSet<V>();
    private Graph<V, E> graph = null;
    public static int numberOfMembersThreshold = 1000;
    public static int radiusThreshold = 1000;
    public static Long maximumDuration = new Long(315569259747L);

    public ScanCommunityStructure(Graph<V, E> g) {
        this.graph = g;
    }

    public void setHubsAndOutliers(ScanCommunityStructure<V, E> structure) {
        List<V> listOfHubs = structure.getHubs();
        int i = 0;
        while (i < listOfHubs.size()) {
            this.addHub(listOfHubs.get(i), structure.getHubAdjacentCommunities(listOfHubs.get(i)));
            ++i;
        }
        List<V> listOfOutliers = structure.getOutliers();
        int i2 = 0;
        while (i2 < listOfOutliers.size()) {
            this.addOutlier(listOfOutliers.get(i2));
            ++i2;
        }
    }

    public boolean addCommunity(Community<V, E> community) {
        int maxID = -1;
        for (Integer cID : this.communities.keySet()) {
            if (cID <= maxID) continue;
            maxID = cID;
        }
        this.communities.put(++maxID, community);
        for (Object member : community.getMembers()) {
            this.cMap.put((Integer)member, maxID);
        }
        return true;
    }

    public boolean addVertexToCommunity(V toAdd, int cId) {
        Community<V, E> c = this.communities.get(cId);
        if (c == null) {
            c = new Community<V, E>(cId, this.graph);
            this.communities.put(cId, c);
        }
        c.addMember(toAdd);
        this.cMap.put((Integer)toAdd, cId);
        return true;
    }

    public int getCommunityIndex(V vertex) {
        Integer cId = this.cMap.get(vertex);
        if (cId == null) {
            return -1;
        }
        return cId;
    }

    public int getNumberOfMembers() {
        return this.cMap.size();
    }

    public int getNumberOfCommunities() {
        return this.communities.size();
    }

    public Community<V, E> getCommunity(int cId) {
        return this.communities.get(cId);
    }

    public boolean addHub(V hubToAdd, int nrAdjacentCommunities) {
        if (this.availableHubs.containsKey(hubToAdd) || this.availableOutliers.contains(hubToAdd) || this.cMap.containsKey(hubToAdd)) {
            return false;
        }
        this.hubs.add(hubToAdd);
        this.availableHubs.put((Integer)hubToAdd, nrAdjacentCommunities);
        return true;
    }

    public List<V> getHubs() {
        return this.hubs;
    }

    public boolean isHub(V hubCandidate) {
        return this.availableHubs.containsKey(hubCandidate);
    }

    public int getHubAdjacentCommunities(V hubIdx) {
        if (this.availableHubs.containsKey(hubIdx)) {
            return this.availableHubs.get(hubIdx);
        }
        return 0;
    }

    public boolean addOutlier(V outlierToAdd) {
        if (this.availableHubs.containsKey(outlierToAdd) || this.availableOutliers.contains(outlierToAdd) || this.cMap.containsKey(outlierToAdd)) {
            return false;
        }
        this.outliers.add(outlierToAdd);
        this.availableOutliers.add(outlierToAdd);
        return true;
    }

    public boolean removeOutlier(V outlierToRemove) {
        if (!this.availableOutliers.contains(outlierToRemove)) {
            return false;
        }
        this.availableOutliers.remove(outlierToRemove);
        return this.outliers.remove(outlierToRemove);
    }

    public boolean isOutlier(V candidateOutlier) {
        return this.availableOutliers.contains(candidateOutlier);
    }

    public List<V> getOutliers() {
        return this.outliers;
    }

    public void printCommunitySummary() {
        System.out.println(String.valueOf(this.communities.size()) + " communities");
        System.out.println(String.valueOf(this.graph.getVertexCount() - this.hubs.size() - this.outliers.size()) + " members");
        System.out.println(String.valueOf(this.hubs.size()) + " hubs");
        System.out.println(String.valueOf(this.outliers.size()) + " outliers");
        int maxToShow = 10;
        Iterator<Community<V, E>> cIter = this.communities.values().iterator();
        int count = 0;
        while (cIter.hasNext()) {
            if (++count > maxToShow) break;
            Community<V, E> c = cIter.next();
            System.out.print(String.valueOf(c.getId()) + "(" + c.getNumberOfMembers() + " members): ");
            int Nmembers = Math.min(c.getNumberOfMembers(), 10);
            System.out.print("[");
            int i = 0;
            while (i < Nmembers) {
                V m = c.getMembers().get(i);
                int d = this.graph.degree(m);
                System.out.print("(" + m + ", " + d + ") ");
                ++i;
            }
            System.out.println("]");
        }
        int Nhubs = Math.min(this.hubs.size(), 10);
        System.out.print("[");
        int i = 0;
        while (i < Nhubs) {
            System.out.print("(" + this.hubs.get(i) + "," + this.availableHubs.get(this.hubs.get(i)) + "), ");
            ++i;
        }
        System.out.println("]");
        int Noutliers = Math.min(this.outliers.size(), 10);
        System.out.println(this.outliers.subList(0, Noutliers).toString());
    }

    public void printCommunities() {
        System.out.println(String.valueOf(this.communities.size()) + " communities");
        System.out.println(String.valueOf(this.graph.getVertexCount() - this.hubs.size() - this.outliers.size()) + " members");
        System.out.println(String.valueOf(this.hubs.size()) + " hubs");
        System.out.println(String.valueOf(this.outliers.size()) + " outliers");
        for (Community<V, E> c : this.communities.values()) {
            System.out.print(String.valueOf(c.getId()) + "(" + c.getNumberOfMembers() + " members): ");
            int Nmembers = c.getNumberOfMembers();
            System.out.print("[");
            int i = 0;
            while (i < Nmembers) {
                V m = c.getMembers().get(i);
                int d = this.graph.degree(m);
                System.out.print("(" + m + ", " + d + ") ");
                ++i;
            }
            System.out.println("]");
        }
        System.out.print("[");
        int i = 0;
        while (i < this.hubs.size()) {
            System.out.print("(" + this.hubs.get(i) + "," + this.availableHubs.get(this.hubs.get(i)) + "), ");
            ++i;
        }
        System.out.println("]");
        System.out.println(this.outliers.toString());
    }

    public void writeSizesToFile(String file) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
        int i = 0;
        while (i < this.getNumberOfCommunities()) {
            writer.append(String.valueOf(this.getCommunity(i).getNumberOfMembers()));
            writer.newLine();
            ++i;
        }
        writer.close();
    }

    public void writeStructureToFile(String file) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
        writer.append(String.valueOf(this.communities.size()));
        writer.newLine();
        for (Community<V, E> community : this.communities.values()) {
            writer.append(String.valueOf(community.getNumberOfMembers()));
            for (V member : community.getMembers()) {
                writer.append("\t" + member.toString());
            }
            writer.newLine();
        }
        writer.append(String.valueOf(this.hubs.size()));
        writer.newLine();
        for (Object hub : this.hubs) {
            writer.append(String.valueOf(hub.toString()) + "\t" + this.getHubAdjacentCommunities(hub));
            writer.newLine();
        }
        writer.append(String.valueOf(this.outliers.size()));
        writer.newLine();
        for (Object outlier : this.outliers) {
            writer.append(outlier.toString());
            writer.newLine();
        }
        writer.close();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(this.communities.size()) + " communities, ");
        buf.append(String.valueOf(this.hubs.size()) + " hubs, ");
        buf.append(String.valueOf(this.outliers.size()) + " outliers");
        return buf.toString();
    }

    public static void overlapBetweenCommunities(String communitiesFilename1, String communitiesFilename2, String outputFilename, String communitiesFilename) {
        try {
            String line1;
            BufferedWriter outputWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFilename), "UTF8"));
            BufferedReader com1Reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(communitiesFilename1), "UTF8"));
            ArrayList<Long> tempCommunityMembers1 = new ArrayList<Long>();
            ArrayList<Long> tempCommunityMembers2 = new ArrayList<Long>();
            HashSet<Integer> selectedCommunities = new HashSet<Integer>();
            ArrayList<RankableCommunity> maxOverlappedCommunities = new ArrayList<RankableCommunity>();
            int counter1 = 0;
            while ((line1 = com1Reader.readLine()) != null) {
                String line2;
                Object st2;
                ++counter1;
                tempCommunityMembers1.clear();
                line1 = line1.trim();
                StringTokenizer st1 = new StringTokenizer(line1, "\t");
                while (st1.hasMoreTokens()) {
                    String tempToken1 = st1.nextToken();
                    st2 = tempToken1.split(";");
                    String tempId = st2[0];
                    tempCommunityMembers1.add(Long.parseLong(tempId));
                }
                com1Reader.readLine();
                com1Reader.readLine();
                com1Reader.readLine();
                BufferedReader com2Reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(communitiesFilename2), "UTF8"));
                String tagsForMaxOverlappedCommunity = "";
                String maxOverlappedCommunityMembersLine = "";
                String geoCenterForMaxOverlappedCommunity = "";
                String timeInfoForMaxOverlappedCommunity = "";
                double maxOverlap = 0.0;
                int counter2 = 0;
                while ((line2 = com2Reader.readLine()) != null) {
                    if (selectedCommunities.contains(++counter2)) {
                        com2Reader.readLine();
                        com2Reader.readLine();
                        com2Reader.readLine();
                        continue;
                    }
                    tempCommunityMembers2.clear();
                    line2 = line2.trim();
                    st2 = new StringTokenizer(line2, "\t");
                    while (((StringTokenizer)st2).hasMoreTokens()) {
                        String tempToken2 = ((StringTokenizer)st2).nextToken();
                        String[] st3 = tempToken2.split(";");
                        String tempId = st3[0];
                        tempCommunityMembers2.add(Long.parseLong(tempId));
                    }
                    double overlap = ScanCommunityStructure.findOverlapBetweenTwoCommunities(tempCommunityMembers1, tempCommunityMembers2);
                    if (overlap > maxOverlap) {
                        maxOverlap = overlap;
                        maxOverlappedCommunityMembersLine = line2;
                        tagsForMaxOverlappedCommunity = com2Reader.readLine().trim();
                        geoCenterForMaxOverlappedCommunity = com2Reader.readLine().trim();
                        timeInfoForMaxOverlappedCommunity = com2Reader.readLine().trim();
                        selectedCommunities.add(counter2);
                        maxOverlappedCommunities.add(new RankableCommunity(counter1, maxOverlap));
                        continue;
                    }
                    com2Reader.readLine();
                    com2Reader.readLine();
                    com2Reader.readLine();
                }
                com2Reader.close();
                outputWriter.write(String.valueOf(maxOverlappedCommunityMembersLine) + "\n");
                outputWriter.write(String.valueOf(tagsForMaxOverlappedCommunity) + "\n");
                outputWriter.write(String.valueOf(geoCenterForMaxOverlappedCommunity) + "\n");
                outputWriter.write(String.valueOf(timeInfoForMaxOverlappedCommunity) + "\n");
            }
            outputWriter.close();
            com1Reader.close();
            Collections.sort(maxOverlappedCommunities, Collections.reverseOrder());
            BufferedWriter communitiesFile = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(communitiesFilename), "UTF8"));
            int i = 0;
            while (i < maxOverlappedCommunities.size()) {
                communitiesFile.write("Community " + ((RankableCommunity)maxOverlappedCommunities.get(i)).getId() + "  " + ((RankableCommunity)maxOverlappedCommunities.get(i)).getQuality() + "\n");
                ++i;
            }
            communitiesFile.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static double findOverlapBetweenTwoCommunities(List<Long> com1, List<Long> com2) {
        int numberOfSameMembers = 0;
        double minimunPercent = 0.2;
        int i = 0;
        while (i < com1.size()) {
            Long tempMember = com1.get(i);
            int j = 0;
            while (j < com2.size()) {
                Long candidateMember = com2.get(j);
                if (tempMember.equals(candidateMember)) {
                    ++numberOfSameMembers;
                }
                ++j;
            }
            ++i;
        }
        double overlapDegree = (double)numberOfSameMembers / (double)com2.size();
        if (numberOfSameMembers < 6) {
            return 0.0;
        }
        if (overlapDegree >= minimunPercent) {
            return overlapDegree;
        }
        return 0.0;
    }

    public static class RankableCommunity
    implements Comparable<RankableCommunity> {
        private int id;
        private double quality;

        public RankableCommunity(int id, double quality) {
            this.id = id;
            this.quality = quality;
        }

        public int getId() {
            return this.id;
        }

        public double getQuality() {
            return this.quality;
        }

        @Override
        public int compareTo(RankableCommunity arg0) {
            if (this.getQuality() < arg0.getQuality()) {
                return -1;
            }
            if (this.getQuality() > arg0.getQuality()) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof RankableCommunity && ((RankableCommunity)obj).getId() == this.getId();
        }

        public int hashCode() {
            return new Integer(this.id).hashCode();
        }
    }
}

