/*
 * Decompiled with CFR 0.152.
 */
package clust;

import clust.Community;
import clust.LWPCommunityDetector;
import clust.LocalModularity;
import clust.ScanCommunityStructure;
import clust.StructuralSimilarityScorer;
import edu.uci.ics.jung.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class ScanCommunityDetector<V, E> {
    private double epsilon = 0.5;
    private int mu = 5;
    private StructuralSimilarityScorer<V, E> ssScorer = null;
    private LWPCommunityDetector<V, E> lwp = null;
    private Graph<V, E> graph = null;
    private double maxEpsilon = 0.9;
    private double minEpsilon = 0.4;
    private double epsilonStep = 0.05;
    private int muScale = 10;
    private int minMu = 3;
    private int ccounter = 0;
    private Set<V> highDegreeNodes;

    public ScanCommunityDetector() {
    }

    public ScanCommunityDetector(double epsilon, int mu) {
        this.epsilon = epsilon;
        this.mu = mu;
    }

    public ScanCommunityDetector(StructuralSimilarityScorer<V, E> scorer) {
        this.ssScorer = scorer;
    }

    public ScanCommunityStructure<V, E> getRefinedCommunityStructure(Graph<V, E> graph) {
        return this.getRefinedCommunityStructure(graph, true);
    }

    public ScanCommunityStructure<V, E> getRefinedCommunityStructure(Graph<V, E> graph, boolean doExpansion) {
        this.graph = graph;
        ScanCommunityStructure<V, E> cs = new ScanCommunityStructure<V, E>(graph);
        if (this.ssScorer == null) {
            System.out.println("New structural-similarity-scorer!");
            this.ssScorer = new StructuralSimilarityScorer<V, E>(graph);
        }
        this.mu = graph.getVertexCount() / this.muScale;
        this.epsilon = this.maxEpsilon;
        int cIdx = -1;
        int minimumCoverage = (int)(0.9 * (double)graph.getVertexCount());
        HashSet nonMembers = null;
        while (cs.getNumberOfMembers() < minimumCoverage) {
            nonMembers = new HashSet();
            Iterator vIter = graph.getVertices().iterator();
            long iterT0 = System.currentTimeMillis();
            while (vIter.hasNext()) {
                Object seed = vIter.next();
                Integer seedCommunityIdx = cs.getCommunityIndex(seed);
                if (seedCommunityIdx >= 0 || nonMembers.contains(seed)) continue;
                if (this.isCore(graph, seed, cs)) {
                    ++cIdx;
                    Stack<V> Q = this.getEpsilonNeighborhood(graph, seed);
                    Q.push(seed);
                    while (!Q.isEmpty()) {
                        V cand = Q.pop();
                        if (this.isCore(graph, cand, cs)) {
                            Stack<V> R = this.getEpsilonNeighborhood(graph, cand);
                            while (!R.isEmpty()) {
                                V toAdd = R.pop();
                                Integer toAddCommunityIndex = cs.getCommunityIndex(toAdd);
                                if (toAddCommunityIndex >= 0) continue;
                                if (!nonMembers.contains(toAdd)) {
                                    Q.push(toAdd);
                                }
                                cs.addVertexToCommunity(toAdd, cIdx);
                            }
                            continue;
                        }
                        nonMembers.add(cand);
                    }
                    continue;
                }
                nonMembers.add(seed);
            }
            double iterationTime = (double)(System.currentTimeMillis() - iterT0) / 1000.0;
            System.out.println(String.valueOf(this.mu) + " " + this.epsilon + " " + cs.getNumberOfMembers() + " " + cs.getNumberOfCommunities() + ", " + iterationTime + " secs");
            this.mu = this.getNextMu(this.mu);
            if (this.mu == this.minMu && this.epsilon > this.minEpsilon) {
                this.epsilon -= this.epsilonStep;
                this.mu = graph.getVertexCount() / this.muScale;
            }
            if (this.mu == this.minMu && this.epsilon <= this.minEpsilon) break;
        }
        if (doExpansion) {
            this.lwp = new LWPCommunityDetector();
            ScanCommunityStructure<V, E> expandedCommunityStructure = new ScanCommunityStructure<V, E>(graph);
            int i = 0;
            while (i < cs.getNumberOfCommunities()) {
                Community<V, E> community = cs.getCommunity(i);
                Community<V, E> expandedCommunity = this.expandCommunitySeedSet(community);
                expandedCommunityStructure.addCommunity(expandedCommunity);
                ++i;
            }
            this.findHubsOutliers(graph, nonMembers, expandedCommunityStructure);
            return expandedCommunityStructure;
        }
        this.findHubsOutliers(graph, nonMembers, cs);
        return cs;
    }

    private int getNextMu(int mu) {
        int newMu = mu;
        newMu = mu > 100000 ? (newMu -= 1000) : (mu > 10000 ? (newMu -= 500) : (mu > 5000 ? (newMu -= 200) : (mu > 1000 ? (newMu -= 50) : (mu > 500 ? (newMu -= 20) : (mu > 250 ? (newMu -= 10) : (mu > 100 ? (newMu -= 5) : (mu > 50 ? (newMu -= 2) : --newMu)))))));
        return newMu;
    }

    public ScanCommunityStructure<V, E> getCommunityStructure(Graph<V, E> graph) {
        if (this.ssScorer == null) {
            System.out.println("New structural-similarity-scorer!");
            this.ssScorer = new StructuralSimilarityScorer<V, E>(graph);
        }
        ScanCommunityStructure<V, E> cs = new ScanCommunityStructure<V, E>(graph);
        int cIdx = -1;
        HashSet nonMembers = new HashSet();
        for (Object seed : graph.getVertices()) {
            Integer seedCommunityIdx = cs.getCommunityIndex(seed);
            if (seedCommunityIdx >= 0 || nonMembers.contains(seed)) continue;
            if (this.isCore(graph, seed, cs)) {
                ++cIdx;
                Stack<V> Q = this.getEpsilonNeighborhood(graph, seed);
                Q.push(seed);
                while (!Q.isEmpty()) {
                    V cand = Q.pop();
                    if (this.isCore(graph, cand, cs)) {
                        Stack<V> R = this.getEpsilonNeighborhood(graph, cand);
                        while (!R.isEmpty()) {
                            Integer toAddCommunityIndex;
                            V toAdd = R.pop();
                            if (toAdd.toString().equals("2992656283")) {
                                System.out.println("TSA2! : " + cand);
                            }
                            if ((toAddCommunityIndex = Integer.valueOf(cs.getCommunityIndex(toAdd))) >= 0) continue;
                            if (!nonMembers.contains(toAdd)) {
                                Q.push(toAdd);
                            }
                            cs.addVertexToCommunity(toAdd, cIdx);
                        }
                        continue;
                    }
                    nonMembers.add(cand);
                }
                continue;
            }
            nonMembers.add(seed);
        }
        this.findHubsOutliers(graph, nonMembers, cs);
        return cs;
    }

    private void findHubsOutliers(Graph<V, E> graph, Set<V> nonMembers, ScanCommunityStructure<V, E> cs) {
        for (V nonMember : nonMembers) {
            if (!graph.containsVertex(nonMember)) {
                throw new IllegalStateException("Reference graph does not contain community member: " + nonMember.toString());
            }
            Collection<V> neighbors = graph.getNeighbors(nonMember);
            if (neighbors == null) {
                cs.addOutlier(nonMember);
                continue;
            }
            Iterator<V> neighborIter = neighbors.iterator();
            HashSet<Integer> neighborCommunities = new HashSet<Integer>();
            while (neighborIter.hasNext()) {
                Integer neighbourIdx = cs.getCommunityIndex(neighborIter.next());
                if (neighbourIdx < 0) continue;
                neighborCommunities.add(neighbourIdx);
            }
            if (neighborCommunities.size() > 1) {
                cs.addHub(nonMember, neighborCommunities.size());
                continue;
            }
            cs.addOutlier(nonMember);
        }
    }

    private Stack<V> getEpsilonNeighborhood(Graph<V, E> g, V seed) {
        Stack<V> nQ = new Stack<V>();
        nQ.add(seed);
        Collection<V> neighbors = g.getNeighbors(seed);
        if (neighbors == null) {
            return nQ;
        }
        for (V n : neighbors) {
            Object e = g.findEdge(seed, n);
            double ss = (Double)this.ssScorer.getEdgeScore(e);
            if (!(ss > this.epsilon)) continue;
            nQ.push(n);
        }
        return nQ;
    }

    private boolean isCore(Graph<V, E> g, V seed, ScanCommunityStructure<V, E> cs) {
        Collection<V> neighbors = g.getNeighbors(seed);
        if (neighbors == null) {
            return false;
        }
        Iterator<V> nIter = neighbors.iterator();
        int count = 0;
        while (nIter.hasNext()) {
            Object e;
            double ss;
            V v = nIter.next();
            int cid = cs.getCommunityIndex(v);
            if (cid >= 0 || !((ss = ((Double)this.ssScorer.getEdgeScore(e = g.findEdge(seed, v))).doubleValue()) > this.epsilon) || ++count < this.mu) continue;
            return true;
        }
        return false;
    }

    public Community<V, E> expandCommunitySeedSet(Community<V, E> seed) {
        System.out.println("C: " + ++this.ccounter + " members " + seed.getNumberOfMembers() + " " + seed.getMembers());
        Community<V, E> expandedCommunity = new Community<V, E>(seed.getId(), seed.getReferenceGraph(), seed.getMembers());
        LocalModularity M = this.lwp.getLWPModularity(seed);
        Set<V> frontier = this.getFrontier(seed);
        ArrayList<V> addedMembers = new ArrayList<V>();
        while (!frontier.isEmpty()) {
            LocalModularity maxM = M;
            V maxV = null;
            for (V candV : frontier) {
                LocalModularity Mnew = this.lwp.getIncrementalLWPModularity(seed, candV, M);
                if (!(Mnew.getValue() > maxM.getValue())) continue;
                maxM = Mnew;
                maxV = candV;
            }
            if (!(maxM.getValue() > M.getValue())) break;
            seed.addMember(maxV);
            addedMembers.add(maxV);
            M = maxM;
            this.updateFrontier(seed, frontier, maxV);
        }
        List<V> finalMembers = seed.getMembers();
        int i = 0;
        while (i < finalMembers.size()) {
            if (!expandedCommunity.contains(finalMembers.get(i))) {
                expandedCommunity.addMember(finalMembers.get(i));
            }
            ++i;
        }
        System.out.println("\t added " + addedMembers.size() + ": " + addedMembers);
        return expandedCommunity;
    }

    private void updateFrontier(Community<V, E> seed, Set<V> frontier, V addedNode) {
        frontier.remove(addedNode);
        for (V frontierCandidate : this.graph.getNeighbors(addedNode)) {
            if (this.isHighDegree(frontierCandidate) || seed.contains(frontierCandidate)) continue;
            frontier.add(frontierCandidate);
        }
    }

    private Set<V> getFrontier(Community<V, E> seed) {
        HashSet<V> frontier = new HashSet<V>();
        for (V seedVertex : seed.getMembers()) {
            if (this.isHighDegree(seedVertex)) continue;
            for (V neighbor : this.graph.getNeighbors(seedVertex)) {
                if (seed.contains(neighbor)) continue;
                frontier.add(neighbor);
            }
        }
        return frontier;
    }

    private boolean isHighDegree(V node) {
        if (this.highDegreeNodes == null) {
            ArrayList<Integer> degrees = new ArrayList<Integer>();
            for (Object v : this.graph.getVertices()) {
                degrees.add(this.graph.degree(v));
            }
            Collections.sort(degrees, Collections.reverseOrder());
            double p = 0.1;
            int idx = (int)Math.round(p * (double)this.graph.getVertexCount());
            int degreeThreshold = (Integer)degrees.get(idx);
            this.highDegreeNodes = new HashSet<V>();
            for (Object v : this.graph.getVertices()) {
                if (this.graph.degree(v) < degreeThreshold) continue;
                this.highDegreeNodes.add(v);
            }
        }
        return this.highDegreeNodes.contains(node);
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public int getMu() {
        return this.mu;
    }

    public void setMu(int mu) {
        this.mu = mu;
    }
}

