/*
 * Decompiled with CFR 0.152.
 */
package clust;

import clust.Community;
import clust.LocalModularity;
import edu.uci.ics.jung.graph.Graph;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class LWPCommunityDetector<V, E> {
    public Community<V, E> getCommunity(Graph<V, E> graph, V seed) {
        int cId = 1;
        Community<Object, E> community = new Community<Object, E>(cId, graph);
        community.addMember(seed);
        HashSet<V> neighbourSet = new HashSet<V>(graph.getNeighbors(seed));
        HashSet Q = new HashSet();
        do {
            Q = new HashSet();
            LocalModularity lastModularity = this.getLWPModularity(community);
            Iterator nIter = neighbourSet.iterator();
            HashSet toRemove = new HashSet();
            while (nIter.hasNext()) {
                Object uj = nIter.next();
                if (toRemove.contains(uj)) continue;
                community.addMember(uj);
                LocalModularity newModularity = this.getLWPModularity(community);
                if (newModularity.getValue() > lastModularity.getValue()) {
                    lastModularity = newModularity;
                    Q.add(uj);
                    toRemove.add(uj);
                    continue;
                }
                community.removeMember(uj);
            }
            Iterator removeIter = toRemove.iterator();
            while (removeIter.hasNext()) {
                neighbourSet.remove(removeIter.next());
            }
            HashSet<V> deleteQ = new HashSet<V>();
            do {
                deleteQ = new HashSet();
                List<V> communityVertices = community.getMembers();
                int i = 0;
                while (i < communityVertices.size()) {
                    V currentVertex = communityVertices.get(i);
                    community.removeMember(currentVertex);
                    LocalModularity newModularity = this.getLWPModularity(community);
                    if (newModularity.getValue() > lastModularity.getValue() && community.isConnected()) {
                        lastModularity = newModularity;
                        deleteQ.add(currentVertex);
                        if (Q.contains(currentVertex)) {
                            Q.remove(currentVertex);
                        }
                    } else {
                        community.addMember(currentVertex);
                    }
                    ++i;
                }
            } while (!deleteQ.isEmpty());
            Iterator nIterK = Q.iterator();
            while (nIterK.hasNext()) {
                for (Object al : graph.getNeighbors(nIterK.next())) {
                    if (community.contains(al) || neighbourSet.contains(al)) continue;
                    neighbourSet.add(al);
                }
            }
        } while (!Q.isEmpty());
        if (this.getLWPModularity(community).getValue() > 0.0 && community.contains(seed)) {
            return community;
        }
        System.err.println("Empty community returned, because the output community does not contain the seed node!");
        return new Community<V, E>(cId, graph);
    }

    public LocalModularity getLWPModularity(Community<V, E> community) {
        if (!community.isValid()) {
            throw new IllegalArgumentException("You should provide a valid community as argument to the algorithm!");
        }
        Graph<V, E> graph = community.getReferenceGraph();
        List<V> communityMembers = community.getMembers();
        int M = community.getNumberOfMembers();
        int indS = 0;
        int outdS = 0;
        int i = 0;
        while (i < M) {
            V currentMember = communityMembers.get(i);
            int currentMemberInDegree = 0;
            int j = 0;
            while (j < M) {
                if (i != j && graph.findEdge(currentMember, communityMembers.get(j)) != null) {
                    ++currentMemberInDegree;
                }
                ++j;
            }
            outdS += graph.degree(currentMember) - currentMemberInDegree;
            indS += (int)Math.round((double)currentMemberInDegree / 2.0);
            ++i;
        }
        return new LocalModularity(indS, outdS);
    }

    public LocalModularity getIncrementalLWPModularity(Community<V, E> community, V candMember, LocalModularity mod) {
        int indS0 = mod.getInDegree();
        int outdS0 = mod.getOutDegree();
        Graph<V, E> graph = community.getReferenceGraph();
        List<V> communityMembers = community.getMembers();
        int M = community.getNumberOfMembers();
        int currentMemberInDegree = 0;
        int i = 0;
        while (i < M) {
            if (graph.findEdge(candMember, communityMembers.get(i)) != null) {
                ++currentMemberInDegree;
            }
            ++i;
        }
        return new LocalModularity(indS0 += currentMemberInDegree, outdS0 += graph.degree(candMember) - currentMemberInDegree);
    }
}

