/*
 * Decompiled with CFR 0.152.
 */
package clust;

import certh.Config;
import clust.Community;
import clust.ImageSimilarity;
import clust.ScanCommunityDetector;
import clust.ScanCommunityStructure;
import clust.TextSimilarityGraphCreator;
import clust.VisualSimilarityGraphCreator;
import dataset.create.FlickrMetadataParser;
import dataset.create.PhotoCopy;
import edu.uci.ics.jung.graph.UndirectedSparseMultigraph;
import edu.uci.ics.jung.graph.util.Pair;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import model.FlickrImageMetadata;
import org.xml.sax.SAXException;
import vis.FeatureVectorStructure;
import vis.VisualFeatureParser;

public class FlickrClustering {
    protected static String MEDIAEVAL_ROOT = "D:\\mediaeval\\";
    protected static String METADATA_FILE = String.valueOf(MEDIAEVAL_ROOT) + "flickrMetadata_v5.xml";
    protected List<List<Long>> clusters = new ArrayList<List<Long>>();
    protected Map<Long, Integer> flickrIdToClusterMap = new HashMap<Long, Integer>();
    protected List<List<Long>> clustersFullCopy = new ArrayList<List<Long>>();

    public static void main(String[] args) {
        FlickrMetadataParser metadataParser = new FlickrMetadataParser();
        Map<Long, FlickrImageMetadata> metadataMap = null;
        try {
            metadataMap = metadataParser.getFlickrMetadataMap(METADATA_FILE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        String visualFeaturesFile = String.valueOf(Config.MEVAL_RESOURCE_DIR) + "sift\\all_FlickrSIFT.bow";
        VisualFeatureParser parser = new VisualFeatureParser();
        FeatureVectorStructure features = parser.readFeatureVectors(visualFeaturesFile);
        UndirectedSparseMultigraph<Long, ImageSimilarity> graph = VisualSimilarityGraphCreator.createVisualSimilaritiyGraph(features);
        System.out.println(String.valueOf(graph.getVertexCount()) + " " + graph.getEdgeCount());
        FlickrClustering clustering = new FlickrClustering();
        System.out.println("Attempting to cluster data...");
        clustering.performVisualClustering(metadataMap, features);
        List<List<Long>> clusters = clustering.getClusters();
        System.out.println(String.valueOf(clusters.size()) + " clusters");
        int i = 0;
        while (i < clusters.size()) {
            String clusterDir = String.valueOf(Config.MEVAL_EVAL_DIR) + "vis\\" + i + "\\";
            File clusterDirectory = new File(clusterDir);
            clusterDirectory.mkdir();
            ArrayList<String> flickrIds = new ArrayList<String>(clusters.get(i).size());
            for (Long flickrId : clusters.get(i)) {
                flickrIds.add(String.valueOf(flickrId));
            }
            PhotoCopy.copyFlickrImagesToFlatFolder(flickrIds, Config.MEVAL_PHOTO_ROOT, clusterDir, ".jpg");
            ++i;
        }
    }

    public void performHybridClustering(Map<Long, FlickrImageMetadata> metadata, FeatureVectorStructure features) {
        UndirectedSparseMultigraph<Long, ImageSimilarity> visualSimilarityGraph = VisualSimilarityGraphCreator.createVisualSimilaritiyGraph(features);
        UndirectedSparseMultigraph<Long, ImageSimilarity> tagSimilarityGraph = TextSimilarityGraphCreator.createTagSimilaritiyGraph(metadata);
        System.out.println("VISUAL GRAPH (" + visualSimilarityGraph.getVertexCount() + ", " + visualSimilarityGraph.getEdgeCount() + ")");
        System.out.println("TAG GRAPH (" + tagSimilarityGraph.getVertexCount() + ", " + tagSimilarityGraph.getEdgeCount() + ")");
        for (Long flickrId : visualSimilarityGraph.getVertices()) {
            if (tagSimilarityGraph.containsVertex(flickrId)) continue;
            tagSimilarityGraph.addVertex(flickrId);
        }
        for (ImageSimilarity similarity : visualSimilarityGraph.getEdges()) {
            Pair<Long> endVertices = visualSimilarityGraph.getEndpoints(similarity);
            ImageSimilarity existingSimilarity = tagSimilarityGraph.findEdge(endVertices.getFirst(), endVertices.getSecond());
            if (existingSimilarity != null) continue;
            tagSimilarityGraph.addEdge(similarity, endVertices.getFirst(), endVertices.getSecond());
        }
        System.out.println("TAG GRAPH (" + tagSimilarityGraph.getVertexCount() + ", " + tagSimilarityGraph.getEdgeCount() + ")");
        int mu = 4;
        double epsilon = 0.6;
        ScanCommunityDetector<Long, ImageSimilarity> communityDetector = new ScanCommunityDetector<Long, ImageSimilarity>(epsilon, mu);
        ScanCommunityStructure<Long, ImageSimilarity> communityStructure = communityDetector.getCommunityStructure(tagSimilarityGraph);
        this.populateClusters(communityStructure);
    }

    public void performVisualClustering(Map<Long, FlickrImageMetadata> metadata, FeatureVectorStructure features) {
        int mu = 4;
        double epsilon = 0.6;
        UndirectedSparseMultigraph<Long, ImageSimilarity> visualSimilarityGraph = VisualSimilarityGraphCreator.createVisualSimilaritiyGraph(features);
        ScanCommunityDetector<Long, ImageSimilarity> communityDetector = new ScanCommunityDetector<Long, ImageSimilarity>(epsilon, mu);
        ScanCommunityStructure<Long, ImageSimilarity> communityStructure = communityDetector.getCommunityStructure(visualSimilarityGraph);
        this.populateClusters(communityStructure);
    }

    public void performTagBasedClustering(Map<Long, FlickrImageMetadata> metadata) {
        int mu = 4;
        double epsilon = 0.6;
        UndirectedSparseMultigraph<Long, ImageSimilarity> tagSimilarityGraph = TextSimilarityGraphCreator.createTagSimilaritiyGraph(metadata);
        ScanCommunityDetector<Long, ImageSimilarity> communityDetector = new ScanCommunityDetector<Long, ImageSimilarity>(epsilon, mu);
        ScanCommunityStructure<Long, ImageSimilarity> communityStructure = communityDetector.getCommunityStructure(tagSimilarityGraph);
        this.populateClusters(communityStructure);
    }

    protected void populateClusters(ScanCommunityStructure<Long, ImageSimilarity> communityStructure) {
        this.clusters.clear();
        int i = 0;
        while (i < communityStructure.getNumberOfCommunities()) {
            Community<Long, ImageSimilarity> community = communityStructure.getCommunity(i);
            this.clusters.add(community.getMembers());
            for (Long flickrId : community.getMembers()) {
                this.flickrIdToClusterMap.put(flickrId, i);
            }
            ++i;
        }
        System.out.println("#clusters: " + this.clusters.size());
    }

    public List<Long> getSameClusterPhotos(Long flickrId) {
        ArrayList<Long> sameClusterPhotos = new ArrayList<Long>();
        Integer clusterIdx = this.flickrIdToClusterMap.get(flickrId);
        if (clusterIdx != null) {
            if (clusterIdx < 0 || clusterIdx >= this.clusters.size()) {
                throw new IllegalStateException("Index to cluster that does not exist: " + clusterIdx);
            }
            sameClusterPhotos.addAll((Collection<Long>)this.clusters.get(clusterIdx));
        }
        return sameClusterPhotos;
    }

    public List<List<Long>> getClusters() {
        int i;
        boolean needsCopy = false;
        if (this.clustersFullCopy.size() == this.clusters.size()) {
            i = 0;
            while (i < this.clustersFullCopy.size()) {
                if (this.clustersFullCopy.get(i).size() != this.clusters.get(i).size()) {
                    needsCopy = true;
                }
                ++i;
            }
        } else {
            needsCopy = true;
        }
        if (needsCopy) {
            this.clustersFullCopy = new ArrayList<List<Long>>(this.clusters.size());
            i = 0;
            while (i < this.clusters.size()) {
                ArrayList cluster = new ArrayList(this.clusters.get(i).size());
                cluster.addAll(this.clusters.get(i));
                this.clustersFullCopy.add(cluster);
                ++i;
            }
        }
        return this.clustersFullCopy;
    }
}

