/*
 * Decompiled with CFR 0.152.
 */
package clust;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class Community<V, E> {
    private int id = -1;
    private String name = null;
    private Set<V> members = new HashSet<V>();
    private final Graph<V, E> referenceGraph;

    public Community(int id, Graph<V, E> graph) {
        if (id < 0) {
            throw new IllegalArgumentException("Community id should be a non-negative integer!");
        }
        this.id = id;
        this.referenceGraph = graph;
    }

    public Community(int id, Graph<V, E> net, List<V> members) {
        if (id < 0) {
            throw new IllegalArgumentException("Community id should be a non-negative integer!");
        }
        this.id = id;
        this.referenceGraph = net;
        int i = 0;
        while (i < members.size()) {
            this.addMember(members.get(i));
            ++i;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public void addMember(V t) {
        if (this.referenceGraph == null) {
            throw new IllegalStateException("The community object has not been properly initialized!");
        }
        if (!this.referenceGraph.containsVertex(t)) {
            throw new IllegalStateException("You attempt to add to the community a member, which does not exist in the graph!");
        }
        this.members.add(t);
    }

    public void removeMember(V t) {
        this.members.remove(t);
    }

    public int getNumberOfMembers() {
        return this.members.size();
    }

    public List<V> getMembers() {
        ArrayList<V> comElements = new ArrayList<V>(this.members);
        return comElements;
    }

    public void setMembers(List<V> comElements) {
        int i = 0;
        while (i < comElements.size()) {
            this.addMember(comElements.get(i));
            ++i;
        }
    }

    public boolean contains(V t) {
        return this.members.contains(t);
    }

    public boolean isConnected() {
        if (this.members.size() < 1) {
            return false;
        }
        HashSet reachableNodes = new HashSet();
        HashSet visited = new HashSet();
        V seed = this.members.iterator().next();
        if (!this.referenceGraph.containsVertex(seed)) {
            throw new IllegalStateException("Reference graph does not contain community member: " + seed.toString());
        }
        Stack<Object> frontier = new Stack<Object>();
        frontier.push(seed);
        while (!frontier.isEmpty()) {
            Object cand = frontier.pop();
            visited.add(cand);
            reachableNodes.add(cand);
            for (Object ni : this.referenceGraph.getNeighbors(cand)) {
                if (visited.contains(ni) || !this.members.contains(ni)) continue;
                if (!reachableNodes.contains(ni)) {
                    reachableNodes.add(ni);
                }
                frontier.add(ni);
            }
        }
        return reachableNodes.size() >= this.members.size();
    }

    public boolean isValid() {
        for (V v : this.members) {
            if (this.referenceGraph.containsVertex(v)) continue;
            return false;
        }
        return true;
    }

    public Graph<V, E> getReferenceGraph() {
        return this.referenceGraph;
    }

    public Graph<V, E> getCommunityCopy() {
        UndirectedSparseGraph com = new UndirectedSparseGraph();
        for (V m : this.members) {
            if (!this.referenceGraph.containsVertex(m)) {
                throw new IllegalStateException("Reference graph does not contain community member: " + m.toString());
            }
            com.addVertex(m);
        }
        for (V thisVertex : this.members) {
            if (!this.referenceGraph.containsVertex(thisVertex)) {
                throw new IllegalStateException("Reference graph does not contain community member: " + thisVertex.toString());
            }
            Collection<V> neighbors = this.referenceGraph.getNeighbors(thisVertex);
            if (neighbors == null) continue;
            for (V currentNeighbor : neighbors) {
                Object e;
                if (!this.members.contains(currentNeighbor) || (e = com.findEdge(thisVertex, currentNeighbor)) != null) continue;
                e = this.referenceGraph.findEdge(thisVertex, currentNeighbor);
                ArrayList<V> edgePoints = new ArrayList<V>(2);
                edgePoints.add(thisVertex);
                edgePoints.add(currentNeighbor);
                com.addEdge(e, edgePoints);
            }
        }
        return com;
    }
}

