/*
 * Decompiled with CFR 0.152.
 */
package certh;

import certh.Challenge1Run1;
import certh.Challenge1Run2;
import certh.Challenge1Run3;
import certh.Challenge1Run4;
import certh.Challenge2Run1;
import certh.Challenge2Run2;
import certh.Challenge2Run3;
import certh.Challenge2Run4;
import certh.Config;
import certh.SubmissionCreator;
import eval.Evaluator;
import eval.PerformanceMetric;

public class SubmissionTester {
    protected static String MEDIAEVAL_EVAL_TEST_ROOT = String.valueOf(Config.MEVAL_EVAL_DIR) + "test\\";
    protected static String MEDIAEVAL_VISUAL_FEATURES_FILE = String.valueOf(Config.MEVAL_RESOURCE_DIR) + "sift\\all_FlickrSIFT.bow";

    public static void main(String[] args) {
        SubmissionTester.evaluateChallenge1Run1();
        SubmissionTester.evaluateChallenge1Run2();
        SubmissionTester.evaluateChallenge1Run3();
        SubmissionTester.evaluateChallenge1Run4();
        SubmissionTester.evaluateChallenge2Run1();
        SubmissionTester.evaluateChallenge2Run2();
        SubmissionTester.evaluateChallenge2Run3();
        SubmissionTester.evaluateChallenge2Run4();
    }

    public static void evaluateChallenge1Run1() {
        SubmissionTester.printPreamble(1, 1);
        Challenge1Run1 runner = new Challenge1Run1();
        SubmissionTester.evaluate(runner, 1, 1);
        System.out.println();
    }

    public static void evaluateChallenge1Run2() {
        SubmissionTester.printPreamble(1, 2);
        Challenge1Run2 runner = new Challenge1Run2();
        SubmissionTester.evaluate(runner, 1, 2);
        System.out.println();
    }

    public static void evaluateChallenge1Run3() {
        SubmissionTester.printPreamble(1, 3);
        Challenge1Run3 runner = new Challenge1Run3();
        runner.setSiftFlickrFile(MEDIAEVAL_VISUAL_FEATURES_FILE);
        SubmissionTester.evaluate(runner, 1, 3);
        System.out.println();
    }

    public static void evaluateChallenge1Run4() {
        SubmissionTester.printPreamble(1, 4);
        Challenge1Run4 runner = new Challenge1Run4();
        runner.setSiftFlickrFile(MEDIAEVAL_VISUAL_FEATURES_FILE);
        SubmissionTester.evaluate(runner, 1, 4);
        System.out.println();
    }

    public static void evaluateChallenge2Run1() {
        SubmissionTester.printPreamble(2, 1);
        Challenge2Run1 runner = new Challenge2Run1();
        SubmissionTester.evaluate(runner, 2, 1);
        System.out.println();
    }

    public static void evaluateChallenge2Run2() {
        SubmissionTester.printPreamble(2, 2);
        Challenge2Run2 runner = new Challenge2Run2();
        SubmissionTester.evaluate(runner, 2, 2);
        System.out.println();
    }

    public static void evaluateChallenge2Run3() {
        SubmissionTester.printPreamble(2, 3);
        Challenge2Run3 runner = new Challenge2Run3();
        runner.setSiftFlickrFile(MEDIAEVAL_VISUAL_FEATURES_FILE);
        SubmissionTester.evaluate(runner, 2, 3);
        System.out.println();
    }

    public static void evaluateChallenge2Run4() {
        SubmissionTester.printPreamble(2, 4);
        Challenge2Run4 runner = new Challenge2Run4();
        runner.setSiftFlickrFile(MEDIAEVAL_VISUAL_FEATURES_FILE);
        SubmissionTester.evaluate(runner, 2, 4);
        System.out.println();
    }

    protected static void evaluate(SubmissionCreator runner, int challengeNr, int runNr) {
        String resultFile = SubmissionTester.generateResultFilename(challengeNr, runNr);
        runner.run(Config.MEVAL_DISTRIBUTED_XML_METADATA_FILE, resultFile);
        PerformanceMetric.EvaluationMeasures result = null;
        result = challengeNr == 1 ? Evaluator.evaluate(Config.CHALLENGE1_GROUNDTRUTH_FILE, resultFile) : Evaluator.evaluate(Config.CHALLENGE2_GROUNDTRUTH_FILE, resultFile);
        System.out.println("NMI:\t" + result.getNMI());
        System.out.println("P:\t" + result.getIrMetric().precision);
        System.out.println("R:\t" + result.getIrMetric().recall);
        System.out.println("F-m:\t" + result.getIrMetric().getFMeasure());
    }

    protected static String generateResultFilename(int challengeNr, int runNr) {
        if (challengeNr == 1) {
            return String.valueOf(MEDIAEVAL_EVAL_TEST_ROOT) + Config.CHALLENGE1_FILE_PREFIX + runNr + ".csv";
        }
        return String.valueOf(MEDIAEVAL_EVAL_TEST_ROOT) + Config.CHALLENGE2_FILE_PREFIX + runNr + ".csv";
    }

    protected static void printPreamble(int challengeNr, int runNr) {
        System.out.println("MEDIAEVAL: Challenge " + challengeNr + " / Run " + runNr);
        System.out.println("******************************");
    }
}

