/*
 * Decompiled with CFR 0.152.
 */
package certh;

import certh.CommonFunctions;
import certh.SubmissionCreator;
import dataset.create.GroundTruthFileCreator;
import java.util.List;
import java.util.Map;
import model.FlickrEvent;
import model.FlickrImageMetadata;

public abstract class SubmissionCreatorChallenge2
implements SubmissionCreator {
    @Override
    public void run(String xmlMetadataFile, String resultFile) {
        Map<Long, FlickrImageMetadata> metadataMap = CommonFunctions.readMetadataMap(xmlMetadataFile);
        if (metadataMap == null) {
            return;
        }
        List<Long> candidateVenuePhotos = this.selectCandidateVenuePhotos(metadataMap);
        System.out.println("...found " + candidateVenuePhotos.size() + " photos related to the venues of interest!");
        List<FlickrEvent> events = this.discoverVenueEvents(candidateVenuePhotos, metadataMap);
        System.out.println("...found " + events.size() + " events in the venue photo set!");
        List<List<Long>> results = this.expandVenueEvents(metadataMap, events);
        int countOutputPhotos = 0;
        for (List<Long> photoList : results) {
            countOutputPhotos += photoList.size();
        }
        System.out.println("...events now contain a total of " + countOutputPhotos + " photos");
        GroundTruthFileCreator.createResultFile(results, resultFile);
    }

    protected abstract List<Long> selectCandidateVenuePhotos(Map<Long, FlickrImageMetadata> var1);

    protected abstract List<FlickrEvent> discoverVenueEvents(List<Long> var1, Map<Long, FlickrImageMetadata> var2);

    protected abstract List<List<Long>> expandVenueEvents(Map<Long, FlickrImageMetadata> var1, List<FlickrEvent> var2);
}

