/*
 * Decompiled with CFR 0.152.
 */
package certh;

import certh.CommonFunctions;
import certh.SubmissionCreator;
import dataset.create.GroundTruthFileCreator;
import java.util.List;
import java.util.Map;
import model.FlickrEvent;
import model.FlickrImageMetadata;

public abstract class SubmissionCreatorChallenge1
implements SubmissionCreator {
    @Override
    public void run(String xmlMetadataFile, String resultFile) {
        Map<Long, FlickrImageMetadata> metadataMap = CommonFunctions.readMetadataMap(xmlMetadataFile);
        if (metadataMap == null) {
            return;
        }
        List<Long> candidateSoccerPhotos = this.selectCandidateSoccerPhotos(metadataMap);
        System.out.println("...found " + candidateSoccerPhotos.size() + " photos related to soccer!");
        List<FlickrEvent> events = this.discoverSoccerEvents(candidateSoccerPhotos, metadataMap);
        System.out.println("...found " + events.size() + " events in the soccer photo set!");
        List<List<Long>> results = this.expandSoccerEvents(metadataMap, events);
        int countOutputPhotos = 0;
        for (List<Long> photoList : results) {
            countOutputPhotos += photoList.size();
        }
        System.out.println("...events now contain a total of " + countOutputPhotos + " photos");
        GroundTruthFileCreator.createResultFile(results, resultFile);
    }

    protected abstract List<Long> selectCandidateSoccerPhotos(Map<Long, FlickrImageMetadata> var1);

    protected abstract List<FlickrEvent> discoverSoccerEvents(List<Long> var1, Map<Long, FlickrImageMetadata> var2);

    protected abstract List<List<Long>> expandSoccerEvents(Map<Long, FlickrImageMetadata> var1, List<FlickrEvent> var2);
}

