/*
 * Decompiled with CFR 0.152.
 */
package certh;

import dataset.create.FlickrMetadataParser;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import model.FlickrDateTimeString;
import model.FlickrImageMetadata;
import org.xml.sax.SAXException;
import tag.FlickrPhotoTagExtractor;

public class CommonFunctions {
    private static final int MIN_SOCCER_TAG_MODEL_SIZE = 5;
    private static final int MIN_RELEVANCE_SCORE_TAGS_TITLE = 2;
    private static final int MIN_RELEVANCE_SCORE_TAGS_TITLE_DESCRIPTION = 3;

    public static Map<Long, FlickrImageMetadata> readMetadataMap(String xmlMetadataFile) {
        FlickrMetadataParser parser = new FlickrMetadataParser();
        Map<Long, FlickrImageMetadata> metadataMap = null;
        try {
            metadataMap = parser.getFlickrMetadataMap(xmlMetadataFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return metadataMap;
    }

    public static boolean isRelatedToSoccerEvent(FlickrImageMetadata metadata, Set<String> soccerTagModel, boolean useDescription) {
        List<String> tags = FlickrPhotoTagExtractor.getTagsTitle(metadata);
        int relevanceThreshold = 2;
        if (useDescription) {
            tags = FlickrPhotoTagExtractor.getTagsTitleDescription(metadata);
            relevanceThreshold = 3;
        }
        if (soccerTagModel.size() < 5) {
            relevanceThreshold = 0;
        }
        int relevanceCount = 0;
        for (String tag : tags) {
            if (!soccerTagModel.contains(tag)) continue;
            ++relevanceCount;
        }
        if (relevanceCount > relevanceThreshold) {
            return true;
        }
        relevanceCount = 0;
        String normalizedTitle = FlickrPhotoTagExtractor.normalizeText(metadata.getTitle());
        for (String tag : soccerTagModel) {
            if (!normalizedTitle.contains(tag)) continue;
            ++relevanceCount;
        }
        return relevanceCount > relevanceThreshold;
    }

    public static boolean verifyFlickrPhotoDate(long flickrId, FlickrDateTimeString timeTaken) {
        return timeTaken.getYear() == 2009 && timeTaken.getMonth() == 5;
    }
}

