/*
 * Decompiled with CFR 0.152.
 */
package certh;

import certh.CommonFunctions;
import certh.SubmissionCreatorChallenge2;
import dataset.create.PhotoCopy;
import geo.CityClassifier;
import geo.GeodesicDistanceCalculator;
import geo.VenueClassifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import model.FlickrDateTimeString;
import model.FlickrEvent;
import model.FlickrImageMetadata;

public class Challenge2Run1
extends SubmissionCreatorChallenge2 {
    protected CityClassifier cityClassifier = new CityClassifier();
    protected VenueClassifier venueClassifier = new VenueClassifier(this.cityClassifier);
    protected final boolean useTimeFilter = false;

    @Override
    protected List<Long> selectCandidateVenuePhotos(Map<Long, FlickrImageMetadata> imageMetadataMap) {
        ArrayList<Long> candidateVenuePhotos = new ArrayList<Long>();
        for (Map.Entry<Long, FlickrImageMetadata> flickrEntry : imageMetadataMap.entrySet()) {
            if (Challenge2Run1.belongsToDifferentCity(flickrEntry.getValue(), this.cityClassifier) || this.venueClassifier.detectVenue(flickrEntry.getValue()) == null) continue;
            candidateVenuePhotos.add(flickrEntry.getKey());
        }
        return candidateVenuePhotos;
    }

    protected static boolean belongsToDifferentCity(FlickrImageMetadata metadata, CityClassifier cityClassifier) {
        PhotoCopy.MediaevalCity city = cityClassifier.detectCity(metadata);
        return PhotoCopy.MediaevalCity.Rome.equals((Object)city) || PhotoCopy.MediaevalCity.London.equals((Object)city) || PhotoCopy.MediaevalCity.Paris.equals((Object)city);
    }

    @Override
    protected List<FlickrEvent> discoverVenueEvents(List<Long> candidateEventPhotos, Map<Long, FlickrImageMetadata> imageMetadataMap) {
        ArrayList<FlickrEvent> events = new ArrayList<FlickrEvent>();
        HashSet<Integer> differentEventDays = new HashSet<Integer>();
        for (long flickrId : candidateEventPhotos) {
            FlickrDateTimeString timeTaken;
            FlickrImageMetadata metadata = imageMetadataMap.get(flickrId);
            if (metadata == null || !CommonFunctions.verifyFlickrPhotoDate(flickrId, timeTaken = metadata.getTimeString())) continue;
            differentEventDays.add(timeTaken.getDay());
        }
        Iterator iterator = differentEventDays.iterator();
        while (iterator.hasNext()) {
            FlickrEvent event;
            int day = (Integer)iterator.next();
            ArrayList<Long> sameDayPhotos = new ArrayList<Long>();
            for (long flickrId : candidateEventPhotos) {
                FlickrDateTimeString timeTaken;
                FlickrImageMetadata metadata = imageMetadataMap.get(flickrId);
                if (metadata == null || (timeTaken = metadata.getTimeString()).getDay() != day) continue;
                sameDayPhotos.add(flickrId);
            }
            ArrayList<Long> barcelonaEvent = new ArrayList<Long>();
            ArrayList<Long> amsterdamEvent = new ArrayList<Long>();
            Iterator iterator2 = sameDayPhotos.iterator();
            while (iterator2.hasNext()) {
                long flickrId = (Long)iterator2.next();
                FlickrImageMetadata metadata = imageMetadataMap.get(flickrId);
                if (metadata == null) continue;
                PhotoCopy.MediaevalCity city = this.cityClassifier.detectCity(metadata);
                if (PhotoCopy.MediaevalCity.Barcelona.equals((Object)city)) {
                    barcelonaEvent.add(flickrId);
                }
                if (!PhotoCopy.MediaevalCity.Amsterdam.equals((Object)city)) continue;
                amsterdamEvent.add(flickrId);
            }
            if (barcelonaEvent.size() > 0) {
                event = new FlickrEvent();
                event.addPhotos(barcelonaEvent);
                events.add(event);
            }
            if (amsterdamEvent.size() <= 0) continue;
            event = new FlickrEvent();
            event.addPhotos(amsterdamEvent);
            events.add(event);
        }
        return events;
    }

    protected List<FlickrEvent> discoverVenueEvents2(List<Long> candidateEventPhotos, Map<Long, FlickrImageMetadata> imageMetadataMap) {
        ArrayList<FlickrEvent> events = new ArrayList<FlickrEvent>();
        HashMap<String, HashSet<Long>> users = new HashMap<String, HashSet<Long>>();
        for (long flickrId : candidateEventPhotos) {
            FlickrImageMetadata metadata = imageMetadataMap.get(flickrId);
            HashSet<Long> photos = (HashSet<Long>)users.get(metadata.getUsername());
            if (photos == null) {
                photos = new HashSet<Long>();
                users.put(metadata.getUsername(), photos);
            }
            photos.add(flickrId);
        }
        ArrayList fragmentedEvents = new ArrayList();
        for (String user : users.keySet()) {
            Set photos = (Set)users.get(user);
            ArrayList<TimeRankedPhoto> timeRankedPhotos = new ArrayList<TimeRankedPhoto>(photos.size());
            for (Long photoId : photos) {
                FlickrImageMetadata metadata = imageMetadataMap.get(photoId);
                timeRankedPhotos.add(new TimeRankedPhoto(photoId, metadata.getTimeString()));
            }
            if (timeRankedPhotos.size() > 1) {
                Collections.sort(timeRankedPhotos);
                ArrayList splits = new ArrayList();
                splits.add(0);
                int i = 1;
                while (i < timeRankedPhotos.size()) {
                    int dayDiff = ((TimeRankedPhoto)timeRankedPhotos.get(i)).getDate().getDay() - ((TimeRankedPhoto)timeRankedPhotos.get(i - 1)).getDate().getDay();
                    if (dayDiff > 1) {
                        splits.add(i);
                    } else {
                        int hourDiff = 24 * dayDiff + ((TimeRankedPhoto)timeRankedPhotos.get(i)).getDate().getHours() - ((TimeRankedPhoto)timeRankedPhotos.get(i - 1)).getDate().getHours();
                        if (hourDiff > 12) {
                            splits.add(i);
                        }
                    }
                    ++i;
                }
                splits.add(timeRankedPhotos.size());
                i = 1;
                while (i < splits.size()) {
                    fragmentedEvents.add(timeRankedPhotos.subList((Integer)splits.get(i - 1), (Integer)splits.get(i)));
                    ++i;
                }
                continue;
            }
            fragmentedEvents.add(new ArrayList(timeRankedPhotos));
        }
        boolean[] added = new boolean[fragmentedEvents.size()];
        Arrays.fill(added, false);
        int i = 0;
        while (i < fragmentedEvents.size()) {
            if (!added[i]) {
                ArrayList<Long> samePeriodPhotos = new ArrayList<Long>();
                for (TimeRankedPhoto photo : (List)fragmentedEvents.get(i)) {
                    samePeriodPhotos.add(photo.getFlickrId());
                }
                added[i] = true;
                if (i < fragmentedEvents.size() - 1) {
                    FlickrDateTimeString start = ((TimeRankedPhoto)((List)fragmentedEvents.get(i)).get(0)).getDate();
                    FlickrDateTimeString end = ((TimeRankedPhoto)((List)fragmentedEvents.get(i)).get(((List)fragmentedEvents.get(i)).size() - 1)).getDate();
                    int j = i + 1;
                    while (j < fragmentedEvents.size()) {
                        if (!added[j]) {
                            FlickrDateTimeString otherStart = ((TimeRankedPhoto)((List)fragmentedEvents.get(j)).get(0)).getDate();
                            FlickrDateTimeString otherEnd = ((TimeRankedPhoto)((List)fragmentedEvents.get(j)).get(((List)fragmentedEvents.get(j)).size() - 1)).getDate();
                            if (start.isBefore(otherStart) && otherStart.isBefore(end) || start.isBefore(otherEnd) && otherEnd.isBefore(end) || start.getDay() == otherStart.getDay() || end.getDay() == otherEnd.getDay()) {
                                for (TimeRankedPhoto photo : (List)fragmentedEvents.get(j)) {
                                    samePeriodPhotos.add(photo.getFlickrId());
                                }
                                added[j] = true;
                            }
                        }
                        ++j;
                    }
                }
                ArrayList<Long> barcelonaEvent = new ArrayList<Long>();
                ArrayList<Long> amsterdamEvent = new ArrayList<Long>();
                Iterator iterator = samePeriodPhotos.iterator();
                while (iterator.hasNext()) {
                    long flickrId = (Long)iterator.next();
                    FlickrImageMetadata metadata = imageMetadataMap.get(flickrId);
                    if (metadata == null) continue;
                    PhotoCopy.MediaevalCity city = this.cityClassifier.detectCity(metadata);
                    if (PhotoCopy.MediaevalCity.Barcelona.equals((Object)city)) {
                        barcelonaEvent.add(flickrId);
                    }
                    if (!PhotoCopy.MediaevalCity.Amsterdam.equals((Object)city)) continue;
                    amsterdamEvent.add(flickrId);
                }
                if (barcelonaEvent.size() > 0) {
                    FlickrEvent event = new FlickrEvent();
                    event.addPhotos(barcelonaEvent);
                    events.add(event);
                }
                if (amsterdamEvent.size() > 0) {
                    FlickrEvent event = new FlickrEvent();
                    event.addPhotos(amsterdamEvent);
                    events.add(event);
                }
            }
            ++i;
        }
        return events;
    }

    @Override
    protected List<List<Long>> expandVenueEvents(Map<Long, FlickrImageMetadata> imageMetadataMap, List<FlickrEvent> events) {
        ArrayList<List<Long>> results = new ArrayList<List<Long>>(events.size());
        for (FlickrEvent event : events) {
            List<Long> photos = this.enrichCandidateVenuePhotosForEvent(imageMetadataMap, event);
            results.add(photos);
        }
        return results;
    }

    protected List<Long> enrichCandidateVenuePhotosForEvent(Map<Long, FlickrImageMetadata> metadataMap, FlickrEvent event) {
        int dayOfEvent;
        ArrayList<Long> candidateEventPhotos = new ArrayList<Long>(event.getPhotos());
        event.computeLocation(metadataMap);
        event.computeStartEnd(metadataMap);
        HashSet<String> usernames = new HashSet<String>();
        for (long flickrId : event.getPhotos()) {
            FlickrImageMetadata metadata = metadataMap.get(flickrId);
            if (metadata == null) continue;
            usernames.add(metadata.getUsername());
        }
        int day1 = dayOfEvent = metadataMap.get(event.getPhotos().get(0)).getTimeString().getDay();
        int dayN = dayOfEvent;
        int i = 0;
        while (i < event.getPhotos().size()) {
            int day = metadataMap.get(event.getPhotos().get(i)).getTimeString().getDay();
            if (day < day1) {
                day1 = day;
            }
            if (day > dayN) {
                dayN = day;
            }
            ++i;
        }
        for (Map.Entry<Long, FlickrImageMetadata> flickrEntry : metadataMap.entrySet()) {
            double distance;
            int photoDay = flickrEntry.getValue().getTimeString().getDay();
            if (photoDay < day1 || photoDay > dayN) continue;
            if (usernames.contains(flickrEntry.getValue().getUsername()) && !candidateEventPhotos.contains(flickrEntry.getKey())) {
                candidateEventPhotos.add(flickrEntry.getKey());
            }
            if (event.getLocation() == null || flickrEntry.getValue().getGeo() == null || !((distance = GeodesicDistanceCalculator.distVincenty(event.getLocation(), flickrEntry.getValue().getGeo()).doubleValue()) < 200.0) || candidateEventPhotos.contains(flickrEntry.getKey())) continue;
            candidateEventPhotos.add(flickrEntry.getKey());
        }
        return candidateEventPhotos;
    }

    public static class TimeRankedPhoto
    implements Comparable<TimeRankedPhoto> {
        protected long flickrId;
        protected FlickrDateTimeString date;

        public TimeRankedPhoto(long flickrId, FlickrDateTimeString date) {
            this.flickrId = flickrId;
            this.date = date;
        }

        public long getFlickrId() {
            return this.flickrId;
        }

        public FlickrDateTimeString getDate() {
            return this.date;
        }

        @Override
        public int compareTo(TimeRankedPhoto o) {
            return this.getDate().compareTo(o.getDate());
        }
    }
}

