/*
 * Decompiled with CFR 0.152.
 */
package certh;

import certh.CommonFunctions;
import certh.Config;
import certh.SubmissionCreatorChallenge1;
import dataset.create.PhotoCopy;
import geo.CityClassifier;
import geo.GeodesicDistanceCalculator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import model.FlickrDateTimeString;
import model.FlickrEvent;
import model.FlickrImageMetadata;
import util.io.IOUtil;

public class Challenge1Run1
extends SubmissionCreatorChallenge1 {
    protected final boolean useDescription = true;
    protected static final String SOCCER_TAG_MODEL_FILE = String.valueOf(Config.MEVAL_RESOURCE_DIR) + "soccer_tag_models\\run1_challenge1_v2.txt";
    protected CityClassifier cityClassifier = new CityClassifier();
    protected Set<String> soccerTagModel = new HashSet<String>();

    public Challenge1Run1() {
        this.soccerTagModel.addAll(IOUtil.readFileToStringList(SOCCER_TAG_MODEL_FILE));
    }

    @Override
    protected List<Long> selectCandidateSoccerPhotos(Map<Long, FlickrImageMetadata> imageMetadataMap) {
        ArrayList<Long> candidateSoccerPhotos = new ArrayList<Long>();
        for (Map.Entry<Long, FlickrImageMetadata> flickrEntry : imageMetadataMap.entrySet()) {
            if (Challenge1Run1.belongsToDifferentCity(flickrEntry.getValue(), this.cityClassifier) || !CommonFunctions.isRelatedToSoccerEvent(flickrEntry.getValue(), this.soccerTagModel, true)) continue;
            candidateSoccerPhotos.add(flickrEntry.getKey());
        }
        return candidateSoccerPhotos;
    }

    protected static boolean belongsToDifferentCity(FlickrImageMetadata metadata, CityClassifier cityClassifier) {
        PhotoCopy.MediaevalCity city = cityClassifier.detectCity(metadata);
        return PhotoCopy.MediaevalCity.Amsterdam.equals((Object)city) || PhotoCopy.MediaevalCity.London.equals((Object)city) || PhotoCopy.MediaevalCity.Paris.equals((Object)city);
    }

    @Override
    protected List<FlickrEvent> discoverSoccerEvents(List<Long> candidateSoccerPhotos, Map<Long, FlickrImageMetadata> imageMetadataMap) {
        ArrayList<FlickrEvent> events = new ArrayList<FlickrEvent>();
        HashSet<Integer> differentEventDays = new HashSet<Integer>();
        for (long flickrId : candidateSoccerPhotos) {
            FlickrDateTimeString timeTaken;
            FlickrImageMetadata metadata = imageMetadataMap.get(flickrId);
            if (metadata == null || !CommonFunctions.verifyFlickrPhotoDate(flickrId, timeTaken = metadata.getTimeString())) continue;
            differentEventDays.add(timeTaken.getDay());
        }
        Iterator iterator = differentEventDays.iterator();
        while (iterator.hasNext()) {
            FlickrEvent event;
            int day = (Integer)iterator.next();
            ArrayList<Long> sameDayPhotos = new ArrayList<Long>();
            for (long flickrId : candidateSoccerPhotos) {
                FlickrDateTimeString timeTaken;
                FlickrImageMetadata metadata = imageMetadataMap.get(flickrId);
                if (metadata == null || (timeTaken = metadata.getTimeString()).getDay() != day) continue;
                sameDayPhotos.add(flickrId);
            }
            ArrayList<Long> barcelonaEvent = new ArrayList<Long>();
            ArrayList<Long> romeEvent = new ArrayList<Long>();
            Iterator iterator2 = sameDayPhotos.iterator();
            while (iterator2.hasNext()) {
                long flickrId = (Long)iterator2.next();
                FlickrImageMetadata metadata = imageMetadataMap.get(flickrId);
                if (metadata == null) continue;
                PhotoCopy.MediaevalCity city = this.cityClassifier.detectCity(metadata);
                if (PhotoCopy.MediaevalCity.Barcelona.equals((Object)city)) {
                    barcelonaEvent.add(flickrId);
                }
                if (!PhotoCopy.MediaevalCity.Rome.equals((Object)city)) continue;
                romeEvent.add(flickrId);
            }
            if (barcelonaEvent.size() > 0) {
                event = new FlickrEvent();
                event.addPhotos(barcelonaEvent);
                events.add(event);
            }
            if (romeEvent.size() <= 0) continue;
            event = new FlickrEvent();
            event.addPhotos(romeEvent);
            events.add(event);
        }
        return events;
    }

    @Override
    protected List<List<Long>> expandSoccerEvents(Map<Long, FlickrImageMetadata> imageMetadataMap, List<FlickrEvent> events) {
        ArrayList<List<Long>> results = new ArrayList<List<Long>>(events.size());
        for (FlickrEvent event : events) {
            List<Long> photos = this.enrichCandidateSoccerPhotosForEvent(imageMetadataMap, event);
            results.add(photos);
        }
        return results;
    }

    protected List<Long> enrichCandidateSoccerPhotosForEvent(Map<Long, FlickrImageMetadata> metadataMap, FlickrEvent event) {
        ArrayList<Long> candidateEventPhotos = new ArrayList<Long>(event.getPhotos());
        event.computeLocation(metadataMap);
        event.computeStartEnd(metadataMap);
        HashSet<String> usernames = new HashSet<String>();
        Iterator<Object> iterator = event.getPhotos().iterator();
        while (iterator.hasNext()) {
            long flickrId = iterator.next();
            FlickrImageMetadata metadata = metadataMap.get(flickrId);
            if (metadata == null) continue;
            usernames.add(metadata.getUsername());
        }
        int dayOfEvent = metadataMap.get(event.getPhotos().get(0)).getTimeString().getDay();
        for (Map.Entry entry : metadataMap.entrySet()) {
            double distance;
            if (((FlickrImageMetadata)entry.getValue()).getTimeString().getDay() != dayOfEvent) continue;
            if (usernames.contains(((FlickrImageMetadata)entry.getValue()).getUsername()) && !candidateEventPhotos.contains(entry.getKey())) {
                candidateEventPhotos.add((Long)entry.getKey());
            }
            if (event.getLocation() == null || ((FlickrImageMetadata)entry.getValue()).getGeo() == null || !((distance = GeodesicDistanceCalculator.distVincenty(event.getLocation(), ((FlickrImageMetadata)entry.getValue()).getGeo()).doubleValue()) < 200.0) || candidateEventPhotos.contains(entry.getKey())) continue;
            candidateEventPhotos.add((Long)entry.getKey());
        }
        return candidateEventPhotos;
    }
}

