#!/usr/bin/perl
#
# This script converts a report file (read from STDIN or from a file name
# argument) containing lines of the form:
#
# UnixtimeSec UnixtimeFraction Latitude Longitude BytesRecvd SampleTimeMsec
#
# into a simpler bandwidth log where each line represents the bandwidth in
# kbit/s for *exactly* one second.  Thus, the number of lines in the output
# is equal to the duration of the log in seconds.
#
# The output of this script is the bandwidth log used as input by the
# Apache Throttling Module.
#

use strict;
use warnings;

my $rest_bytes = 0;
my $rest_sampletime = 0;

while (<>) {
    my ($unixtime, $unixtime_frac, $lat, $long, $bytes, $sampletime) = split;
    next if not $sampletime;

    # Add unused bytes and sampletime from the previous entry.
    $bytes += $rest_bytes;
    $sampletime += $rest_sampletime;

    # The average kbit/s for this sample, lasting for $sampletime milliseconds.
    my $kbps = $bytes*8.0 / $sampletime;

    # Sample entries are often more than one second, so split it up into a
    # sequence of kbit/s numbers representing exactly *one* second.
    my $t = $sampletime;
    while ($t >= 1000) {
        printf "%.0f\n", $kbps;
        $t -= 1000;
    }

    # The sub-second rest of the sample entry gets added to the next entry.
    $rest_sampletime = $t;
    $rest_bytes = $bytes * $rest_sampletime/$sampletime;
}
